/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.quest.CUpdateQuestStatePacket;
import xyz.pixelatedw.mineminenomi.screens.TrainerScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class AvailableQuestsListScreenPanel
extends ScrollPanel {
    private TrainerScreen parent;
    private IQuestData props;
    private List<Quest> availableQuests = new ArrayList<Quest>();
    private static final int ENTRY_HEIGHT = 20;
    private FontRenderer font;

    public AvailableQuestsListScreenPanel(TrainerScreen parent, IQuestData abilityProps, Quest[] quests) {
        super(parent.getMinecraft(), 200, 180, parent.height / 2 - 110, parent.width / 2 - 190);
        this.parent = parent;
        this.props = abilityProps;
        this.font = parent.getMinecraft().field_71466_p;
        this.updateAvailableQuests(quests);
        this.scrollDistance = -10.0f;
    }

    public void updateAvailableQuests(List<Quest> quests) {
        Quest[] arr = new Quest[quests.size()];
        Quest[] questsArray = quests.toArray(arr);
        this.updateAvailableQuests(questsArray);
    }

    public void updateAvailableQuests(Quest[] quests) {
        this.availableQuests.clear();
        for (int i = 0; i <= quests.length - 1; ++i) {
            boolean isNotInProgress;
            Quest quest = quests[i];
            boolean exists = quest != null;
            boolean isNotFinished = exists && !this.props.hasFinishedQuest(quest);
            boolean bl = isNotInProgress = exists && (this.props.getInProgressQuest(quest) == null || this.props.getInProgressQuest(quest) != null && this.props.getInProgressQuest(quest).isComplete());
            if (!isNotFinished || !isNotInProgress) continue;
            this.availableQuests.add(quests[i]);
        }
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        return (int)((double)this.availableQuests.size() * 55.0 - 2.0);
    }

    protected int getScrollAmount() {
        return 12;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        Tessellator tess = Tessellator.func_178181_a();
        double scale = this.parent.getMinecraft().func_228018_at_().func_198100_s();
        GL11.glEnable((int)3089);
        GL11.glScissor((int)((int)((double)this.left * scale)), (int)((int)((double)this.parent.getMinecraft().func_228018_at_().func_198091_l() - (double)this.bottom * scale)), (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        int baseY = this.top + 4 - (int)this.scrollDistance;
        this.drawPanel(this.right, baseY, tess, mouseX, mouseY);
        GL11.glDisable((int)3089);
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        for (Quest quest : this.availableQuests) {
            if (quest == null) continue;
            float y = relativeY;
            float x = this.parent.width / 2 - 109 + 40;
            String formattedQuestName = I18n.func_135052_a((String)("quest.mineminenomi." + WyHelper.getResourceName(quest.getId())), (Object[])new Object[0]);
            String questColor = "#FFFFFF";
            Quest inProgressQuest = this.props.getInProgressQuest(quest);
            if (inProgressQuest != null) {
                if (this.isMouseOverQuest(mouseX, mouseY, inProgressQuest) && !inProgressQuest.isComplete()) {
                    formattedQuestName = new TranslationTextComponent(ModI18n.TRAINER_NO_QUESTS_AVAILABLE, new Object[0]).func_150254_d();
                }
                if (inProgressQuest.isComplete()) {
                    questColor = "#00FF55";
                }
            }
            if (quest.isLocked(this.props)) {
                questColor = "#505050";
            }
            if (this.parent.isAnimationComplete() && this.isMouseOverQuest(mouseX, mouseY, quest)) {
                RenderSystem.color3f((float)0.8f, (float)0.8f, (float)0.8f);
            }
            RenderSystem.pushMatrix();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.SCROLL);
            double scale = 0.5;
            RenderSystem.translated((double)(x - 180.0f), (double)(y - 196.0f), (double)0.0);
            RenderSystem.translated((double)256.0, (double)256.0, (double)0.0);
            RenderSystem.scaled((double)(scale * 1.5), (double)(scale * 0.6), (double)0.0);
            RenderSystem.translated((double)-256.0, (double)-256.0, (double)0.0);
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)1.0f);
            RenderSystem.popMatrix();
            if (this.parent.isAnimationComplete()) {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.font.func_78256_a(formattedQuestName) > 140) {
                RenderSystem.pushMatrix();
                List<String> splittedText = WyHelper.splitString(this.font, formattedQuestName, (int)x - 80, 140);
                RenderSystem.translated((double)0.0, (double)(-((splittedText.size() - 1) * 5)), (double)0.0);
                for (String string : splittedText) {
                    WyHelper.drawStringWithBorder(this.font, string, (int)x - 80, (int)y + 16, WyHelper.hexToRGB(questColor).getRGB());
                    y += 10.0f;
                }
                RenderSystem.popMatrix();
            } else {
                WyHelper.drawStringWithBorder(this.font, formattedQuestName, (int)x - 80, (int)y + 16, WyHelper.hexToRGB(questColor).getRGB());
            }
            relativeY = (int)((double)relativeY + 55.0);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Quest quest = this.findQuestEntry((int)mouseX, (int)mouseY);
        Quest inProgressQuest = this.props.getInProgressQuest(quest);
        if (button != 0) {
            return false;
        }
        if (inProgressQuest != null && inProgressQuest.isComplete() && inProgressQuest.triggerCompleteEvent((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.props.addFinishedQuest(inProgressQuest);
            this.props.removeInProgressQuest(inProgressQuest);
            WyNetwork.sendToServer(new CUpdateQuestStatePacket(inProgressQuest, 1));
            this.updateAvailableQuests(this.availableQuests);
        } else if (quest != null && inProgressQuest == null && !quest.isLocked(this.props) && quest.triggerStartEvent((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            this.props.addInProgressQuest(quest);
            WyNetwork.sendToServer(new CUpdateQuestStatePacket(quest, 0));
            this.updateAvailableQuests(this.availableQuests);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isMouseOverQuest(double mouseX, double mouseY, Quest overQuest) {
        Quest quest = this.findQuestEntry((int)mouseX, (int)mouseY);
        if (quest != null && quest.equals((Object)overQuest)) {
            return super.isMouseOver(mouseX, mouseY);
        }
        return false;
    }

    private Quest findQuestEntry(int mouseX, int mouseY) {
        boolean isHovered;
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        boolean bl = isHovered = mouseX >= this.left && mouseY >= this.top && mouseX < this.left + this.width - 5 && mouseY < this.top + this.height;
        if (offset <= 0.0 || !isHovered) {
            return null;
        }
        int lineIdx = (int)(offset / 55.0);
        if (lineIdx >= this.availableQuests.size()) {
            return null;
        }
        Quest quest = this.availableQuests.get(lineIdx);
        if (quest != null) {
            return quest.create();
        }
        return null;
    }
}

