/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.camp.bandit;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BanditCampPieces {
    private static final ResourceLocation SMALL_TENT = new ResourceLocation("mineminenomi", "bandit/small_tent");
    private static final ResourceLocation LARGE_TENT = new ResourceLocation("mineminenomi", "bandit/large_tent");
    private static final ResourceLocation FIRE_PLACE = new ResourceLocation("mineminenomi", "props/fire_place");
    private static final Map<ResourceLocation, BlockPos> CENTER_OFFSET = ImmutableMap.of((Object)SMALL_TENT, (Object)new BlockPos(3, 0, 3), (Object)LARGE_TENT, (Object)new BlockPos(0, 0, 0), (Object)FIRE_PLACE, (Object)new BlockPos(0, 0, 0));

    public static void addComponents(TemplateManager templateManager, BlockPos pos, Random rand, List<StructurePiece> components) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        boolean hasExtraTents = false;
        if (WyHelper.randomDouble() < 0.1) {
            hasExtraTents = true;
        }
        components.add((StructurePiece)new Piece(templateManager, FIRE_PLACE, pos, Rotation.CLOCKWISE_90, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
        components.add((StructurePiece)new Piece(templateManager, LARGE_TENT, pos.func_177982_a(13, 0, 0), Rotation.CLOCKWISE_90, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
        if (hasExtraTents) {
            components.add((StructurePiece)new Piece(templateManager, LARGE_TENT, pos.func_177982_a(-19, 0, 6), Rotation.COUNTERCLOCKWISE_90, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
            list.add(pos.func_177982_a(-19, 0, 6));
        }
        list.add(pos.func_177982_a(13, 0, 0));
        for (int i = 0; i < (hasExtraTents ? 6 : 4); ++i) {
            BlockPos piecePos = BanditCampPieces.trySpawnTent(pos, 0, list);
            if (piecePos == null) continue;
            components.add((StructurePiece)new Piece(templateManager, SMALL_TENT, piecePos, Rotation.func_222466_a((Random)rand), (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
            list.add(piecePos);
        }
    }

    private static BlockPos trySpawnTent(BlockPos pos, int attempts, List<BlockPos> list) {
        if (attempts > 20) {
            return null;
        }
        for (BlockPos tentPos : list) {
            if (!(Math.sqrt(tentPos.func_177951_i((Vec3i)pos)) < 9.0)) continue;
            return BanditCampPieces.trySpawnTent(pos, ++attempts, list);
        }
        BlockPos random = new BlockPos(WyHelper.randomWithRange(-40, 40), 0.0, WyHelper.randomWithRange(-40, 40));
        BlockPos piecePos = pos.func_177982_a(random.func_177958_n(), 0, random.func_177952_p());
        if (Math.sqrt(pos.func_177951_i((Vec3i)piecePos)) < 15.0) {
            return BanditCampPieces.trySpawnTent(pos, ++attempts, list);
        }
        return piecePos;
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;
        private StructureProcessor processor;

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(ModFeatures.Pieces.BANDIT_CAMP_PIECE, nbt);
            this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.processor = BlockIgnoreStructureProcessor.field_215204_a;
            this.build(template);
        }

        public Piece(TemplateManager template, ResourceLocation res, BlockPos pos, Rotation rot, StructureProcessor proc) {
            super(ModFeatures.Pieces.BANDIT_CAMP_PIECE, 0);
            this.rotation = rot;
            this.resourceLocation = res;
            this.field_186178_c = pos;
            this.processor = proc;
            this.build(template);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.resourceLocation.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a(this.processor);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.equals("small_tent_chest")) {
                StructuresHelper.spawnLoot(world, pos, ModLootTables.CAMP_SMALL_TENT_CHEST);
            }
            if (function.equals("large_tent_chest")) {
                StructuresHelper.spawnLoot(world, pos, ModLootTables.CAMP_LARGE_TENT_CHEST);
            }
            if (function.equals("small_tent_spawn")) {
                StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.GRUNT, 2);
            }
            if (function.equals("large_tent_spawn")) {
                StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.BANDIT, StructuresHelper.StructureSpawnType.CAPTAIN, 2);
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox bb, ChunkPos chunkPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a(this.processor);
            BlockPos offset = new BlockPos(0, 0, 0);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p())));
            BlockPos blockpos2 = this.field_186178_c;
            int i = world.func_201676_a(Heightmap.Type.WORLD_SURFACE_WG, this.field_186178_c.func_177958_n(), this.field_186178_c.func_177952_p());
            this.field_186178_c = this.field_186178_c.func_177982_a(0, i - 90 - 1, 0);
            boolean flag = super.func_225577_a_(world, generator, random, bb, chunkPos);
            this.field_186178_c = blockpos2;
            return flag;
        }
    }
}

