/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.smallship.pirate;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;

public class PirateSmallShipPieces {
    private static final ResourceLocation PIECE = new ResourceLocation("mineminenomi", "pirate/small_ship");
    private static final Map<ResourceLocation, BlockPos> POSITION_OFFSET = ImmutableMap.builder().put((Object)PIECE, (Object)BlockPos.field_177992_a).build();
    private static final Map<ResourceLocation, BlockPos> CENTER_OFFSET = ImmutableMap.builder().put((Object)PIECE, (Object)BlockPos.field_177992_a).build();

    public static void addComponents(TemplateManager templateManager, BlockPos pos, Rotation rot, List<StructurePiece> components) {
        components.add((StructurePiece)new Piece(templateManager, PIECE, pos, rot));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(ModFeatures.Pieces.PIRATE_SMALL_SHIP_PIECE, nbt);
            this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            this.build(template);
        }

        public Piece(TemplateManager template, ResourceLocation res, BlockPos pos, Rotation rot) {
            super(ModFeatures.Pieces.PIRATE_SMALL_SHIP_PIECE, 0);
            this.rotation = rot;
            this.resourceLocation = res;
            BlockPos blockpos = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.build(template);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.resourceLocation.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.equals("supplies_chest")) {
                StructuresHelper.spawnLoot(world, pos, ModLootTables.SMALL_PIRATE_SHIP_SUPPLIES_CHEST);
            }
            if (function.equals("deck_spawn_1")) {
                StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 2);
            }
            if (function.equals("deck_spawn_2")) {
                StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.PIRATE, StructuresHelper.StructureSpawnType.GRUNT, 2);
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox bb, ChunkPos chunkPos) {
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a((StructureProcessor)BlockIgnoreStructureProcessor.field_215206_c);
            BlockPos offset = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p())));
            return super.func_225577_a_(world, generator, random, bb, chunkPos);
        }
    }
}

