/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.abilities;

import java.io.Serializable;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SAnimeScreamPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public abstract class Ability
extends ForgeRegistryEntry<Ability> {
    private String name = "";
    private String displayName;
    private String textureName = "";
    private ITextComponent tooltip;
    protected double cooldown;
    protected double maxCooldown;
    protected double disableTicks;
    protected double maxDisableTicks = 200.0;
    private APIConfig.AbilityCategory category = APIConfig.AbilityCategory.ALL;
    private AbilityUnlock unlock = AbilityUnlock.PROGRESSION;
    private State state = State.STANDBY;
    private State previousState = State.STANDBY;
    private boolean hideInGUI = false;
    private boolean forcedState = false;
    private int poolId = -1;
    protected final Random random = new Random();
    protected IOnUse onUseEvent = player -> true;
    protected IDuringCooldown duringCooldownEvent = (player, cooldown) -> {};
    protected IOnEndCooldown onEndCooldownEvent = player -> {};

    public Ability(String name, APIConfig.AbilityCategory category) {
        this.name = name;
        this.category = category;
    }

    public void use(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        player.field_70170_p.func_217381_Z().func_76320_a(WyHelper.getResourceName(this.getName()));
        if (this.isOnCooldown() && this.getCooldown() <= 10.0) {
            this.stopCooldown(player);
        }
        if (!this.isOnStandby()) {
            return;
        }
        AbilityUseEvent event = new AbilityUseEvent(player, this);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        if (!this.isStateForced() && this.onUseEvent.onUse(player)) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            this.checkAbilityPool(player, State.COOLDOWN);
            if (((Boolean)CommonConfig.INSTANCE.animeScreaming.get()).booleanValue()) {
                WyNetwork.sendToAllTrackingAndSelf(new SAnimeScreamPacket(player.func_145782_y(), this.getDisplayName()), (LivingEntity)player);
            }
            this.startCooldown(player);
            props.setPreviouslyUsedAbility(this);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    public boolean isOnStandby() {
        return this.state == State.STANDBY;
    }

    public boolean isOnCooldown() {
        return this.state == State.COOLDOWN;
    }

    public boolean isPassiveEnabled() {
        return this.state == State.PASSIVE;
    }

    public boolean isContinuous() {
        return this.state == State.CONTINUOUS && !this.isStateForced();
    }

    public boolean isCharging() {
        return this.state == State.CHARGING && !this.isStateForced();
    }

    public boolean isDisabled() {
        return this.state == State.DISABLED;
    }

    public void startStandby() {
        this.previousState = this.state;
        this.state = State.STANDBY;
    }

    public void startDisable() {
        this.startDisable(20);
    }

    public void startDisable(int ticks) {
        this.previousState = this.state;
        this.state = State.DISABLED;
        this.disableTicks = this.maxDisableTicks = (double)ticks;
    }

    public double getDisableTicks() {
        return this.disableTicks;
    }

    public void setDisableTicks(double ticks) {
        this.disableTicks = ticks;
    }

    public void startCooldown(PlayerEntity player) {
        this.previousState = this.state;
        this.state = State.COOLDOWN;
    }

    public void stopCooldown(PlayerEntity player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.checkAbilityPool(player, State.STANDBY);
        this.cooldown = this.maxCooldown;
        this.previousState = this.state;
        this.state = State.STANDBY;
        if (!this.isStateForced()) {
            this.onEndCooldownEvent.onEndCooldown(player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        }
        this.setForcedState(false);
    }

    public void setState(State state) {
        this.previousState = this.state;
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public State getPreviousState() {
        return this.previousState;
    }

    public void setForcedState(boolean flag) {
        this.forcedState = flag;
    }

    public boolean isStateForced() {
        return this.forcedState;
    }

    public void hideInGUI(boolean flag) {
        this.hideInGUI = flag;
    }

    public boolean isHideInGUI() {
        return this.hideInGUI;
    }

    public void setInPool(AbilityPool pool) {
        this.setInPool(pool.getId());
    }

    public void setInPool(int poolId) {
        this.poolId = poolId;
    }

    public int getPoolId() {
        return this.poolId;
    }

    public boolean isInPool() {
        return ((Boolean)CommonConfig.INSTANCE.sharedCooldowns.get()).booleanValue() ? this.poolId > 0 : false;
    }

    public void setMaxCooldown(double cooldown) {
        this.cooldown = this.maxCooldown = cooldown * 20.0;
    }

    public double getMaxCooldown() {
        return this.maxCooldown;
    }

    public void setCooldown(double cooldown) {
        this.cooldown = cooldown * 20.0;
    }

    public double getCooldown() {
        return this.cooldown;
    }

    public void setDescription(String desc) {
        this.tooltip = new StringTextComponent(desc);
    }

    public void setDescription(ITextComponent tooltip) {
        this.tooltip = tooltip;
    }

    public ITextComponent getDescription() {
        return this.tooltip;
    }

    public String getName() {
        return this.name;
    }

    public String getI18nKey() {
        String resourceName = WyHelper.getResourceName(this.getName());
        return "ability." + APIConfig.projectId + "." + resourceName;
    }

    public String getDisplayName() {
        return !WyHelper.isNullOrEmpty(this.displayName) ? this.displayName : this.getName();
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public boolean hasCustomTexture() {
        return !WyHelper.isNullOrEmpty(this.textureName);
    }

    public String getCustomTexture() {
        return this.textureName;
    }

    public void setCustomTexture(String texture) {
        this.textureName = WyHelper.getResourceName(texture);
    }

    public APIConfig.AbilityCategory getCategory() {
        return this.category;
    }

    public void setUnlockType(AbilityUnlock unlockType) {
        this.unlock = unlockType;
    }

    public AbilityUnlock getUnlockType() {
        return this.unlock;
    }

    public void disableTick(PlayerEntity player) {
        if (this.isDisabled() && this.disableTicks > 0.0) {
            this.disableTicks -= 1.0;
        }
    }

    public void cooldown(PlayerEntity player) {
        player.field_70170_p.func_217381_Z().func_76320_a(WyHelper.getResourceName(this.getName()));
        if (this.isOnCooldown() && this.cooldown > 0.0) {
            this.cooldown -= 1.0;
            if (!player.field_70170_p.field_72995_K && this.getPreviousState() != State.DISABLED && !this.isStateForced()) {
                this.duringCooldownEvent.duringCooldown(player, (int)this.cooldown);
            }
        } else if (this.isOnCooldown() && this.cooldown <= 0.0) {
            this.stopCooldown(player);
        }
        player.field_70170_p.func_217381_Z().func_76319_b();
    }

    public void checkAbilityPool(PlayerEntity player, State state) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (this.isInPool() && !this.isStateForced()) {
            for (Ability abl : props.getEquippedAbilities()) {
                if (abl == null || abl == this || !abl.isInPool() || abl.getPoolId() != this.getPoolId()) continue;
                double[] values = null;
                boolean forced = true;
                if (state == State.COOLDOWN) {
                    values = new double[]{this.getCooldown() / 20.0, this.getCooldown() / 20.0};
                } else if (state == State.CHARGING && abl instanceof ChargeableAbility && this instanceof ChargeableAbility) {
                    values = new double[]{((ChargeableAbility)this).getChargeTime() / 20, ((ChargeableAbility)this).getMaxChargeTime() / 20};
                } else if (state == State.CONTINUOUS && abl instanceof ContinuousAbility && this instanceof ContinuousAbility) {
                    values = new double[]{((ContinuousAbility)this).getContinueTime() / 20, ((ContinuousAbility)this).getThreshold() / 20};
                } else if (state == State.STANDBY) {
                    forced = false;
                }
                abl.previousState = this.getState();
                abl.state = state;
                abl.forcedState = forced;
                if (values != null) {
                    WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, abl, state, values), (LivingEntity)player);
                    continue;
                }
                WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, abl), (LivingEntity)player);
            }
        }
    }

    public double getCooldownPercentage() {
        return this.cooldown / this.maxCooldown * 100.0;
    }

    public double getInvertedCooldownPercentage() {
        return (1.0 - this.cooldown / this.maxCooldown) * 100.0;
    }

    public boolean equals(Object abl) {
        if (!(abl instanceof Ability)) {
            return false;
        }
        return this.getName().equalsIgnoreCase(((Ability)((Object)abl)).getName());
    }

    @Nullable
    public Ability create() {
        try {
            return (Ability)((Object)((Object)((Object)this)).getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            System.out.println("Exception raised for " + this.getDisplayName());
            ex.printStackTrace();
            return null;
        }
    }

    @Nullable
    public static Ability get(ResourceLocation res) {
        Ability ability = (Ability)GameRegistry.findRegistry(Ability.class).getValue(res);
        return ability;
    }

    public boolean canUse(PlayerEntity player) {
        ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
        if (worldData.isInsideRestrictedArea(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p())) {
            boolean isWhitelsited = CommonConfig.INSTANCE.getProtectionWhitelistedAbilities().contains((Object)this);
            if (isWhitelsited) {
                return true;
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_CANNOT_USE_HERE, new Object[0]));
            return false;
        }
        return true;
    }

    public static interface IOnEndCooldown
    extends Serializable {
        public void onEndCooldown(PlayerEntity var1);
    }

    public static interface IDuringCooldown
    extends Serializable {
        public void duringCooldown(PlayerEntity var1, int var2);
    }

    public static interface IOnUse
    extends Serializable {
        public boolean onUse(PlayerEntity var1);
    }

    public static enum State {
        STANDBY,
        DISABLED,
        COOLDOWN,
        PASSIVE,
        CONTINUOUS,
        CHARGING;

    }
}

