/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.wypi.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.ConstantRange;
import net.minecraft.world.storage.loot.IRandomRange;
import net.minecraft.world.storage.loot.ItemLootEntry;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.functions.ApplyBonus;
import net.minecraft.world.storage.loot.functions.ILootFunction;
import net.minecraft.world.storage.loot.functions.SetCount;

public abstract class LootTablesDataGen
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
    private DataGenerator generator;

    public LootTablesDataGen(DataGenerator dataGenerator) {
        super(dataGenerator);
        this.generator = dataGenerator;
    }

    public abstract void registerLootTables();

    protected LootPool.Builder createBasicLootPool(Item drop, int roll, float count) {
        return this.createBasicLootPool(drop, roll, roll, count, count);
    }

    protected LootPool.Builder createBasicLootPool(Item drop, int rollMin, int rollMax, float countMin, float countMax) {
        Object rollRange = rollMin == rollMax ? ConstantRange.func_215835_a((int)rollMin) : RandomValueRange.func_215837_a((float)rollMin, (float)rollMax);
        Object countRange = countMin == countMax ? ConstantRange.func_215835_a((int)((int)countMin)) : RandomValueRange.func_215837_a((float)countMin, (float)countMax);
        return LootPool.func_216096_a().func_216046_a((IRandomRange)rollRange).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)drop).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)countRange)));
    }

    protected LootPool.Builder createSelfDropLootPool(Block block) {
        return LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block.func_199767_j()).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)ConstantRange.func_215835_a((int)1))));
    }

    protected LootPool.Builder createOreLootPool(Item ore, int roll, float count) {
        return this.createOreLootPool(ore, roll, roll, count, count);
    }

    protected LootPool.Builder createOreLootPool(Item ore, int rollMin, int rollMax, float countMin, float countMax) {
        Object rollRange = rollMin == rollMax ? ConstantRange.func_215835_a((int)rollMin) : RandomValueRange.func_215837_a((float)rollMin, (float)rollMax);
        Object countRange = countMin == countMax ? ConstantRange.func_215835_a((int)((int)countMin)) : RandomValueRange.func_215837_a((float)countMin, (float)countMax);
        return LootPool.func_216096_a().func_216046_a((IRandomRange)rollRange).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)ore).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)countRange)).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t)));
    }

    protected void addLootTable(Block block, LootPool.Builder ... pools) {
        LootTable.Builder builder = LootTable.func_216119_b();
        for (LootPool.Builder pool : pools) {
            builder.func_216040_a(pool);
        }
        this.lootTables.put(block, builder);
    }

    public void func_200398_a(DirectoryCache cache) {
        this.registerLootTables();
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : this.lootTables.entrySet()) {
            tables.put(entry.getKey().func_220068_i(), entry.getValue().func_216039_a(LootParameterSets.field_216267_h).func_216038_b());
        }
        this.writeTables(cache, tables);
    }

    private void writeTables(DirectoryCache cache, Map<ResourceLocation, LootTable> tables) {
        Path outputFolder = this.generator.func_200391_b();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.func_110624_b() + "/loot_tables/" + key.func_110623_a() + ".json");
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)LootTableManager.func_215301_a((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public String func_200397_b() {
        return "Loot Tables";
    }
}

