/*
 * Decompiled with CFR 0.152.
 */
package com.mcwbridges.kikoz.objects;

import com.mcwbridges.kikoz.objects.PillarParts;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import org.antlr.v4.runtime.misc.NotNull;

public class PillarBase
extends Block
implements IWaterLoggable {
    private static final EnumProperty<PillarParts> PART = EnumProperty.func_177709_a((String)"part", PillarParts.class);
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape MIDDLE_NS = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)11.5, (double)7.0, (double)16.0, (double)15.5, (double)9.0), (VoxelShape[])new VoxelShape[0]).func_197753_c();
    protected static final VoxelShape MIDDLE_WE = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)7.0, (double)11.5, (double)0.0, (double)9.0, (double)15.5, (double)16.0), (VoxelShape[])new VoxelShape[0]).func_197753_c();
    protected static final VoxelShape NORTH = Stream.of(Block.func_208617_a((double)5.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0, (double)15.0), Block.func_208617_a((double)5.0, (double)12.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0), Block.func_208617_a((double)6.3, (double)0.0, (double)4.0, (double)6.6, (double)12.0, (double)12.0), Block.func_208617_a((double)5.0, (double)0.0, (double)1.0, (double)8.0, (double)16.0, (double)4.0), Block.func_208617_a((double)8.0, (double)11.5, (double)7.0, (double)16.0, (double)15.5, (double)9.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape EAST = Stream.of(Block.func_208617_a((double)0.9899999999999999, (double)0.0, (double)4.910000000000002, (double)3.99, (double)16.0, (double)7.910000000000002), Block.func_208617_a((double)3.99, (double)12.0, (double)4.910000000000002, (double)11.989999999999998, (double)16.0, (double)7.910000000000002), Block.func_208617_a((double)3.99, (double)0.0, (double)6.210000000000002, (double)11.989999999999998, (double)12.0, (double)6.510000000000002), Block.func_208617_a((double)11.989999999999998, (double)0.0, (double)4.910000000000002, (double)14.989999999999998, (double)16.0, (double)7.910000000000002), Block.func_208617_a((double)6.989999999999998, (double)11.5, (double)7.910000000000002, (double)8.989999999999998, (double)15.5, (double)15.909999999999995)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape SOUTH = Stream.of(Block.func_208617_a((double)7.979999999999997, (double)0.0, (double)1.0000000000000036, (double)10.979999999999997, (double)16.0, (double)4.0000000000000036), Block.func_208617_a((double)7.979999999999997, (double)12.0, (double)4.0000000000000036, (double)10.979999999999997, (double)16.0, (double)12.0), Block.func_208617_a((double)9.379999999999997, (double)0.0, (double)4.0000000000000036, (double)9.679999999999996, (double)12.0, (double)12.0), Block.func_208617_a((double)7.979999999999997, (double)0.0, (double)12.0, (double)10.979999999999997, (double)16.0, (double)15.0), Block.func_208617_a((double)-0.019999999999994605, (double)11.5, (double)7.0, (double)7.979999999999997, (double)15.5, (double)9.0)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();
    protected static final VoxelShape WEST = Stream.of(Block.func_208617_a((double)11.989999999999995, (double)0.0, (double)7.989999999999998, (double)14.989999999999995, (double)16.0, (double)10.989999999999998), Block.func_208617_a((double)3.989999999999998, (double)12.0, (double)7.989999999999998, (double)11.989999999999995, (double)16.0, (double)10.989999999999998), Block.func_208617_a((double)3.989999999999998, (double)0.0, (double)9.389999999999999, (double)11.989999999999995, (double)12.0, (double)9.689999999999998), Block.func_208617_a((double)0.9899999999999968, (double)0.0, (double)7.989999999999998, (double)3.989999999999998, (double)16.0, (double)10.989999999999998), Block.func_208617_a((double)6.989999999999998, (double)11.5, (double)-0.009999999999991266, (double)8.989999999999998, (double)15.5, (double)7.989999999999998)).reduce((v1, v2) -> VoxelShapes.func_197878_a((VoxelShape)v1, (VoxelShape)v2, (IBooleanFunction)IBooleanFunction.field_223244_o_)).get();

    public VoxelShape func_220053_a(BlockState state, IBlockReader blockReader, BlockPos pos, ISelectionContext selectionContext) {
        switch ((Direction)state.func_177229_b((IProperty)FACING)) {
            case SOUTH: {
                PillarParts part1 = (PillarParts)((Object)state.func_177229_b(PART));
                if (part1 == PillarParts.MIDDLE) {
                    return MIDDLE_NS;
                }
                if (part1 == PillarParts.LEFT) {
                    return NORTH;
                }
                return SOUTH;
            }
            case NORTH: {
                PillarParts part2 = (PillarParts)((Object)state.func_177229_b(PART));
                if (part2 == PillarParts.MIDDLE) {
                    return MIDDLE_NS;
                }
                if (part2 == PillarParts.LEFT) {
                    return SOUTH;
                }
                return NORTH;
            }
            case WEST: {
                PillarParts part3 = (PillarParts)((Object)state.func_177229_b(PART));
                if (part3 == PillarParts.MIDDLE) {
                    return MIDDLE_WE;
                }
                if (part3 == PillarParts.LEFT) {
                    return EAST;
                }
                return WEST;
            }
        }
        PillarParts part4 = (PillarParts)((Object)state.func_177229_b(PART));
        if (part4 == PillarParts.MIDDLE) {
            return MIDDLE_WE;
        }
        if (part4 == PillarParts.LEFT) {
            return WEST;
        }
        return EAST;
    }

    public PillarBase(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(PART, (Comparable)((Object)PillarParts.MIDDLE)));
    }

    public ToolType getHarvestTool(BlockState state) {
        if (this.field_149764_J == Material.field_151575_d || this.field_149764_J == Material.field_215713_z) {
            return ToolType.AXE;
        }
        return ToolType.PICKAXE;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (entity != null) {
            BlockPos portalWarpBottomLeftPos = this.getPortalWarpBottomLeftPos(pos, entity.func_174811_aO());
            BlockPos portalWarpBottomRightPos = this.getPortalWarpBottomRightPos(pos, entity.func_174811_aO());
            IFluidState bottomWestFluidState = world.func_204610_c(pos.func_177976_e());
            IFluidState bottomEastFluidState = world.func_204610_c(pos.func_177974_f());
            world.func_180501_a(portalWarpBottomLeftPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)PillarParts.LEFT))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(bottomWestFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
            world.func_180501_a(portalWarpBottomRightPos, (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)PillarParts.RIGHT))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(bottomEastFluidState.func_206886_c() == Fluids.field_204546_a)), 3);
        }
    }

    public void func_176208_a(World world, @NotNull BlockPos pos, BlockState state, @NotNull PlayerEntity player) {
        Direction facing = (Direction)state.func_177229_b((IProperty)FACING);
        BlockPos portalWarpPos = this.getPortalWarpPos(pos, (PillarParts)((Object)state.func_177229_b(PART)), facing);
        BlockState PortalWarpBlockState = world.func_180495_p(portalWarpPos);
        if (PortalWarpBlockState.func_177230_c() == this && !pos.equals((Object)portalWarpPos)) {
            this.removePart(world, portalWarpPos, PortalWarpBlockState);
        }
        BlockPos portalWarpPartPos = this.getPortalWarpBottomLeftPos(portalWarpPos, facing);
        portalWarpPartPos = this.getPortalWarpBottomLeftPos(portalWarpPos, facing);
        PortalWarpBlockState = world.func_180495_p(portalWarpPartPos);
        if (PortalWarpBlockState.func_177230_c() == this && !pos.equals((Object)portalWarpPartPos)) {
            this.removePart(world, portalWarpPartPos, PortalWarpBlockState);
        }
        if ((PortalWarpBlockState = world.func_180495_p(portalWarpPartPos = this.getPortalWarpBottomRightPos(portalWarpPos, facing))).func_177230_c() == this && !pos.equals((Object)portalWarpPartPos)) {
            this.removePart(world, portalWarpPartPos, PortalWarpBlockState);
        }
        super.func_176208_a(world, pos, state, player);
    }

    private BlockPos getPortalWarpBottomLeftPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177976_e();
            }
            case EAST: {
                return base.func_177978_c();
            }
            case SOUTH: {
                return base.func_177974_f();
            }
            case WEST: {
                return base.func_177968_d();
            }
        }
        return base.func_177974_f();
    }

    private BlockPos getPortalWarpBottomRightPos(BlockPos base, Direction facing) {
        switch (facing) {
            case NORTH: {
                return base.func_177974_f();
            }
            case EAST: {
                return base.func_177968_d();
            }
            case SOUTH: {
                return base.func_177976_e();
            }
            case WEST: {
                return base.func_177978_c();
            }
        }
        return base.func_177976_e();
    }

    private BlockPos getPortalWarpPos(BlockPos pos, PillarParts part, Direction facing) {
        if (part == PillarParts.MIDDLE) {
            return pos;
        }
        switch (facing) {
            case NORTH: {
                switch (part) {
                    case LEFT: {
                        return pos.func_177976_e();
                    }
                    case RIGHT: {
                        return pos.func_177974_f();
                    }
                }
                return null;
            }
            case EAST: {
                switch (part) {
                    case LEFT: {
                        return pos.func_177978_c();
                    }
                    case RIGHT: {
                        return pos.func_177968_d();
                    }
                }
                return null;
            }
            case SOUTH: {
                switch (part) {
                    case LEFT: {
                        return pos.func_177974_f();
                    }
                    case RIGHT: {
                        return pos.func_177976_e();
                    }
                }
                return null;
            }
            case WEST: {
                switch (part) {
                    case LEFT: {
                        return pos.func_177968_d();
                    }
                    case RIGHT: {
                        return pos.func_177978_c();
                    }
                }
                return null;
            }
        }
        return null;
    }

    private void removePart(World world, BlockPos pos, BlockState state) {
        IFluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206886_c() == Fluids.field_204546_a) {
            world.func_180501_a(pos, fluidState.func_206883_i(), 35);
        } else {
            world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 35);
        }
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockPos pos = context.func_195995_a();
        BlockPos portalWarpBottomLeftPos = this.getPortalWarpBottomLeftPos(pos, context.func_195992_f().func_176734_d());
        BlockPos portalWarpBottomRightPos = this.getPortalWarpBottomRightPos(pos, context.func_195992_f().func_176734_d());
        if (pos.func_177956_o() < 255 && portalWarpBottomLeftPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(portalWarpBottomLeftPos).func_196953_a(context) && portalWarpBottomRightPos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(portalWarpBottomRightPos).func_196953_a(context)) {
            return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(PART, (Comparable)((Object)PillarParts.MIDDLE))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8));
        }
        return null;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{PART, FACING, WATERLOGGED});
    }
}

