/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.abnormals_core.client.tile;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.teamabnormals.abnormals_core.core.library.api.IChestBlock;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Calendar;
import net.minecraft.block.AbstractChestBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.DualBrightnessCallback;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMerger;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class AbnormalsChestTileEntityRenderer<T extends TileEntity>
extends TileEntityRenderer<T> {
    public static Block itemBlock = null;
    public final ModelRenderer singleLid;
    public final ModelRenderer singleBottom;
    public final ModelRenderer singleLatch;
    public final ModelRenderer rightLid;
    public final ModelRenderer rightBottom;
    public final ModelRenderer rightLatch;
    public final ModelRenderer leftLid;
    public final ModelRenderer leftBottom;
    public final ModelRenderer leftLatch;
    public boolean isChristmas;

    public AbnormalsChestTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
        this.singleBottom = new ModelRenderer(64, 64, 0, 19);
        this.singleBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 14.0f, 10.0f, 14.0f, 0.0f);
        this.singleLid = new ModelRenderer(64, 64, 0, 0);
        this.singleLid.func_228301_a_(1.0f, 0.0f, 0.0f, 14.0f, 5.0f, 14.0f, 0.0f);
        this.singleLid.field_78797_d = 9.0f;
        this.singleLid.field_78798_e = 1.0f;
        this.singleLatch = new ModelRenderer(64, 64, 0, 0);
        this.singleLatch.func_228301_a_(7.0f, -1.0f, 15.0f, 2.0f, 4.0f, 1.0f, 0.0f);
        this.singleLatch.field_78797_d = 8.0f;
        this.rightBottom = new ModelRenderer(64, 64, 0, 19);
        this.rightBottom.func_228301_a_(1.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.rightLid = new ModelRenderer(64, 64, 0, 0);
        this.rightLid.func_228301_a_(1.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.rightLid.field_78797_d = 9.0f;
        this.rightLid.field_78798_e = 1.0f;
        this.rightLatch = new ModelRenderer(64, 64, 0, 0);
        this.rightLatch.func_228301_a_(15.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.rightLatch.field_78797_d = 8.0f;
        this.leftBottom = new ModelRenderer(64, 64, 0, 19);
        this.leftBottom.func_228301_a_(0.0f, 0.0f, 1.0f, 15.0f, 10.0f, 14.0f, 0.0f);
        this.leftLid = new ModelRenderer(64, 64, 0, 0);
        this.leftLid.func_228301_a_(0.0f, 0.0f, 0.0f, 15.0f, 5.0f, 14.0f, 0.0f);
        this.leftLid.field_78797_d = 9.0f;
        this.leftLid.field_78798_e = 1.0f;
        this.leftLatch = new ModelRenderer(64, 64, 0, 0);
        this.leftLatch.func_228301_a_(0.0f, -1.0f, 15.0f, 1.0f, 4.0f, 1.0f, 0.0f);
        this.leftLatch.field_78797_d = 8.0f;
    }

    public void func_225616_a_(T tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        World world = tileEntityIn.func_145831_w();
        boolean flag = world != null;
        BlockState blockstate = flag ? tileEntityIn.func_195044_w() : (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)ChestBlock.field_176459_a, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.func_196959_b((IProperty)ChestBlock.field_196314_b) ? (ChestType)blockstate.func_177229_b((IProperty)ChestBlock.field_196314_b) : ChestType.SINGLE;
        Block block = blockstate.func_177230_c();
        if (block instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)block;
            boolean flag1 = chesttype != ChestType.SINGLE;
            matrixStackIn.func_227860_a_();
            float f = ((Direction)blockstate.func_177229_b((IProperty)ChestBlock.field_176459_a)).func_185119_l();
            matrixStackIn.func_227861_a_(0.5, 0.5, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-f));
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            TileEntityMerger.ICallbackWrapper icallbackwrapper = flag ? abstractchestblock.func_225536_a_(blockstate, world, tileEntityIn.func_174877_v(), true) : TileEntityMerger.ICallback::func_225537_b_;
            float f1 = ((Float2FloatFunction)icallbackwrapper.apply(ChestBlock.func_226917_a_((IChestLid)((IChestLid)tileEntityIn)))).get(partialTicks);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)icallbackwrapper.apply((TileEntityMerger.ICallback)new DualBrightnessCallback())).applyAsInt(combinedLightIn);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)this.getChestTexture(tileEntityIn, chesttype)));
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.leftLid, this.leftLatch, this.leftBottom, f1, i, combinedOverlayIn);
                } else {
                    this.func_228871_a_(matrixStackIn, ivertexbuilder, this.rightLid, this.rightLatch, this.rightBottom, f1, i, combinedOverlayIn);
                }
            } else {
                this.func_228871_a_(matrixStackIn, ivertexbuilder, this.singleLid, this.singleLatch, this.singleBottom, f1, i, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getChestTexture(T t, ChestType type) {
        Block inventoryBlock = itemBlock;
        if (inventoryBlock == null) {
            inventoryBlock = t.func_195044_w().func_177230_c();
        }
        IChestBlock block = (IChestBlock)inventoryBlock;
        String chestType = block.getChestName() + (block.isTrapped() ? "/trapped" : "/normal");
        String modid = block.getModid();
        if (this.isChristmas) {
            chestType = "christmas";
            modid = "minecraft";
        }
        switch (type) {
            default: {
                return new ResourceLocation(modid, "textures/entity/chest/" + chestType + ".png");
            }
            case LEFT: {
                return new ResourceLocation(modid, "textures/entity/chest/" + chestType + "_left.png");
            }
            case RIGHT: 
        }
        return new ResourceLocation(modid, "textures/entity/chest/" + chestType + "_right.png");
    }

    public void func_228871_a_(MatrixStack matrixStack, IVertexBuilder builder, ModelRenderer chestLid, ModelRenderer chestLatch, ModelRenderer chestBottom, float lidAngle, int combinedLightIn, int combinedOverlayIn) {
        chestLatch.field_78795_f = chestLid.field_78795_f = -(lidAngle * 1.5707964f);
        chestLid.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestLatch.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
        chestBottom.func_228308_a_(matrixStack, builder, combinedLightIn, combinedOverlayIn);
    }
}

