/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.upgrade_aquatic.core.events;

import com.teamabnormals.abnormals_core.core.utils.TradeUtils;
import com.teamabnormals.upgrade_aquatic.api.util.UAEntityPredicates;
import com.teamabnormals.upgrade_aquatic.common.advancement.UACriteriaTriggers;
import com.teamabnormals.upgrade_aquatic.common.blocks.BlockBedroll;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityLionfish;
import com.teamabnormals.upgrade_aquatic.common.entities.EntityPike;
import com.teamabnormals.upgrade_aquatic.common.entities.thrasher.EntityThrasher;
import com.teamabnormals.upgrade_aquatic.core.registry.UABlocks;
import com.teamabnormals.upgrade_aquatic.core.registry.UAItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SStatisticsPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="upgrade_aquatic")
public class EntityEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntitySpawned(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof DrownedEntity) {
            ((CreatureEntity)entity).field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)entity, TurtleEntity.class, 6.0f, 1.0, 1.2));
        }
        if (entity instanceof AbstractFishEntity) {
            ((AbstractFishEntity)entity).field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityPike.class, 8.0f, 1.6, 1.4, UAEntityPredicates.IS_HIDING_IN_PICKERELWEED::test));
            if (entity instanceof TropicalFishEntity) {
                ((AbstractFishEntity)entity).field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityLionfish.class, 8.0f, 1.6, 1.4, EntityPredicates.field_94557_a::test));
            }
        }
        if (entity instanceof WaterMobEntity && !(entity instanceof IMob)) {
            if (!(entity instanceof DolphinEntity)) {
                ((MobEntity)entity).field_70714_bg.func_75776_a(1, (Goal)new AvoidEntityGoal((CreatureEntity)entity, EntityThrasher.class, 20.0f, 1.4, 1.6, EntityPredicates.field_94557_a::test));
            }
            if (entity instanceof DolphinEntity) {
                ((MobEntity)entity).field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)((DolphinEntity)entity), new Class[]{EntityThrasher.class}).func_220794_a(new Class[0]));
                ((MobEntity)entity).field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)((DolphinEntity)entity), 1.2, true));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        ServerPlayerEntity playerMP;
        ServerStatisticsManager statisticsManager;
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PhantomEntity && ((PhantomEntity)entity).func_70638_az() instanceof ServerPlayerEntity && (statisticsManager = (playerMP = (ServerPlayerEntity)((PhantomEntity)entity).func_70638_az()).func_147099_x()).func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)) < 72000) {
            ((PhantomEntity)entity).func_70624_b(null);
        }
    }

    @SubscribeEvent
    public static void onPlayerSleep(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockState state = player.func_130014_f_().func_180495_p(event.getPos());
        if (event.getResultStatus() == null && state.func_204520_s().func_206882_g() == 8 && state.func_177230_c() instanceof BlockBedroll && player instanceof ServerPlayerEntity && player.func_70089_S()) {
            ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
            if (!player.field_70170_p.func_201670_d()) {
                UACriteriaTriggers.SLEEP_UNDERWATER.trigger(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onInteractEntity(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() == Items.field_151131_as && entity.func_70089_S() && entity instanceof SquidEntity) {
            entity.func_184185_a(SoundEvents.field_203814_aa, 1.0f, 1.0f);
            stack.func_190918_g(1);
            ItemStack bucket = new ItemStack((IItemProvider)UAItems.SQUID_BUCKET.get());
            if (entity.func_145818_k_()) {
                bucket.func_200302_a(entity.func_200201_e());
            }
            if (!event.getWorld().field_72995_K) {
                CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, bucket);
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(event.getHand(), bucket);
            } else if (!player.field_71071_by.func_70441_a(bucket)) {
                player.func_71019_a(bucket, false);
            }
            entity.func_70106_y();
        }
    }

    @SubscribeEvent
    public static void onPlayerSetSpawn(PlayerSetSpawnEvent event) {
        PlayerEntity player = event.getPlayer();
        BlockPos pos = event.getNewSpawn();
        if (player != null && pos != null && player.func_130014_f_().func_180495_p(pos).func_177230_c() instanceof BlockBedroll) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        ItemStack headSlotStack = player.func_184582_a(EquipmentSlotType.HEAD);
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70170_p.func_82737_E() % 5L == 0L && event.player instanceof ServerPlayerEntity) {
            ServerPlayerEntity sPlayer = (ServerPlayerEntity)event.player;
            ServerStatisticsManager statisticsManager = sPlayer.func_147099_x();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            object2intmap.put((Object)Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n), statisticsManager.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_203284_n)));
            sPlayer.field_71135_a.func_147359_a((IPacket)new SStatisticsPacket((Object2IntMap)object2intmap));
        }
        if (player.func_70613_aW() && !headSlotStack.func_190926_b() && headSlotStack.func_77973_b() == Items.field_203179_ao) {
            int timeTillDamage;
            int n = timeTillDamage = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)headSlotStack) > 0 ? 40 * (1 + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)headSlotStack) / 2) : 40;
            if (player.func_208600_a(FluidTags.field_206959_a)) {
                player.func_195064_c(new EffectInstance(Effects.field_76427_o, 210));
                if (player.field_70170_p.func_82737_E() % (long)timeTillDamage == 0L) {
                    headSlotStack.func_222118_a(1, (LivingEntity)player, p_213341_0_ -> p_213341_0_.func_213361_c(EquipmentSlotType.HEAD));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRiding(EntityMountEvent event) {
        Entity mountingEntity = event.getEntityMounting();
        Entity entityBeingMounted = event.getEntityBeingMounted();
        if (mountingEntity instanceof PlayerEntity && event.isDismounting() && entityBeingMounted instanceof EntityThrasher && ((EntityThrasher)entityBeingMounted).func_70089_S() && !((PlayerEntity)mountingEntity).func_184812_l_() && !((PlayerEntity)mountingEntity).func_175149_v() && ((PlayerEntity)mountingEntity).func_110143_aJ() > 0.0f && !((EntityThrasher)entityBeingMounted).isStunned()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onWandererTradesEvent(WandererTradesEvent event) {
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BEACHGRASS.get(), 1, 1, 12, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.WHITE_SEAROCKET.get(), 1, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PINK_SEAROCKET.get(), 1, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BLUE_PICKERELWEED.get(), 1, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PURPLE_PICKERELWEED.get(), 1, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.FLOWERING_RUSH.get(), 1, 1, 9, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.FINGER_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.ACAN_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BRANCH_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PILLOW_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.SILK_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PETAL_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.MOSS_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.ROCK_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.STAR_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.CHROME_CORAL_BLOCK.get(), 3, 1, 8, 1));
        event.getGenericTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.EMBEDDED_AMMONITE.get(), 5, 1, 6, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.DRIFTWOOD_LOG.get(), 2, 1, 16, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PRISMARINE_CORAL_BLOCK.get(), 6, 1, 4, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Item)UAItems.PIKE_BUCKET.get(), 5, 1, 4, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Item)UAItems.LIONFISH_BUCKET.get(), 5, 1, 4, 1));
        event.getRareTrades().add(new TradeUtils.ItemsForEmeraldsTrade((Item)UAItems.NAUTILUS_BUCKET.get(), 5, 1, 4, 1));
    }

    @SubscribeEvent
    public static void onVillagerTradesEvent(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221157_g) {
            ((List)event.getTrades().get(3)).add(new TradeUtils.ItemsForEmeraldsAndItemsTrade((Item)UAItems.PIKE.get(), 6, 1, (Item)UAItems.COOKED_PIKE.get(), 6, 16, 15));
            ((List)event.getTrades().get(4)).add(new TradeUtils.EmeraldsForItemsTrade((Item)UAItems.PIKE.get(), 5, 1, 12, 25));
            ((List)event.getTrades().get(4)).add(new TradeUtils.ItemsForEmeraldsAndItemsTrade((Item)UAItems.LIONFISH.get(), 6, 1, (Item)UAItems.COOKED_LIONFISH.get(), 6, 16, 30));
            ((List)event.getTrades().get(5)).add(new TradeUtils.EmeraldsForItemsTrade((Item)UAItems.LIONFISH.get(), 3, 1, 12, 30));
        }
        if (event.getType() == VillagerProfession.field_221161_k) {
            ((List)event.getTrades().get(5)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.TOOTH_TILES.get(), 5, 1, 12, 30));
            ((List)event.getTrades().get(5)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.TOOTH_BRICKS.get(), 5, 1, 12, 30));
        }
        if (event.getType() == VillagerProfession.field_221155_e) {
            ((List)event.getTrades().get(4)).add(new TradeUtils.EmeraldsForItemsTrade((Item)UAItems.THRASHER_TOOTH.get(), 1, 1, 12, 15));
        }
        if (event.getType() == VillagerProfession.field_221159_i) {
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.WHITE_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.ORANGE_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.MAGENTA_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.LIGHT_BLUE_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.YELLOW_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.LIME_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PINK_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.GRAY_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.LIGHT_GRAY_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.CYAN_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.PURPLE_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BLUE_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BROWN_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.GREEN_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.RED_BEDROLL.get(), 1, 1, 8, 10));
            ((List)event.getTrades().get(2)).add(new TradeUtils.ItemsForEmeraldsTrade((Block)UABlocks.BLACK_BEDROLL.get(), 1, 1, 8, 10));
        }
    }
}

