/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.NetherPortalBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import stepsword.mahoutsukai.block.BlockBase;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.util.Utils;

public class BlackFireBlock
extends BlockBase {
    public static final IntegerProperty AGE = IntegerProperty.func_177719_a((String)"age", (int)0, (int)15);
    public static final BooleanProperty NORTH = BooleanProperty.func_177716_a((String)"north");
    public static final BooleanProperty EAST = BooleanProperty.func_177716_a((String)"east");
    public static final BooleanProperty SOUTH = BooleanProperty.func_177716_a((String)"south");
    public static final BooleanProperty WEST = BooleanProperty.func_177716_a((String)"west");
    public static final BooleanProperty UPPER = BooleanProperty.func_177716_a((String)"up");
    public static final Random RNG = new Random();
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199776_0_ -> p_199776_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());

    protected BlackFireBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151581_o).func_200942_a().func_200944_c().func_200943_b(0.0f).func_200951_a(15).func_200947_a(SoundType.field_185854_g).func_222380_e(), "black_fire");
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UPPER, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197880_a();
    }

    public int tickRate(World worldIn) {
        return 30;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? (BlockState)this.getStateForPlacement((IBlockReader)worldIn, currentPos).func_206870_a((IProperty)AGE, stateIn.func_177229_b((IProperty)AGE)) : Blocks.field_150350_a.func_176223_P();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getStateForPlacement(IBlockReader p_196448_1_, BlockPos p_196448_2_) {
        BlockPos blockpos = p_196448_2_.func_177977_b();
        BlockState blockstate = p_196448_1_.func_180495_p(blockpos);
        if (!this.canCatchFire(p_196448_1_, p_196448_2_, Direction.UP) && !Block.func_220056_d((BlockState)blockstate, (IBlockReader)p_196448_1_, (BlockPos)blockpos, (Direction)Direction.UP)) {
            BlockState blockstate1 = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                blockstate1 = (BlockState)blockstate1.func_206870_a((IProperty)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(p_196448_1_, p_196448_2_.func_177972_a(direction), direction.func_176734_d())));
            }
            return blockstate1;
        }
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)worldIn, pos);
    }

    public int func_149738_a(IWorldReader worldIn) {
        return 5;
    }

    private boolean areNeighborsFlammable(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(IWorldReader worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
            i = Math.max(blockstate.getFlammability((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && (worldIn.field_73011_w.func_186058_p() != DimensionType.field_223227_a_ && worldIn.field_73011_w.func_186058_p() != DimensionType.field_223228_b_ || !((NetherPortalBlock)Blocks.field_150427_aO).func_176548_d((IWorld)worldIn, pos))) {
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            } else {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate(worldIn) + worldIn.field_73012_v.nextInt(10));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE, NORTH, EAST, SOUTH, WEST, UPPER});
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        if (worldIn != null && worldIn.func_72896_J()) {
            worldIn.func_217377_a(pos, false);
        }
        if (worldIn.func_72820_D() % (long)MTConfig.BLACK_FLAME_UPDATE_TICKS != 0L) {
            return;
        }
        if (worldIn.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (!worldIn.isAreaLoaded(pos, 2)) {
                return;
            }
            if (!this.canPlaceBlockAt((World)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            }
            Block block = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c();
            if (Utils.isBlockAir((World)worldIn, pos.func_177977_b()) || block == ModBlocks.blackFireBlock) {
                worldIn.func_217377_a(pos, false);
                return;
            }
            int i = (Integer)state.func_177229_b((IProperty)AGE);
            if (i >= MTConfig.BLACK_FLAME_DEATH_AGE && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150424_aL) {
                worldIn.func_217377_a(pos, false);
                return;
            }
            if ((double)worldIn.func_72867_j(0.0f) > 0.2 && this.canDie((World)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            } else {
                if (i < 15) {
                    state = (BlockState)state.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(i + 1));
                    worldIn.func_180501_a(pos, state, 4);
                }
                if (!this.canNeighborCatchFire((World)worldIn, pos)) {
                    if (!worldIn.func_180495_p(pos.func_177977_b()).func_224755_d((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP) || i > 3) {
                        worldIn.func_217377_a(pos, false);
                    }
                    return;
                }
                if (!this.canCatchFire((IBlockReader)worldIn, pos.func_177977_b(), Direction.UP) && i == 15 && rand.nextInt(4) == 0) {
                    worldIn.func_217377_a(pos, false);
                    return;
                }
                int j = 0;
                this.tryCatchFire((World)worldIn, pos.func_177974_f(), 300 + j, rand, i, Direction.WEST);
                this.tryCatchFire((World)worldIn, pos.func_177976_e(), 300 + j, rand, i, Direction.EAST);
                this.tryCatchFire((World)worldIn, pos.func_177984_a(), 250 + j, rand, i, Direction.DOWN);
                this.tryCatchFire((World)worldIn, pos.func_177978_c(), 300 + j, rand, i, Direction.SOUTH);
                this.tryCatchFire((World)worldIn, pos.func_177968_d(), 300 + j, rand, i, Direction.NORTH);
            }
        }
    }

    protected boolean canDie(World worldIn, BlockPos pos) {
        return worldIn.func_72896_J();
    }

    public boolean requiresUpdates() {
        return false;
    }

    @Deprecated
    public int getFlammability(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    @Deprecated
    public int getEncouragement(Block blockIn) {
        return 50 + RNG.nextInt(20);
    }

    @Deprecated
    private void catchOnFire(World worldIn, BlockPos pos, int chance, Random random, int age) {
        this.tryCatchFire(worldIn, pos, chance, random, age, Direction.UP);
    }

    private void tryCatchFire(World worldIn, BlockPos pos, int chance, Random random, int age, Direction face) {
    }

    private boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (Direction enumfacing : Direction.values()) {
            if (!this.canCatchFire((IBlockReader)worldIn, pos.func_177972_a(enumfacing), enumfacing.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction enumfacing : Direction.values()) {
            i = Math.max(this.getEncouragement(worldIn.func_180495_p(pos.func_177972_a(enumfacing)).func_177230_c()), i);
        }
        return i;
    }

    @Deprecated
    public boolean canCatchFire(IBlockReader worldIn, BlockPos pos) {
        return this.canCatchFire(worldIn, pos, Direction.UP);
    }

    public boolean canPlaceBlockAt(World worldIn, BlockPos pos) {
        return this.canNeighborCatchFire(worldIn, pos);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        Block b = world.func_180495_p(pos).func_177230_c();
        TileEntity te = world.func_175625_s(pos);
        return te == null && b != ModBlocks.invisibleBarrierBlock && b != Blocks.field_150357_h && b != Blocks.field_150350_a && b != Blocks.field_150432_aD && b != Blocks.field_150433_aE && b != Blocks.field_150355_j && b != Blocks.field_150353_l && b != Blocks.field_201941_jj && b != Blocks.field_201940_ji;
    }
}

