/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.enchant.MahoujinProjectorEnchant;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.render.enchant.ProjectorValues;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class MahoujinProjector
extends BlockTileEntity<MahoujinProjectorTileEntity> {
    public static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB boundingBoxE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public MahoujinProjector() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_(), "mahoujin_projector");
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult result) {
        if (world.func_175625_s(pos) instanceof MahoujinProjectorTileEntity) {
            MahoujinProjectorTileEntity te = (MahoujinProjectorTileEntity)world.func_175625_s(pos);
            if (player.func_184614_ca().func_77973_b() instanceof ArmorItem) {
                if (!world.field_72995_K) {
                    EffectUtil.addEnchantment(player.func_184614_ca(), ModEnchantments.PROJECTOR, 1);
                    MahoujinProjectorEnchant.setProjectorNBT(player.func_184614_ca(), te);
                }
            } else if (player.func_184614_ca().func_77973_b() != Items.field_151055_y && world.field_72995_K) {
                MahouTsukaiMod.proxy.openProjectorGUI(world, pos);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public static void projectorRightClick(PlayerInteractEvent.RightClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        PlayerEntity player = event.getPlayer();
        if (world.func_175625_s(pos) instanceof MahoujinProjectorTileEntity) {
            MahoujinProjectorTileEntity te = (MahoujinProjectorTileEntity)world.func_175625_s(pos);
            if (!world.field_72995_K && player.func_184614_ca().func_77973_b() == Items.field_151055_y) {
                if (player.func_226273_bm_()) {
                    CompoundNBT nbt = MahoujinProjectorEnchant.getProjectorNBT(player.func_184614_ca());
                    if (nbt != null && te != null) {
                        ProjectorValues pv = new ProjectorValues();
                        pv.read(nbt);
                        te.setCr(pv.getCr());
                        te.setCg(pv.getCg());
                        te.setCb(pv.getCb());
                        te.setCa(pv.getCa());
                        te.setCx(pv.getCx());
                        te.setCy(pv.getCy());
                        te.setCz(pv.getCz());
                        te.setCsize(pv.getCsize());
                        te.setCspeed(pv.getCspeed());
                        te.setCyspeed(pv.getCyspeed());
                        te.setCpspeed(pv.getCpspeed());
                        te.setCyaw(pv.getCyaw());
                        te.setCpitch(pv.getCpitch());
                        te.setCringangle(pv.getCringangle());
                        te.setShowRing(pv.getShowRing());
                        te.setShowCircle(pv.getShowCircle());
                        te.setImage(pv.getImage());
                        te.setRunes(pv.getRunes());
                        te.setHeight(pv.getHeight());
                        te.setRotationOffset(pv.getRotationOffset());
                        te.sendUpdates();
                    }
                } else {
                    MahoujinProjectorEnchant.setProjectorNBT(player.func_184614_ca(), te);
                }
            }
        }
    }

    @Override
    public Class<MahoujinProjectorTileEntity> getTileEntityClass() {
        return MahoujinProjectorTileEntity.class;
    }

    @Override
    @Nullable
    public MahoujinProjectorTileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new MahoujinProjectorTileEntity();
    }
}

