/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.block.circuits;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import stepsword.mahoutsukai.block.BlockTileEntity;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.item.FaeEssence;
import stepsword.mahoutsukai.item.attunedgems.AttunedGem;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ManaCircuitBlock
extends BlockTileEntity<ManaCircuitTileEntity> {
    public static final AxisAlignedBB boundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    public static final AxisAlignedBB boundingBoxE = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);

    public ManaCircuitBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_(), "mana_circuit");
    }

    @Override
    public Class<ManaCircuitTileEntity> getTileEntityClass() {
        return ManaCircuitTileEntity.class;
    }

    @Override
    @Nullable
    public ManaCircuitTileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ManaCircuitTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity playerIn, Hand hand, BlockRayTraceResult res) {
        return ManaCircuitBlock.chargeCircuitBlock(worldIn, pos, playerIn) ? ActionResultType.SUCCESS : ActionResultType.FAIL;
    }

    public static boolean chargeGemFromCircuit(PlayerEntity playerIn, World worldIn, BlockPos pos) {
        TileEntity tte;
        if (!worldIn.field_72995_K && (tte = worldIn.func_175625_s(pos)) instanceof ManaCircuitTileEntity) {
            ManaCircuitTileEntity te = (ManaCircuitTileEntity)tte;
            if (te.getOwnerUUID() == null) {
                te.setOwnerUUID(playerIn.func_110124_au());
            }
            if (playerIn.func_184614_ca().func_77973_b() instanceof AttunedGem) {
                int gemMax;
                int gemMana;
                int increment = 1000;
                int manaStored = te.getMana();
                IGemMahou gemMahou = Utils.getGemMahou(playerIn.func_184614_ca());
                if (gemMahou != null && (gemMana = gemMahou.getStoredMana()) < (gemMax = ((AttunedGem)playerIn.func_184614_ca().func_77973_b()).getMaxMana())) {
                    int diff = gemMax - gemMana;
                    if (diff <= manaStored) {
                        te.setMana(te.getMana() - diff);
                        gemMahou.setStoredMana(gemMana + diff);
                        playerIn.func_184614_ca().func_77982_d((CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)gemMahou, null));
                        te.sendUpdates();
                    } else {
                        if (manaStored <= increment) {
                            te.setMana(0);
                            gemMahou.setStoredMana(gemMana + manaStored);
                        } else {
                            te.setMana(manaStored - increment);
                            gemMahou.setStoredMana(gemMana + increment);
                        }
                        te.sendUpdates();
                        playerIn.func_184614_ca().func_77982_d((CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)gemMahou, null));
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static boolean chargeCircuitBlock(World worldIn, BlockPos pos, PlayerEntity playerIn) {
        TileEntity tte;
        if (!worldIn.field_72995_K && (tte = worldIn.func_175625_s(pos)) instanceof ManaCircuitTileEntity) {
            ManaCircuitTileEntity te = (ManaCircuitTileEntity)tte;
            if (te.getOwnerUUID() == null) {
                te.setOwnerUUID(playerIn.func_110124_au());
            }
            if (playerIn.func_226273_bm_()) {
                te.setOn(!te.isOn());
                te.sendUpdates();
            } else if (playerIn != null) {
                if (playerIn.func_184614_ca().func_77973_b() instanceof FaeEssence) {
                    if (playerIn.func_110124_au().equals(te.getOwnerUUID())) {
                        te.setFae(!te.getFae());
                        te.sendUpdates();
                    }
                } else {
                    IMahou mahou = Utils.getPlayerMahou((LivingEntity)playerIn);
                    if (mahou != null) {
                        int MAX_MANA;
                        double chargeRate = mahou.getChargeRate();
                        int playerMaxMana = mahou.getMaxMana();
                        int manaDifference = (int)Math.ceil((double)playerMaxMana * chargeRate);
                        int storedMana = te.getMana();
                        if (storedMana < (MAX_MANA = te.getMaxMana())) {
                            manaDifference = Math.min(manaDifference, MAX_MANA - storedMana);
                            manaDifference = PlayerManaManager.chargeCircuit(playerIn, manaDifference);
                            te.setMana(storedMana + manaDifference);
                        }
                        if ((storedMana = te.getMana()) >= MAX_MANA) {
                            te.setMana(MAX_MANA);
                        }
                        te.sendUpdates();
                    }
                }
            }
            return true;
        }
        return true;
    }
}

