/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.mahou;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouProvider;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.Leylines;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.item.attunedgems.AttunedGem;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.PlayerMahouPacket;
import stepsword.mahoutsukai.tile.circuits.ManaCircuitTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class PlayerManaManager {
    public static void damagePlayer(PlayerEntity player, int mana) {
        boolean z;
        if (player != null && !player.field_70170_p.field_72995_K && ((z = MahouTsukaiMod.gamestages.reachedStageDefaultFalse((ServerPlayerEntity)player, "mahoutsukai_magic_damage")) || MTConfig.MAGIC_DAMAGES_PLAYER)) {
            double v = 0.0;
            v = MTConfig.MAGIC_DAMAGE_FLAT ? MTConfig.MAGIC_DAMAGE_VALUE : MTConfig.MAGIC_DAMAGE_VALUE * (double)mana;
            player.func_70097_a(MTConfig.MAGIC_DAMAGE_GENERIC ? DamageSource.field_76377_j : DamageSource.field_76376_m, (float)v);
            player.field_70718_bc = 100;
        }
    }

    public static int drainMana(PlayerEntity player, int drain, boolean nogems, boolean nocircuits) {
        return PlayerManaManager.drainMana(player, drain, nogems, nocircuits, true, false);
    }

    public static int drainMana(PlayerEntity player, int drain, boolean nogems, boolean nocircuits, boolean maxincr, boolean noupdate) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        if (player.func_184812_l_() && MTConfig.CREATIVE_IGNORES_MANA_COSTS && !player.field_70170_p.field_72995_K) {
            return drain;
        }
        int playerUsedMana = 0;
        int returnManaUsed = 0;
        if (mahou != null) {
            int playerMana = mahou.getStoredMana();
            int remaining = drain;
            Set<TileEntity> circuits = null;
            ArrayList<ItemStack> playerGems = null;
            if (!nogems) {
                playerGems = PlayerManaManager.gemsInInventory(player);
            }
            if (!nocircuits) {
                circuits = PlayerManaManager.nearbyBatteries(player.func_180425_c(), player.field_70170_p);
            }
            if (playerMana >= drain) {
                playerUsedMana = drain;
                returnManaUsed = drain;
            } else {
                int totalMana = playerMana;
                if (playerGems != null) {
                    totalMana += PlayerManaManager.countManaInGems(playerGems);
                }
                if (circuits != null) {
                    totalMana += PlayerManaManager.countManaInNearbyBatteries(player.func_180425_c(), player.field_70170_p, circuits, player.func_110124_au());
                }
                if (totalMana < drain) {
                    if (!nogems) {
                        playerUsedMana = 0;
                        returnManaUsed = 0;
                    } else {
                        playerUsedMana = playerMana;
                        returnManaUsed = playerMana;
                        int tmp = remaining;
                        if (circuits != null) {
                            remaining = PlayerManaManager.drainManaFromNearbyBatteries(player.func_180425_c(), player.field_70170_p, circuits, remaining, player.func_110124_au());
                        }
                        returnManaUsed += tmp - remaining;
                    }
                } else {
                    remaining = drain - playerMana;
                    playerUsedMana = playerMana;
                    returnManaUsed = drain;
                    if (playerGems != null) {
                        remaining = PlayerManaManager.drainManaFromGems(playerGems, remaining);
                    }
                    if (circuits != null) {
                        remaining = PlayerManaManager.drainManaFromNearbyBatteries(player.func_180425_c(), player.field_70170_p, circuits, remaining, player.func_110124_au());
                    }
                }
            }
            mahou.setManaFull(false);
            mahou.setStoredMana(Math.max(0, playerMana - playerUsedMana));
            if (maxincr) {
                PlayerManaManager.updateManaCounter((ServerPlayerEntity)player, playerUsedMana);
            }
            if (!noupdate) {
                PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, mahou);
            }
            if (playerUsedMana > 0) {
                PlayerManaManager.damagePlayer(player, playerUsedMana);
            }
        }
        return returnManaUsed;
    }

    public static int chargeCircuit(PlayerEntity player, int drain) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        int playerUsedMana = 0;
        int remaining = drain;
        int ret = 0;
        if (mahou != null) {
            int playerMana = mahou.getStoredMana();
            ArrayList<ItemStack> playerGems = null;
            playerGems = PlayerManaManager.gemsInInventory(player);
            if (playerMana >= drain) {
                playerUsedMana = drain;
                ret = drain;
            } else {
                int totalMana = playerMana;
                if (playerGems != null) {
                    totalMana += PlayerManaManager.countManaInGems(playerGems);
                }
                if (totalMana < drain) {
                    playerUsedMana = playerMana;
                    ret = playerMana;
                    if (playerGems != null) {
                        remaining = PlayerManaManager.drainManaFromGems(playerGems, drain - playerUsedMana);
                    }
                    ret += drain - playerUsedMana - remaining;
                } else {
                    remaining = drain - playerMana;
                    playerUsedMana = playerMana;
                    ret = playerMana;
                    if (playerGems != null) {
                        ret += remaining - PlayerManaManager.drainManaFromGems(playerGems, remaining);
                    }
                }
            }
            mahou.setManaFull(false);
            mahou.setStoredMana(Math.max(0, playerMana - playerUsedMana));
            PlayerManaManager.updateManaCounter((ServerPlayerEntity)player, playerUsedMana);
            PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, mahou);
            if (playerUsedMana > 0) {
                PlayerManaManager.damagePlayer(player, playerUsedMana);
            }
        }
        return ret;
    }

    public static int chargeAnyNearbyBatteries(BlockPos p, World world, Set<TileEntity> tes, int charge) {
        Set<TileEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int remaining = charge;
        for (TileEntity te : tes2) {
            ManaCircuitTileEntity mte;
            int tmp;
            if (!(te instanceof ManaCircuitTileEntity) || (tmp = (mte = (ManaCircuitTileEntity)te).getMaxMana() - mte.getMana()) <= 0) continue;
            if (tmp > remaining) {
                mte.setMana(mte.getMana() + remaining);
                remaining = 0;
            } else {
                mte.setMana(mte.getMaxMana());
                remaining -= tmp;
            }
            mte.sendUpdates();
            if (remaining > 0) continue;
            break;
        }
        return remaining;
    }

    public static ArrayList<ItemStack> gemsInInventory(PlayerEntity player) {
        ArrayList<ItemStack> playerGems = new ArrayList<ItemStack>();
        for (List list : Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c)) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof AttunedGem)) continue;
                playerGems.add(itemstack);
            }
        }
        return playerGems;
    }

    public static int countManaInGems(ArrayList<ItemStack> playerGems) {
        int ret = 0;
        for (ItemStack itemstack : playerGems) {
            IGemMahou gemMahou;
            if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof AttunedGem) || (gemMahou = Utils.getGemMahou(itemstack)) == null) continue;
            ret += gemMahou.getStoredMana();
        }
        return ret;
    }

    public static int drainManaFromGems(ArrayList<ItemStack> playerGems, int drain) {
        int remaining = drain;
        for (ItemStack stack : playerGems) {
            IGemMahou gemMahou;
            if (remaining <= 0) break;
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof AttunedGem) || (gemMahou = Utils.getGemMahou(stack)) == null) continue;
            int tmp = gemMahou.getStoredMana();
            if (remaining >= tmp) {
                remaining -= tmp;
                gemMahou.setStoredMana(0);
                stack.func_77982_d((CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)gemMahou, null));
                continue;
            }
            gemMahou.setStoredMana(gemMahou.getStoredMana() - remaining);
            stack.func_77982_d((CompoundNBT)GemMahouProvider.MAHOU.getStorage().writeNBT(GemMahouProvider.MAHOU, (Object)gemMahou, null));
            remaining = 0;
        }
        return remaining;
    }

    public static int countManaInNearbyBatteries(BlockPos p, World world, Set<TileEntity> tes, UUID uuid) {
        Set<TileEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int ret = 0;
        for (TileEntity te : tes2) {
            if (!(te instanceof ManaCircuitTileEntity)) continue;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            if (uuid == null || !uuid.equals(mte.getOwnerUUID()) && !mte.getFae()) continue;
            ret += mte.getMana();
        }
        return ret;
    }

    public static int drainManaFromNearbyBatteries(BlockPos p, World world, Set<TileEntity> tes, int drain, UUID uuid) {
        Set<TileEntity> tes2 = tes;
        if (tes2 == null) {
            tes2 = PlayerManaManager.nearbyBatteries(p, world);
        }
        int remaining = drain;
        for (TileEntity te : tes2) {
            if (!(te instanceof ManaCircuitTileEntity)) continue;
            ManaCircuitTileEntity mte = (ManaCircuitTileEntity)te;
            if (uuid == null || !uuid.equals(mte.getOwnerUUID()) && !mte.getFae()) continue;
            if (remaining <= 0) break;
            int tmp = mte.getMana();
            if (remaining >= tmp) {
                remaining -= tmp;
                mte.setMana(0);
            } else {
                mte.setMana(mte.getMana() - remaining);
                remaining = 0;
            }
            mte.sendUpdates();
        }
        return remaining;
    }

    public static Set<TileEntity> nearbyBatteries(final BlockPos p, World world) {
        final int range = MTConfig.MANA_CIRCUIT_RANGE;
        BlockPos min = p.func_177982_a(-range, -range, -range);
        BlockPos max = p.func_177982_a(range, range, range);
        ChunkPos cmin = new ChunkPos(min);
        ChunkPos cmax = new ChunkPos(max);
        HashSet<TileEntity> tes = new HashSet<TileEntity>();
        List<Object> tmp = new ArrayList();
        for (int i = Math.min(cmin.field_77276_a, cmax.field_77276_a); i <= Math.max(cmin.field_77276_a, cmax.field_77276_a); ++i) {
            for (int j = Math.min(cmin.field_77275_b, cmax.field_77275_b); j <= Math.max(cmin.field_77275_b, cmax.field_77275_b); ++j) {
                Chunk c = world.func_212866_a_(i, j);
                tmp = c.func_177434_r().values().stream().filter(new Predicate<TileEntity>(){

                    @Override
                    public boolean test(TileEntity tileEntity) {
                        return tileEntity instanceof ManaCircuitTileEntity && ((ManaCircuitTileEntity)tileEntity).isRedstoneOn() && Math.abs(tileEntity.func_174877_v().func_177958_n() - p.func_177958_n()) < range && Math.abs(tileEntity.func_174877_v().func_177952_p() - p.func_177952_p()) < range;
                    }
                }).collect(Collectors.toList());
                tes.addAll(tmp);
            }
        }
        return tes;
    }

    public static boolean getManaFromBatteriesFirst(BlockPos p, World world, UUID uuid, int drain) {
        Set<TileEntity> tes = PlayerManaManager.nearbyBatteries(p, world);
        if (PlayerManaManager.countManaInNearbyBatteries(p, world, tes, uuid) >= drain) {
            PlayerManaManager.drainManaFromNearbyBatteries(p, world, tes, drain, uuid);
            return true;
        }
        return false;
    }

    public static void regenMana(PlayerEntity player, boolean sleep) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        if (mahou != null) {
            double sleepregen = MTConfig.MANA_RECOVERY_SLEEP;
            int playerMaxMana = mahou.getMaxMana();
            int playerStoredMana = mahou.getStoredMana();
            int punishment = (int)(MTConfig.DEATH_COLLECTION_DRAIN_PER_SOUL * (double)mahou.getDeathCollectionUsesLeft());
            if (playerMaxMana <= playerStoredMana) {
                mahou.setStoredMana(Math.max(0, playerMaxMana - punishment));
            } else {
                int regen = !sleep ? PlayerManaManager.getManaRegen(player) : (int)(sleepregen * (double)playerMaxMana);
                mahou.setStoredMana(Math.min(Math.max(mahou.getStoredMana() + regen - punishment, 0), mahou.getMaxMana()));
            }
            PlayerManaManager.updateClientMahou((ServerPlayerEntity)player, mahou);
        }
    }

    public static void updateManaCounter(ServerPlayerEntity player, int mana) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        int default_MANA_UP_COUNTER = MTConfig.MANA_UP_COUNTER;
        int default_MANA_INCREASE = MTConfig.MANA_INCREASE;
        if (mahou != null) {
            int counter = mahou.getManaToUseCounter();
            int leftover = 0;
            if ((counter -= mana) <= 0) {
                int increase = default_MANA_INCREASE;
                if (counter < 0) {
                    increase += Math.abs(counter * default_MANA_INCREASE / default_MANA_UP_COUNTER);
                    leftover = Math.abs(counter) % default_MANA_UP_COUNTER;
                }
                counter = default_MANA_UP_COUNTER - leftover;
                PlayerManaManager.increaseMaxMana((PlayerEntity)player, increase);
            }
            mahou.setManaToUseCounter(counter);
            PlayerManaManager.updateClientMahou(player, mahou);
        }
    }

    public static void increaseMaxMana(PlayerEntity player, int increase) {
        int true_MAX_MANA = MTConfig.MAX_MANA_CAP;
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        mahou.setMaxMana(Math.min(true_MAX_MANA, mahou.getMaxMana() + increase));
    }

    public static int getManaRegen(PlayerEntity player) {
        int true_MAX_MANA = MTConfig.MAX_MANA_CAP;
        int default_MANA_REGEN_RATE_PER_TICK = MTConfig.MANA_REGEN_PER_TICK;
        double scaling_regen_factor = MTConfig.MANA_ADDED_SCALING_REGEN_PER_TICK;
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        FoodStats fs = player.func_71024_bL();
        int hunger = fs.func_75116_a();
        double saturation = fs.func_75115_e();
        if (mahou != null) {
            double regenRatio = (float)mahou.getMaxMana() / (float)true_MAX_MANA;
            boolean flat = MTConfig.LEY_FLAT;
            float punishment = MTConfig.LEY_PUNISHMENT;
            float leyfactor = (float)MTConfig.LEY_FACTOR;
            int ley = Leylines.nearbyLeyValue(player.func_180425_c());
            float ley2 = (float)ley / 19.0f;
            float addonleymana = 0.0f;
            if (MTConfig.LEY_AFFECTS_MANA) {
                addonleymana = !flat ? punishment + ley2 * (float)mahou.getMaxMana() * leyfactor : punishment + leyfactor * ley2;
            }
            if (!Leylines.leyDimensionValid(player.field_71093_bK.getRegistryName().toString())) {
                addonleymana = 0.0f;
            } else if (ley >= 13 && mahou.getFaeSpawn() && Math.random() < 0.1 * MTConfig.FAE_SPAWN_RATE && mahou.hasMagic() && !player.field_70170_p.field_72995_K) {
                FaeEntity fae = new FaeEntity(player.field_70170_p);
                fae.func_70107_b(player.func_226277_ct_() + (double)player.func_70681_au().nextInt(10), player.func_226278_cu_(), player.func_226281_cx_() + (double)player.func_70681_au().nextInt(10));
                if (Utils.isBlockAir(player.field_70170_p, fae.func_180425_c())) {
                    try {
                        player.field_70170_p.func_217376_c((Entity)fae);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return default_MANA_REGEN_RATE_PER_TICK + (int)(scaling_regen_factor * (double)mahou.getMaxMana()) + (int)Math.ceil(((double)hunger + saturation) * regenRatio * MTConfig.MANA_REGEN_HUNGER_FACTOR) + (int)addonleymana + (int)((double)GeasEffect.getUniqueGeasCount((LivingEntity)player) * MTConfig.MANA_REGEN_PER_GEAS);
        }
        return 0;
    }

    public static void updateClientMahou(ServerPlayerEntity player, IMahou mahou) {
        if (player != null && mahou != null) {
            PacketHandler.sendTo(player, new PlayerMahouPacket(mahou));
        }
    }

    public static boolean hasMana(PlayerEntity player, int drain) {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)player);
        int playerMana = mahou.getStoredMana();
        ArrayList<ItemStack> playerGems = new ArrayList<ItemStack>();
        if (playerMana >= drain) {
            return true;
        }
        int totalMana = playerMana;
        for (List list : Arrays.asList(player.field_71071_by.field_70462_a, player.field_71071_by.field_70460_b, player.field_71071_by.field_184439_c)) {
            for (ItemStack itemstack : list) {
                if (itemstack.func_190926_b() || !(itemstack.func_77973_b() instanceof AttunedGem)) continue;
                playerGems.add(itemstack);
                IGemMahou gemMahou = Utils.getGemMahou(itemstack);
                if (gemMahou == null) continue;
                totalMana += gemMahou.getStoredMana();
            }
        }
        return totalMana > drain;
    }
}

