/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.worldsave;

import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;
import stepsword.mahoutsukai.util.Utils;

public class MahouSavedData {
    World world;
    IWorldMahou mahou = null;
    public HashMap<UUID, BlockPos> realityMarbleSpawns;
    public Multimap<UUID, UUID> playerContracts;

    public MahouSavedData(World world) {
        this.world = world instanceof ServerWorld ? Utils.getWorldFromDimension(DimensionType.field_223227_a_, (ServerWorld)world) : world;
        if (world != null) {
            this.mahou = Utils.getWorldMahou(this.world);
            if (this.mahou != null) {
                this.playerContracts = this.mahou.getContracts();
                this.realityMarbleSpawns = this.mahou.getRealityMarbleSpawns();
            }
        }
    }

    public void changePlayerSpawn(UUID uuid, BlockPos pos) {
        if (uuid != null && pos != null) {
            this.realityMarbleSpawns.put(uuid, pos);
        }
    }

    public boolean addContractIfNotExists(UUID uuid, UUID uuid2) {
        if (uuid != null && uuid2 != null) {
            if (!this.playerContracts.containsEntry((Object)uuid, (Object)uuid2) && !this.playerContracts.containsEntry((Object)uuid2, (Object)uuid)) {
                this.playerContracts.put((Object)uuid, (Object)uuid2);
                this.playerContracts.put((Object)uuid2, (Object)uuid);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean doesContractExist(UUID uuid, UUID uuid2) {
        return uuid != null && uuid2 != null && this.playerContracts != null && (this.playerContracts.containsEntry((Object)uuid, (Object)uuid2) || this.playerContracts.containsEntry((Object)uuid2, (Object)uuid));
    }

    public void removeContract(UUID uuid, UUID uuid2) {
        if (this.playerContracts.containsEntry((Object)uuid, (Object)uuid2)) {
            this.playerContracts.remove((Object)uuid, (Object)uuid2);
        }
        if (this.playerContracts.containsEntry((Object)uuid2, (Object)uuid)) {
            this.playerContracts.remove((Object)uuid2, (Object)uuid);
        }
    }

    public BlockPos getPlayerSpawn(UUID uuid) {
        return this.realityMarbleSpawns.getOrDefault(uuid, null);
    }

    public HashMap<UUID, BlockPos> getAllSpawns() {
        return this.realityMarbleSpawns;
    }
}

