/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.worldsave;

import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;

public class WorldMahouStorage
implements Capability.IStorage<IWorldMahou> {
    public static final String realityMarblePlayers = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_LIST";
    public static final String marblePlayerID = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_ID";
    public static final String marblePlayerSpawnX = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_X";
    public static final String marblePlayerSpawnY = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Y";
    public static final String marblePlayerSpawnZ = "MAHOUTSUKAI_REALITY_MARBLE_PLAYER_SPAWN_Z";
    public static final String contractPlayers = "MAHOUTSUKAI_CONTRACT_PLAYER_LIST";
    public static final String contractPlayerIDA = "MAHOUTSUKAI_CONTRACT_PLAYER_A";
    public static final String contractPlayerIDB = "MAHOUTSUKAI_CONTRACT_PLAYER_B";

    @Nullable
    public INBT writeNBT(Capability<IWorldMahou> capability, IWorldMahou instance, Direction side) {
        CompoundNBT compound = new CompoundNBT();
        CompoundNBT reality = new CompoundNBT();
        int z = 0;
        for (UUID tmp : instance.getRealityMarbleSpawns().keySet()) {
            BlockPos pos = instance.getRealityMarbleSpawns().get(tmp);
            if (pos == null) continue;
            CompoundNBT nbttmp = new CompoundNBT();
            nbttmp.func_186854_a(marblePlayerID, tmp);
            nbttmp.func_74768_a(marblePlayerSpawnX, pos.func_177958_n());
            nbttmp.func_74768_a(marblePlayerSpawnY, pos.func_177956_o());
            nbttmp.func_74768_a(marblePlayerSpawnZ, pos.func_177952_p());
            reality.func_218657_a("MAHOUTSUKAI_PLAYER_ID_" + z, (INBT)nbttmp);
            ++z;
        }
        compound.func_218657_a(realityMarblePlayers, (INBT)reality);
        CompoundNBT contracts = new CompoundNBT();
        CompoundNBT nbtcctmp = null;
        int c = 0;
        for (UUID tmp : instance.getContracts().keySet()) {
            Collection coll = instance.getContracts().get((Object)tmp);
            for (UUID tmp2 : coll) {
                nbtcctmp = new CompoundNBT();
                nbtcctmp.func_186854_a(contractPlayerIDA, tmp);
                nbtcctmp.func_186854_a(contractPlayerIDB, tmp2);
                contracts.func_218657_a("MAHOUTSUKAI_CONTRACT_ID_" + c, (INBT)nbtcctmp);
                ++c;
            }
        }
        compound.func_218657_a(contractPlayers, (INBT)contracts);
        return compound;
    }

    public void readNBT(Capability<IWorldMahou> capability, IWorldMahou instance, Direction side, INBT nbtb) {
        CompoundNBT nbt = (CompoundNBT)nbtb;
        if (nbt.func_74764_b(realityMarblePlayers)) {
            for (String tmp : ((CompoundNBT)nbt.func_74781_a(realityMarblePlayers)).func_150296_c()) {
                CompoundNBT nbttmp = (CompoundNBT)((CompoundNBT)nbt.func_74781_a(realityMarblePlayers)).func_74781_a(tmp);
                if (nbttmp == null || !nbttmp.func_186855_b(marblePlayerID)) continue;
                UUID uuid = nbttmp.func_186857_a(marblePlayerID);
                BlockPos pos = new BlockPos(nbttmp.func_74762_e(marblePlayerSpawnX), nbttmp.func_74762_e(marblePlayerSpawnY), nbttmp.func_74762_e(marblePlayerSpawnZ));
                instance.getRealityMarbleSpawns().put(uuid, pos);
            }
        }
        if (nbt.func_74764_b(contractPlayers)) {
            for (String tmp : ((CompoundNBT)nbt.func_74781_a(contractPlayers)).func_150296_c()) {
                CompoundNBT nbtc = (CompoundNBT)((CompoundNBT)nbt.func_74781_a(contractPlayers)).func_74781_a(tmp);
                if (nbtc == null || !nbtc.func_186855_b(contractPlayerIDA) || !nbtc.func_186855_b(contractPlayerIDB)) continue;
                instance.getContracts().put((Object)nbtc.func_186857_a(contractPlayerIDA), (Object)nbtc.func_186857_a(contractPlayerIDB));
                instance.getContracts().put((Object)nbtc.func_186857_a(contractPlayerIDB), (Object)nbtc.func_186857_a(contractPlayerIDA));
            }
        }
    }
}

