/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class GateChainEntity
extends Entity {
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_LENGTH = "MAHOUTSUKAI_LENGTH";
    private static final String TAG_COLOR_R = "MAHOUTSUKAI_COLOR_R";
    private static final String TAG_COLOR_G = "MAHOUTSUKAI_COLOR_G";
    private static final String TAG_COLOR_B = "MAHOUTSUKAI_COLOR_B";
    private static final String TAG_COLOR_A = "MAHOUTSUKAI_COLOR_A";
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static float speed = 4.2f;
    public boolean dying = false;
    public int dyingticks = 0;
    public float lastlen = 0.0f;
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> LENGTH = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_R = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_G = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_B = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> COLOR_A = EntityDataManager.func_187226_a(GateChainEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final String entityName = "gate_chain_mahoujin_entity";
    public Vec3d target = null;

    public GateChainEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public GateChainEntity(World world) {
        super(ModEntities.GATE_CHAIN, world);
        this.field_70158_ak = true;
    }

    public GateChainEntity(World world, float r, float g, float b, float a, Vec3d pos, Vec3d target) {
        this(world);
        this.setColor(r, g, b, a);
        this.target = target;
        this.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(COLOR_R, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_G, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_B, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(COLOR_A, (Object)Float.valueOf(0.0f));
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setCircleSize(compound.func_74760_g(TAG_CIRCLE_SIZE));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setLength(compound.func_74762_e(TAG_LENGTH));
        this.setColor(compound.func_74760_g(TAG_COLOR_R), compound.func_74760_g(TAG_COLOR_G), compound.func_74760_g(TAG_COLOR_B), compound.func_74760_g(TAG_COLOR_A));
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_74776_a(TAG_LENGTH, this.getLength());
        float[] colors = this.getColor();
        compound.func_74776_a(TAG_COLOR_R, colors[0]);
        compound.func_74776_a(TAG_COLOR_G, colors[1]);
        compound.func_74776_a(TAG_COLOR_B, colors[2]);
        compound.func_74776_a(TAG_COLOR_A, colors[3]);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public float getLength() {
        return ((Float)this.field_70180_af.func_187225_a(LENGTH)).floatValue();
    }

    public void setLength(float l) {
        this.field_70180_af.func_187227_b(LENGTH, (Object)Float.valueOf(l));
    }

    public float[] getColor() {
        return new float[]{((Float)this.field_70180_af.func_187225_a(COLOR_R)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_G)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_B)).floatValue(), ((Float)this.field_70180_af.func_187225_a(COLOR_A)).floatValue()};
    }

    public void setColor(float r, float g, float b, float a) {
        this.field_70180_af.func_187227_b(COLOR_R, (Object)Float.valueOf(r));
        this.field_70180_af.func_187227_b(COLOR_G, (Object)Float.valueOf(g));
        this.field_70180_af.func_187227_b(COLOR_B, (Object)Float.valueOf(b));
        this.field_70180_af.func_187227_b(COLOR_A, (Object)Float.valueOf(a));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (!this.dying) {
                if (this.field_70170_p.func_82737_E() % (long)MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN == 0L) {
                    this.setLife(this.getLife() + 1);
                    if (this.getLife() > 20) {
                        this.startDying();
                    }
                }
                if (this.target != null) {
                    Vec3d tv = this.target;
                    if ((double)this.getLength() < tv.func_72438_d(this.func_213303_ch())) {
                        this.setLength(this.getLength() + speed);
                    } else if (Utils.isBlockAir(this.field_70170_p, new BlockPos(this.target))) {
                        this.startDying();
                    }
                    this.collideWithNearbyEntities();
                }
            } else {
                this.die();
            }
        }
        this.lastlen = this.getLength();
    }

    protected void collideWithNearbyEntities() {
        float len = this.getLength();
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)len, this.func_226278_cu_() - (double)len, this.func_226281_cx_() - (double)len, this.func_226277_ct_() + (double)len, this.func_226278_cu_() + (double)len, this.func_226281_cx_() + (double)len);
        List list = this.field_70170_p.func_175674_a((Entity)this, aabb, EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            for (int l = 0; l < list.size(); ++l) {
                Entity entity = (Entity)list.get(l);
                if (!(entity instanceof LivingEntity) || !this.boxIntersectsLine(entity.func_174813_aQ())) continue;
                this.func_70108_f(entity);
            }
        }
    }

    public boolean boxIntersectsLine(AxisAlignedBB aabb) {
        return Utils.CheckLineBox(new Vec3d(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new Vec3d(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f), this.func_213303_ch(), this.func_213303_ch().func_178787_e(this.target.func_178788_d(this.func_213303_ch()).func_72432_b().func_186678_a((double)this.getLength())));
    }

    public void func_70108_f(Entity entityIn) {
        if (entityIn instanceof LivingEntity) {
            EffectUtil.magicAttack((LivingEntity)entityIn, (float)MTConfig.TREASURY_PROJECTION_CHAINS_DAMAGE);
            Vec3d v = this.func_213303_ch().func_178788_d(entityIn.func_213303_ch());
            this.boop(entityIn, 0.3f, v.field_72450_a, 0.0, v.field_72449_c);
        }
    }

    @Nullable
    public AxisAlignedBB func_70114_g(Entity entityIn) {
        return ZERO_AABB;
    }

    public void startDying() {
        this.dying = true;
    }

    public void die() {
        ++this.dyingticks;
        if (this.getLength() <= 0.5f) {
            this.func_70106_y();
        } else {
            this.setLength(this.getLength() - speed / 2.0f);
        }
    }

    private void boop(Entity entity, float strength, double x, double y, double z) {
        entity.field_70160_al = true;
        float f = MathHelper.func_76133_a((double)(x * x + z * z + y * y));
        Vec3d motion = this.func_213322_ci();
        double motionX = motion.func_82615_a();
        double motionY = motion.func_82617_b();
        double motionZ = motion.func_82616_c();
        motionX /= 2.0;
        motionZ /= 2.0;
        motionY /= 2.0;
        motionX -= x / (double)f * (double)strength;
        motionZ -= z / (double)f * (double)strength;
        motionY -= y / (double)f * (double)strength;
        entity.field_70133_I = true;
        if (entity.field_70122_E) {
            motionY /= 2.0;
            if ((motionY += (double)strength) > (double)0.4f) {
                motionY = 0.4f;
            }
        }
        entity.func_213293_j(motionX, motionY, motionZ);
    }

    public void shoot(double x, double y, double z) {
        Vec3d vec3d = new Vec3d(x, y, z).func_72432_b();
        float f = MathHelper.func_76133_a((double)GateChainEntity.func_213296_b((Vec3d)vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)vec3d.field_72450_a, (double)vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)vec3d.field_72448_b, (double)f) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (amount > 4.0f) {
            this.startDying();
            return true;
        }
        return false;
    }
}

