/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.util.Utils;

public class RhongomyniadEntity
extends Entity {
    private static final String TAG_ROTATION_YAW = "MAHOUTSUKAI_ROTATION_YAW";
    private static final String TAG_ROTATION_ROLL = "MAHOUTSUKAI_ROTATION_ROLL";
    private static final String TAG_ROTATION_PITCH = "MAHOUTSUKAI_ROTATION_PITCH";
    private static final String TAG_ROTATION_SPEED = "MAHOUTSUKAI_ROTATION_SPEED";
    private static final String TAG_CIRCLE_SIZE = "MAHOUTSUKAI_CIRCLE_SIZE";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_STACK = "MAHOUTSUKAI_STACK";
    private static final AxisAlignedBB ZERO_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final AxisAlignedBB bb = new AxisAlignedBB(-64.0, Double.NEGATIVE_INFINITY, -64.0, 64.0, Double.POSITIVE_INFINITY, 64.0);
    private static final DataParameter<Float> ROTATION_YAW = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_ROLL = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_PITCH = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> ROTATION_SPEED = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> CIRCLE_SIZE = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<ItemStack> STACK = EntityDataManager.func_187226_a(RhongomyniadEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public static final String entityName = "rhongomyniad_entity";

    public RhongomyniadEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public RhongomyniadEntity(World world) {
        super(ModEntities.RHONGOMYNIAD, world);
        this.field_70158_ak = true;
    }

    public RhongomyniadEntity(World world, PlayerEntity caster) {
        this(world);
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(caster.func_110124_au()));
    }

    public RhongomyniadEntity(World world, PlayerEntity caster, float size, ItemStack stack) {
        this(world);
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(caster.func_110124_au()));
        this.sizer(size);
        this.setStack(stack);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(ROTATION_YAW, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_ROLL, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_PITCH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(ROTATION_SPEED, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(CIRCLE_SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(STACK, (Object)ItemStack.field_190927_a);
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (!this.field_70170_p.field_72995_K && this.getCasterUUID() != null && player.func_110124_au().equals(this.getCasterUUID())) {
            if (this.getStack() != null && this.func_70089_S()) {
                this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_() + 0.5, this.func_226281_cx_(), this.getStack()));
                this.func_70106_y();
            } else {
                this.func_70106_y();
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70126_B = this.field_70177_z;
        if (this.field_70126_B < 0.0f) {
            this.field_70126_B += 360.0f;
        }
        this.setRotationYaw(this.getRotationYaw() + this.getRotationSpeed());
        this.field_70177_z = this.getRotationYaw();
        this.field_70125_A = this.getRotationPitch();
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (!this.field_70170_p.field_72995_K) {
            this.setLife(this.getLife() + 1);
            if (this.getLife() % 40 == 0) {
                float range = 20.0f;
                if (RhongomyniadEntity.operate(this.field_70170_p, this.getCasterUUID(), this.func_180425_c())) {
                    AxisAlignedBB aabb = new AxisAlignedBB(this.func_226277_ct_() - (double)range, this.func_226278_cu_() - (double)range, this.func_226281_cx_() - (double)range, this.func_226277_ct_() + (double)range, this.func_226278_cu_() + (double)range, this.func_226281_cx_() + (double)range);
                    List lst = this.field_70170_p.func_217357_a(LivingEntity.class, aabb);
                    int max_smites = MTConfig.RHONGOMYNIAD_MAX_SMITES;
                    int smites = 0;
                    for (LivingEntity e : lst) {
                        if (smites >= max_smites || !Caliburn.specialTarget(e)) continue;
                        RhongomyniadEntity.strike(e, this);
                        ++smites;
                    }
                }
            }
        }
    }

    public static void strike(LivingEntity e, RhongomyniadEntity rhongo) {
        if (Utils.getLanceMahou(rhongo.getStack()) != null) {
            float damage = Utils.getLanceMahou(rhongo.getStack()).getAttackDamage();
            SmiteEntity smite = new SmiteEntity(e.field_70170_p, e, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, damage);
            smite.func_70107_b(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
            e.field_70170_p.func_217376_c((Entity)smite);
        }
    }

    public static boolean operate(World world, UUID casterUUID, BlockPos pos) {
        int mana_drain = MTConfig.RHONGOMYNIAD_MANA_COST;
        if (casterUUID != null && pos != null && world != null) {
            boolean nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(pos, world, casterUUID, mana_drain);
            PlayerEntity caster = world.func_217371_b(casterUUID);
            if (nearbyBatteriesGaveMana || caster != null && PlayerManaManager.drainMana(caster, mana_drain, false, true) == mana_drain) {
                return true;
            }
        }
        return false;
    }

    public static void rhongomyniadLivingHurt(LivingHurtEvent event) {
        LivingEntity target = event.getEntityLiving();
        Entity source = event.getSource().func_76346_g();
        if (source instanceof LivingEntity && !Caliburn.specialTarget(target)) {
            float range = MTConfig.RHONGOMYNIAD_RANGE;
            AxisAlignedBB aabb = new AxisAlignedBB(source.func_226277_ct_() - (double)range, source.func_226278_cu_() - (double)range, source.func_226281_cx_() - (double)range, source.func_226277_ct_() + (double)range, source.func_226278_cu_() + (double)range, source.func_226281_cx_() + (double)range);
            List lst = target.field_70170_p.func_217357_a(RhongomyniadEntity.class, aabb);
            for (RhongomyniadEntity e : lst) {
                if (!RhongomyniadEntity.operate(source.field_70170_p, e.getCasterUUID(), e.func_180425_c())) continue;
                RhongomyniadEntity.strike((LivingEntity)source, e);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public void func_70100_b_(PlayerEntity entityIn) {
    }

    protected void func_145775_I() {
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
    }

    public void sizer(float s) {
        this.setCircleSize(s);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setRotationYaw(compound.func_74760_g(TAG_ROTATION_YAW));
        this.setRotationRoll(compound.func_74760_g(TAG_ROTATION_ROLL));
        this.setRotationPitch(compound.func_74760_g(TAG_ROTATION_PITCH));
        this.setRotationSpeed(compound.func_74760_g(TAG_ROTATION_SPEED));
        this.setCircleSize(compound.func_74760_g(TAG_CIRCLE_SIZE));
        this.setLife(compound.func_74762_e(TAG_LIFE));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
        if (compound.func_74764_b(TAG_STACK)) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)((CompoundNBT)compound.func_74781_a(TAG_STACK)));
            stack.func_190920_e(1);
            this.setStack(stack);
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74776_a(TAG_ROTATION_YAW, this.getRotationYaw());
        compound.func_74776_a(TAG_ROTATION_ROLL, this.getRotationRoll());
        compound.func_74776_a(TAG_ROTATION_PITCH, this.getRotationPitch());
        compound.func_74776_a(TAG_ROTATION_SPEED, this.getRotationSpeed());
        compound.func_74776_a(TAG_CIRCLE_SIZE, this.getCircleSize());
        compound.func_74768_a(TAG_LIFE, this.getLife());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
        if (this.getStack() != null) {
            compound.func_218657_a(TAG_STACK, (INBT)this.getStack().serializeNBT());
        }
    }

    public AxisAlignedBB func_184177_bl() {
        return bb;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public float getRotationYaw() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_YAW)).floatValue();
    }

    public void setRotationYaw(float y) {
        this.field_70180_af.func_187227_b(ROTATION_YAW, (Object)Float.valueOf(y));
    }

    public float getRotationRoll() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_ROLL)).floatValue();
    }

    public void setRotationRoll(float y) {
        this.field_70180_af.func_187227_b(ROTATION_ROLL, (Object)Float.valueOf(y));
    }

    public float getRotationPitch() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_PITCH)).floatValue();
    }

    public void setRotationPitch(float p) {
        this.field_70180_af.func_187227_b(ROTATION_PITCH, (Object)Float.valueOf(p));
    }

    public float getRotationSpeed() {
        return ((Float)this.field_70180_af.func_187225_a(ROTATION_SPEED)).floatValue();
    }

    public void setRotationSpeed(float s) {
        this.field_70180_af.func_187227_b(ROTATION_SPEED, (Object)Float.valueOf(s));
    }

    public float getCircleSize() {
        return ((Float)this.field_70180_af.func_187225_a(CIRCLE_SIZE)).floatValue();
    }

    public void setCircleSize(float s) {
        this.field_70180_af.func_187227_b(CIRCLE_SIZE, (Object)Float.valueOf(s));
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public ItemStack getStack() {
        return (ItemStack)this.field_70180_af.func_187225_a(STACK);
    }

    public void setStack(ItemStack s) {
        this.field_70180_af.func_187227_b(STACK, (Object)s);
    }
}

