/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity.mahoujin;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.item.mysticcode.MysticCode;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.SafeFakePlayer;

public class FallenDownEntity
extends Entity {
    PlayerEntity player;
    public static final String entityName = "fallen_down_entity";
    private static final String TAG_LIFE = "MAHOUTSUKAI_LIFE";
    private static final String TAG_CASTER = "MAHOUTSUKAI_CASTER";
    private static final String TAG_FIRED = "MAHOUTSUKAI_FIRED";
    private static final DataParameter<Integer> LIFE = EntityDataManager.func_187226_a(FallenDownEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Optional<UUID>> CASTER_UUID = EntityDataManager.func_187226_a(FallenDownEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> FIRED = EntityDataManager.func_187226_a(FallenDownEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public ArrayList<EffectInstance> effects = new ArrayList();
    public float damage = 0.0f;

    public FallenDownEntity(FMLPlayMessages.SpawnEntity packet, World worldIn) {
        super(ModEntities.FALLEN_DOWN, worldIn);
        this.field_70158_ak = true;
    }

    public FallenDownEntity(EntityType entityEntityType, World world) {
        super(entityEntityType, world);
    }

    public FallenDownEntity(World world) {
        super(ModEntities.FALLEN_DOWN, world);
        this.field_70158_ak = true;
    }

    public FallenDownEntity(World world, LivingEntity caster) {
        this(world);
        this.setCasterUUID(caster.func_110124_au());
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LIFE, (Object)0);
        this.field_70180_af.func_187214_a(CASTER_UUID, Optional.empty());
        this.field_70180_af.func_187214_a(FIRED, (Object)false);
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.setLife(compound.func_74762_e(TAG_LIFE));
        this.setFired(compound.func_74767_n(TAG_FIRED));
        if (compound.func_186855_b(TAG_CASTER)) {
            this.setCasterUUID(compound.func_186857_a(TAG_CASTER));
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a(TAG_LIFE, this.getLife());
        compound.func_74757_a(TAG_FIRED, this.getFired());
        if (this.getCasterUUID() != null) {
            compound.func_186854_a(TAG_CASTER, this.getCasterUUID());
        }
    }

    public float getGrowingLife() {
        return 15.0f;
    }

    public void func_70071_h_() {
        int radius = Math.min(this.getLife() / 20 + 1, 30);
        radius = MTConfig.FALLEN_DOWN_RADIUS;
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_82737_E() % 4L == 0L) {
            ServerPlayerEntity caster = null;
            if (this.field_70170_p.func_73046_m() != null) {
                caster = this.field_70170_p.func_73046_m().func_184103_al().func_177451_a(this.getCasterUUID());
            }
            int mana = MTConfig.FALLEN_DOWN_MANA_PER_TICK;
            if (caster == null || !(caster.func_184607_cu().func_77973_b() instanceof FallenDownSpellScroll) && !(caster.func_184607_cu().func_77973_b() instanceof MysticCode)) {
                this.func_70106_y();
            }
            if (caster == null) {
                this.func_70106_y();
                return;
            }
            if (PlayerManaManager.drainMana((PlayerEntity)caster, mana, false, false, true, false) == mana && this.getLife() > 20) {
                ((ServerWorld)this.field_70170_p).field_73004_o = Math.min((float)this.getLife() / 40.0f, 4.8f);
                AxisAlignedBB aabb = new AxisAlignedBB((double)(this.func_180425_c().func_177958_n() - radius), 0.0, (double)(this.func_180425_c().func_177952_p() - radius), (double)(this.func_180425_c().func_177958_n() + radius), 255.0, (double)(this.func_180425_c().func_177952_p() + radius));
                List lst = this.field_70170_p.func_175674_a((Entity)this, aabb, a -> a instanceof LivingEntity && !ContractMahoujinTileEntity.isImmuneToSpell(this.field_70170_p, this.getCasterUUID(), a) && a.field_70122_E);
                ArrayList<BlockPos> blocksBreak = new ArrayList<BlockPos>();
                ArrayList<BlockPos> blocksFall = new ArrayList<BlockPos>();
                for (Entity e : lst) {
                    Vec3d motion = e.func_213322_ci();
                    double motionX = motion.func_82615_a();
                    double motionY = motion.func_82617_b();
                    double motionZ = motion.func_82616_c();
                    motionX *= 0.2;
                    motionY = motionY > 0.0 ? (motionY *= 0.2) : (motionY *= 1.7);
                    motionZ *= 0.2;
                    BlockPos ep = e.func_180425_c();
                    int break_radius = 3;
                    int depth = 4;
                    for (int i = -break_radius - 1; i <= break_radius; ++i) {
                        for (int j = -break_radius - 1; j <= break_radius; ++j) {
                            BlockPos tmp;
                            int k;
                            int m = 0;
                            if (i * i + j * j >= break_radius * break_radius) continue;
                            for (k = ep.func_177956_o() - depth; k < ep.func_177956_o(); ++k) {
                                tmp = new BlockPos(ep.func_177958_n() + i, k, ep.func_177952_p() + j);
                                if (!FallenDownEntity.okToBreak(this.field_70170_p.func_180495_p(tmp), this.field_70170_p, tmp)) continue;
                                if (m >= depth / 2) {
                                    blocksFall.add(tmp);
                                } else {
                                    blocksBreak.add(tmp);
                                }
                                ++m;
                            }
                            k = (int)((float)ep.func_177956_o() + e.func_213302_cg());
                            while ((float)k < (float)ep.func_177956_o() + e.func_213302_cg() + (float)(depth / 2)) {
                                tmp = new BlockPos(ep.func_177958_n() + i, k, ep.func_177952_p() + j);
                                blocksFall.add(tmp);
                                ++k;
                            }
                        }
                    }
                    HashSet<BlockPos> setBB = new HashSet<BlockPos>(blocksBreak);
                    HashSet<BlockPos> hashSet = new HashSet<BlockPos>(blocksFall);
                }
                this.tryFakeExplosionFallenDown(blocksBreak, null, (ServerWorld)this.field_70170_p, "", false, false);
                this.tryFakeExplosionFallenDown(blocksFall, null, (ServerWorld)this.field_70170_p, "", false, true);
            }
        }
        this.setLife(this.getLife() + 1);
    }

    public void tryFakeExplosionFallenDown(List<BlockPos> affected, PlayerEntity caster, ServerWorld world, String name, boolean drop, boolean fall) {
        if (caster == null && this.player == null) {
            this.player = new SafeFakePlayer(world, new GameProfile(UUID.randomUUID(), name));
        } else if (caster != null) {
            this.player = caster;
        }
        Collections.shuffle(affected);
        FakeExplosion explosion = new FakeExplosion((World)world, (Entity)this.player, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), 10.0f, affected);
        ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(this.player.field_70170_p, (Explosion)explosion, new ArrayList());
        MinecraftForge.EVENT_BUS.post((Event)ee);
        int limit = 0;
        if (!ee.isCanceled()) {
            for (BlockPos p : ee.getAffectedBlocks()) {
                if (limit >= MTConfig.FALLEN_DOWN_BLOCK_BREAK_PER_TICK) break;
                BlockState bs = this.player.field_70170_p.func_180495_p(p);
                if (!FallenDownEntity.okToBreak(bs, this.player.field_70170_p, p)) continue;
                if (!fall) {
                    if (drop) {
                        Block.func_220059_a((BlockState)bs, (World)world, (BlockPos)p, (TileEntity)world.func_175625_s(p));
                    }
                    this.player.field_70170_p.func_217377_a(p, false);
                    this.player.field_70170_p.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                } else if (world.func_175623_d(p.func_177977_b()) || FallingBlock.func_185759_i((BlockState)world.func_180495_p(p.func_177977_b())) && p.func_177956_o() >= 0) {
                    FallingBlockEntity fallingblockentity = new FallingBlockEntity((World)world, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o(), (double)p.func_177952_p() + 0.5, world.func_180495_p(p));
                    world.func_217376_c((Entity)fallingblockentity);
                }
                ++limit;
            }
        }
    }

    public static boolean okToBreak(BlockState bs, World w, BlockPos p) {
        return bs.func_177230_c() != Blocks.field_150357_h && !bs.func_177230_c().isAir(bs, (IBlockReader)w, p) && w.func_175625_s(p) == null;
    }

    public boolean fall(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos.func_177977_b()) || FallingBlock.func_185759_i((BlockState)worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            return worldIn.func_175625_s(pos) == null && worldIn.func_180495_p(pos).func_177230_c() != Blocks.field_150357_h;
        }
        return false;
    }

    public void dofall(World worldIn, BlockPos pos) {
        if (worldIn.func_175623_d(pos.func_177977_b().func_177977_b()) && this.field_70146_Z.nextDouble() < 0.3) {
            worldIn.func_175656_a(pos.func_177977_b().func_177977_b(), worldIn.func_180495_p(pos));
            worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        } else {
            worldIn.func_175656_a(pos.func_177977_b(), worldIn.func_180495_p(pos));
            worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
    }

    public int getLife() {
        return (Integer)this.field_70180_af.func_187225_a(LIFE);
    }

    public void setLife(int l) {
        this.field_70180_af.func_187227_b(LIFE, (Object)l);
    }

    public UUID getCasterUUID() {
        return ((Optional)this.field_70180_af.func_187225_a(CASTER_UUID)).orElse(null);
    }

    public void setCasterUUID(UUID uuid) {
        this.field_70180_af.func_187227_b(CASTER_UUID, Optional.of(uuid));
    }

    public boolean getFired() {
        return (Boolean)this.field_70180_af.func_187225_a(FIRED);
    }

    public void setFired(boolean f) {
        this.field_70180_af.func_187227_b(FIRED, (Object)f);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

