/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.handlers;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.registries.IForgeRegistry;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.block.MahoujinProjector;
import stepsword.mahoutsukai.block.ModBlocks;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouStorage;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.containers.ModContainers;
import stepsword.mahoutsukai.capability.gemmahou.GemMahou;
import stepsword.mahoutsukai.capability.gemmahou.GemMahouStorage;
import stepsword.mahoutsukai.capability.gemmahou.IGemMahou;
import stepsword.mahoutsukai.capability.kodoku.IKodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahou;
import stepsword.mahoutsukai.capability.kodoku.KodokuMahouStorage;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahou;
import stepsword.mahoutsukai.capability.lance.LanceMahouStorage;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.Mahou;
import stepsword.mahoutsukai.capability.mahou.MahouProvider;
import stepsword.mahoutsukai.capability.mahou.MahouStorage;
import stepsword.mahoutsukai.capability.mahou.ManaEvents;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.capability.scrollmahou.IScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahou;
import stepsword.mahoutsukai.capability.scrollmahou.ScrollMahouStorage;
import stepsword.mahoutsukai.capability.worldsave.IWorldMahou;
import stepsword.mahoutsukai.capability.worldsave.WorldMahou;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouProvider;
import stepsword.mahoutsukai.capability.worldsave.WorldMahouStorage;
import stepsword.mahoutsukai.commands.ModCommands;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.dimensions.ModBiomes;
import stepsword.mahoutsukai.dimensions.ModDimensions;
import stepsword.mahoutsukai.effects.Kodoku;
import stepsword.mahoutsukai.effects.displacement.EquivalentDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.MentalDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProjectileDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.displacement.ProtectiveDisplacementSpellEffect;
import stepsword.mahoutsukai.effects.exchange.DamageExchangeSpellEffect;
import stepsword.mahoutsukai.effects.familiar.FamiliarsGardenEffect;
import stepsword.mahoutsukai.effects.familiar.SummonFamiliarSpellEffect;
import stepsword.mahoutsukai.effects.mystic.DamageReplicationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ClarentEffect;
import stepsword.mahoutsukai.effects.projection.MorganEffect;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.effects.projection.RealityMarbleSpellEffect;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.effects.secret.GeasEffect;
import stepsword.mahoutsukai.enchant.ModEnchantments;
import stepsword.mahoutsukai.entity.ModEntities;
import stepsword.mahoutsukai.entity.RhongomyniadEntity;
import stepsword.mahoutsukai.integration.GameStagesLoadedProxy;
import stepsword.mahoutsukai.integration.GameStagesProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.emrys.StaffEmrys;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.MysticStaff;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.potion.BindingEyesPotion;
import stepsword.mahoutsukai.potion.BlackFlameEyesPotion;
import stepsword.mahoutsukai.potion.BorrowedAuthorityPotion;
import stepsword.mahoutsukai.potion.BoundPotion;
import stepsword.mahoutsukai.potion.ClairvoyanceEyesPotion;
import stepsword.mahoutsukai.potion.ConfusionPotion;
import stepsword.mahoutsukai.potion.DeathCollectionEyesPotion;
import stepsword.mahoutsukai.potion.FaySightEyesPotion;
import stepsword.mahoutsukai.potion.FearPotion;
import stepsword.mahoutsukai.potion.ForesightPotion;
import stepsword.mahoutsukai.potion.ImmunityExchangePotion;
import stepsword.mahoutsukai.potion.InsightEyesPotion;
import stepsword.mahoutsukai.potion.MisfortunePotion;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.ReversionEyesPotion;
import stepsword.mahoutsukai.potion.RipperInvisPotion;
import stepsword.mahoutsukai.potion.WoundedPotion;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.tile.exchange.AlchemicalExchangeMahoujinTileEntity;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;

public class ServerHandler {
    public static final ResourceLocation MAHOU = new ResourceLocation("mahoutsukai", "mahou");

    @SubscribeEvent
    public void onBlocksRegistration(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public void onItemsRegistration(RegistryEvent.Register<Item> event) {
        ModItems.init();
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
    }

    @SubscribeEvent
    public void onEffectRegistration(RegistryEvent.Register<Effect> event) {
        ModEffects.register((IForgeRegistry<Effect>)event.getRegistry());
    }

    @SubscribeEvent
    public void onEnchantmentRegistration(RegistryEvent.Register<Enchantment> event) {
        ModEnchantments.register((IForgeRegistry<Enchantment>)event.getRegistry());
    }

    @SubscribeEvent
    public void onContainerRegistration(RegistryEvent.Register<ContainerType<?>> event) {
        ModContainers.registerContainers(event.getRegistry());
    }

    @SubscribeEvent
    public void onModDimensionRegistration(RegistryEvent.Register<ModDimension> event) {
        ModDimensions.register((IForgeRegistry<ModDimension>)event.getRegistry());
    }

    @SubscribeEvent
    public void onDimensionRegistration(RegisterDimensionsEvent event) {
        ModDimensions.init();
    }

    @SubscribeEvent
    public void onDimensionRegistratio(RegistryEvent.Register<Biome> event) {
        ModBiomes.register();
    }

    @SubscribeEvent
    public void registerParticles(RegistryEvent.Register<ParticleType<?>> evt) {
        ModParticles.registerParticles(evt);
    }

    @SubscribeEvent
    public void onTileEntityTypeRegistration(RegistryEvent.Register<TileEntityType<?>> event) {
        ModTileEntities.createTypes();
        ModTileEntities.register(event.getRegistry());
    }

    @SubscribeEvent
    public void onEnittyRegistration(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.register(event.getRegistry());
    }

    @SubscribeEvent
    public void commonStartup(FMLCommonSetupEvent event) {
        PacketHandler.init();
        CapabilityManager.INSTANCE.register(IMahou.class, (Capability.IStorage)new MahouStorage(), () -> new Mahou());
        CapabilityManager.INSTANCE.register(IGemMahou.class, (Capability.IStorage)new GemMahouStorage(), () -> new GemMahou());
        CapabilityManager.INSTANCE.register(IScrollMahou.class, (Capability.IStorage)new ScrollMahouStorage(), () -> new ScrollMahou());
        CapabilityManager.INSTANCE.register(IWorldMahou.class, (Capability.IStorage)new WorldMahouStorage(), () -> new WorldMahou());
        CapabilityManager.INSTANCE.register(ICaliburnMahou.class, (Capability.IStorage)new CaliburnMahouStorage(), () -> new CaliburnMahou());
        CapabilityManager.INSTANCE.register(ILanceMahou.class, (Capability.IStorage)new LanceMahouStorage(), () -> new LanceMahou());
        CapabilityManager.INSTANCE.register(IKodokuMahou.class, (Capability.IStorage)new KodokuMahouStorage(), () -> new KodokuMahou());
        MahoujinRecipeRegistrar.init();
        AlchemicalExchangeMahoujinTileEntity.init();
        ModEntities.registerSpawns();
        MahouTsukaiMod.gamestages = ModList.get().isLoaded("gamestages") ? new GameStagesLoadedProxy() : new GameStagesProxy();
    }

    @SubscribeEvent
    public void livingUse(LivingEntityUseItemEvent.Stop event) {
        StrengtheningSpellEffect.strengtheningUseEvent(event);
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(MAHOU, (ICapabilityProvider)new MahouProvider());
        }
    }

    @SubscribeEvent
    public void attachCapabilityWorld(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof World) {
            event.addCapability(MAHOU, (ICapabilityProvider)new WorldMahouProvider());
        }
    }

    @SubscribeEvent
    public void serverLoad(FMLServerStartingEvent event) {
        ModCommands.register((CommandDispatcher<CommandSource>)event.getCommandDispatcher());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void tickCheck(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.func_72820_D() % 10L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            InsightEyesPotion.insightEyesPlayerTick(event.player);
            BorrowedAuthorityPotion.authorityPlayerTick(event.player);
            BindingEyesPotion.bindingEyesPlayerTick(event.player);
            ReversionEyesPotion.reversionEyesPlayerTick(event.player);
            ClairvoyanceEyesPotion.clairvoyanceEyesPlayerTick(event.player);
            FearPotion.fearPlayerTick(event.player);
        }
        if (event.player.field_70170_p.func_72820_D() % 100L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            PlayerManaManager.regenMana(event.player, false);
        }
        if (event.player.field_70170_p.func_72820_D() % 4L == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            FaySightEyesPotion.faySightEyesPlayerTick(event.player);
        }
        if (event.player.field_70170_p.func_72820_D() % (long)MTConfig.BLACK_FLAME_IGNITION_TICKS == 0L && !event.player.field_70170_p.field_72995_K && event.phase == TickEvent.Phase.END) {
            BlackFlameEyesPotion.blackFlameEyesPlayerTick(event.player);
        }
        if (event.player.field_70170_p.func_72820_D() % 100L == 0L && !(event.player.func_184607_cu().func_77973_b() instanceof MysticStaff)) {
            MahouTsukaiMod.proxy.speedUp();
        }
        PowerConsolidationSpellEffect.powerConsolidationPlayerLiquidMovement(event);
    }

    @SubscribeEvent
    public void playerJump(LivingEvent.LivingJumpEvent event) {
        BorrowedAuthorityPotion.authorityJump(event.getEntityLiving());
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void worldTick(TickEvent.WorldTickEvent event) {
        PowerConsolidationSpellEffect.powerConsolidationWorldTick(event);
        PowerConsolidationSpellEffect.powerConsolidationLiquidMovement(event);
    }

    @SubscribeEvent
    public void livingEvent(LivingEvent.LivingUpdateEvent event) {
        ServerHandler.cancelEvent((Event)event, BindingEyesPotion.bindingEyesLivingUpdate(event.getEntityLiving()));
        BorrowedAuthorityPotion.authorityLivingUpdate(event.getEntityLiving());
        ReversionEyesPotion.reversionEyesLivingUpdate(event.getEntityLiving());
        BlackFlameEyesPotion.blackFlameEyesLivingUpdate(event.getEntityLiving());
        FearPotion.fearLivingUpdate(event.getEntityLiving());
        MentalDisplacementSpellEffect.mentalDisplacementLivingUpdate((Entity)event.getEntityLiving());
        FamiliarsGardenEffect.familiarsGardenLivingUpdate(event.getEntityLiving());
        MisfortunePotion.misfortuneLivingUpdate(event.getEntityLiving());
        ConfusionPotion.confusionLivingUpdate(event.getEntityLiving());
        WoundedPotion.woundedLivingTick(event.getEntityLiving());
        TheRipper.ripperLivingTick(event.getEntityLiving());
        RipperInvisPotion.presenceConcealmentLivingTick(event.getEntityLiving());
    }

    @SubscribeEvent
    public void placeEvent(BlockEvent.EntityPlaceEvent event) {
        ForesightPotion.butterflyPlaceBlock(event);
    }

    @SubscribeEvent
    public void attackFromPlayer(AttackEntityEvent event) {
        boolean canceled = BoundPotion.boundAttackFromPlayer(event.getPlayer()) || FamiliarsGardenEffect.familiarsGardenAttackEntity(event.getTarget(), event.getPlayer()) || GeasEffect.geasAttackEntity(event);
        ServerHandler.cancelEvent((Event)event, canceled);
        ServerHandler.cancelEvent((Event)event, canceled);
        if (!canceled) {
            BorrowedAuthorityPotion.authorityAttackFromPlayer(event.getPlayer(), event.getTarget());
            StaffEmrys.emrysHit(event);
        }
    }

    @SubscribeEvent
    public void useItem(EntityItemPickupEvent event) {
        ServerHandler.cancelEvent((Event)event, GeasEffect.geasItem(event));
    }

    @SubscribeEvent
    public void leftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundLeftClickBlock(event.getPlayer()));
        PowerConsolidationSpellEffect.caliburnLeftClickBlock(event);
        BorrowedAuthorityPotion.borrowedAuthorityLeftClickBlock(event.getPlayer());
    }

    @SubscribeEvent
    public void rightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickBlock(event.getPlayer()));
        ManaEvents.rightClickCircle(event.getPlayer(), event.getPos());
        EquivalentDisplacementSpellEffect.equivalentDisplacementShiftRightClick(event);
        MahoujinProjector.projectorRightClick(event);
    }

    @SubscribeEvent
    public void rightClickItem(PlayerInteractEvent.RightClickItem event) {
        ServerHandler.cancelEvent((Event)event, BoundPotion.boundRightClickItem(event.getPlayer()));
        ClarentEffect.clarentOnRightClick(event.getPlayer());
    }

    @SubscribeEvent
    public void projectileImpact(ProjectileImpactEvent.Arrow event) {
        boolean z = ReversionEyesPotion.reversionEyesProjectileImpact(event.getEntity(), event.getRayTraceResult());
        ServerHandler.cancelEvent((Event)event, z);
        if (!z) {
            ServerHandler.cancelEvent((Event)event, ProtectiveDisplacementSpellEffect.protectiveDisplacementProjectileImpact((ProjectileImpactEvent)event));
        }
    }

    @SubscribeEvent
    public void potionFinish(PotionEvent.PotionRemoveEvent event) {
        if (event.getPotion() == ModEffects.BLACK_FLAME_EYES) {
            BlackFlameEyesPotion.blackFlameEyesPotionFinish(event.getEntityLiving());
        }
        if (event.getPotion() == ModEffects.MISFORTUNE) {
            Kodoku.kodokuPotionRemove(event);
        }
    }

    @SubscribeEvent
    public void anvilRepair(AnvilRepairEvent event) {
        ProjectionSpellEffect.projectionRepairAnvil(event);
    }

    @SubscribeEvent
    public void anvilUpdate(AnvilUpdateEvent event) {
        ProjectionSpellEffect.projectionUpdateAnvil(event);
    }

    @SubscribeEvent
    public void startTracking(PlayerEvent.StartTracking event) {
        Entity e = event.getTarget();
        if (e instanceof LivingEntity) {
            ReversionEyesPotion.notifyIfReverted((LivingEntity)e);
            BlackFlameEyesPotion.notifyIfBurning((LivingEntity)e);
            RipperInvisPotion.notifyIfInvisible((LivingEntity)e);
        }
    }

    @SubscribeEvent
    public void livingDeath(LivingDeathEvent event) {
        boolean cancels = DeathCollectionEyesPotion.deathCollectionEyesLivingDeath(event.getEntityLiving());
        ServerHandler.cancelEvent((Event)event, cancels);
        DamageReplicationSpellEffect.damageReplicationLivingDeath((Entity)event.getEntityLiving());
        if (!cancels) {
            MorganEffect.morganLivingDeath(event);
        }
        if (!cancels) {
            Kodoku.kodokuEntityDeath(event);
        }
    }

    @SubscribeEvent
    public void livingHurt(LivingHurtEvent event) {
        StrengtheningSpellEffect.strengtheningLivingHurt(event);
        RealityMarbleSpellEffect.realityMarbleLivingHurt(event.getEntity());
        ManaEvents.manaPlayerHurt(event.getEntityLiving(), event.getAmount());
        DamageExchangeSpellEffect.damageExchangeLivingHurt(event);
        RhongomyniadEntity.rhongomyniadLivingHurt(event);
        StaffEmrys.emrysLivingHurt(event);
        ClarentEffect.clarentLivingHurt(event);
        TheRipper.ripperOnHit(event);
        ServerHandler.cancelEvent((Event)event, ImmunityExchangePotion.immunityExchangeLivingHurt(event));
        ServerHandler.cancelEvent((Event)event, GeasEffect.geasLivingHurt(event));
    }

    @SubscribeEvent
    public void livingAttack(LivingAttackEvent event) {
        StrengtheningSpellEffect.strengtheningArmorEvent(event);
        ClarentEffect.clarentLivingAttack(event);
    }

    @SubscribeEvent
    public void struckByLightning(EntityStruckByLightningEvent event) {
        StaffEmrys.emrysStruckByLightning(event);
    }

    @SubscribeEvent
    public void harvestCheck(PlayerEvent.HarvestCheck event) {
        StrengtheningSpellEffect.strengtheningHarvestCheck(event);
    }

    @SubscribeEvent
    public void breakEvent(BlockEvent.BreakEvent event) {
        StrengtheningSpellEffect.strengtheningBreakEvent(event);
        MisfortunePotion.misfortuneBreakEvent(event);
        ForesightPotion.butterflyBreakBlock(event);
    }

    @SubscribeEvent
    public void breakSpeedEvent(PlayerEvent.BreakSpeed event) {
        StrengtheningSpellEffect.strengtheningBreakSpeed(event);
    }

    @SubscribeEvent
    public void chunkUnload(ChunkEvent.Unload event) {
        RealityMarbleSpellEffect.realityMarbleChunkUnload(event);
    }

    @SubscribeEvent
    public void chunkLoad(ChunkEvent.Load event) {
        RealityMarbleSpellEffect.realityMarbleChunkLoad(event);
    }

    @SubscribeEvent
    public void livingFall(LivingFallEvent event) {
        ServerHandler.cancelEvent((Event)event, RealityMarbleSpellEffect.realityMarbleLivingFall(event));
    }

    @SubscribeEvent
    public void entityJoinWorldEvent(EntityJoinWorldEvent event) {
        ProjectileDisplacementSpellEffect.projectileDisplacementJoinWorld(event.getEntity());
    }

    @SubscribeEvent
    public void explosionEvent(ExplosionEvent.Start event) {
        FamiliarsGardenEffect.familiarsGardenExplosion(event.getExplosion().func_94613_c());
    }

    @SubscribeEvent
    public void livingDamageEvent(LivingDamageEvent event) {
        ServerHandler.cancelEvent((Event)event, FamiliarsGardenEffect.familiarsGardenLivingDamage(event));
        DamageReplicationSpellEffect.damageReplicationLivingDamage(event);
        ContractMahoujinTileEntity.breakContract(event);
    }

    @SubscribeEvent
    public void rightClickEntity(PlayerInteractEvent.EntityInteract event) {
        SummonFamiliarSpellEffect.familiarRightClick(event);
    }

    @SubscribeEvent
    public void useItem(LivingEntityUseItemEvent.Finish event) {
        ManaEvents.drinkMilk(event);
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone event) {
        ManaEvents.mahouClone(event);
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ManaEvents.mahouLogin(event.getPlayer());
    }

    @SubscribeEvent
    public void playerSlept(PlayerWakeUpEvent event) {
        if (!event.wakeImmediately() && !event.updateWorld()) {
            ManaEvents.mahouSleep(event.getPlayer());
        }
    }

    @SubscribeEvent
    public void potionAdded(PotionEvent.PotionAddedEvent event) {
        DamageReplicationSpellEffect.damageReplicationPotionAdded(event);
    }

    @SubscribeEvent
    public void setTargetEvent(LivingSetAttackTargetEvent event) {
        ServerHandler.cancelEvent((Event)event, FearPotion.fearLivingSetAttack(event.getEntityLiving(), event.getTarget()));
    }

    @SubscribeEvent
    public void livingDrops(LivingDropsEvent event) {
        MisfortunePotion.misfortuneLootEvent(event);
    }

    @SubscribeEvent
    public void harvestDrops(BlockEvent.HarvestDropsEvent event) {
        MisfortunePotion.misfortuneHarvestEvent(event);
    }

    public static void cancelEvent(Event e, boolean c) {
        if (e.isCancelable() && !e.isCanceled()) {
            e.setCanceled(c);
        }
    }
}

