/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.integration;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import stepsword.jousting.item.ItemLance;
import stepsword.mahoutsukai.capability.lance.ILanceMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.PowerConsolidationSpellEffect;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.integration.JoustingProxy;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.item.lance.Rhongomyniad;
import stepsword.mahoutsukai.util.Utils;

public class JoustingLoadedProxy
extends JoustingProxy {
    @Override
    public void registerItems(IForgeRegistry<Item> registry) {
        ModItems.rhongomyniad = new Rhongomyniad();
        registry.register((IForgeRegistryEntry)ModItems.rhongomyniad);
    }

    @Override
    public void powerConsolidation(TickEvent.WorldTickEvent event, ItemEntity item, List<ItemEntity> toDelete, List<WeaponProjectileEntity> toSpawn) {
        if (item.func_92059_d().func_77973_b() instanceof ItemLance && PowerConsolidationSpellEffect.isItemAllowed(item.func_92059_d())) {
            boolean z = Utils.isInMurkyWater((Entity)item);
            double rhongomyniadNerf = MTConfig.RHONGOMYNIAD_NERF_FACTOR;
            if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                System.out.println("Allowed sword found. Is in murky water: " + z);
            }
            if (z) {
                PlayerEntity player;
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    System.out.println("Lance is enchanted:" + item.func_92059_d().func_77948_v());
                }
                if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                    System.out.println("ThrowerID:" + item.func_200214_m());
                }
                if (item.func_92059_d().func_77948_v() && item.func_200214_m() != null && (player = event.world.func_217371_b(item.func_200214_m())) != null) {
                    HashSet<BlockPos> connected = new HashSet<BlockPos>();
                    boolean lt = PowerConsolidationSpellEffect.lakeThreshhold(item.func_180425_c(), connected, event.world);
                    if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                        System.out.println("Lake Threshhold:" + lt);
                    }
                    if (lt) {
                        ItemStack stack;
                        ILanceMahou mahou;
                        BlockPos p = PowerConsolidationSpellEffect.findCenter(connected);
                        if (!Utils.isBlockAir(event.world, p)) {
                            p = p.func_177977_b();
                        }
                        if ((mahou = Utils.getLanceMahou(stack = new ItemStack((IItemProvider)ModItems.rhongomyniad))) != null) {
                            float damage = Rhongomyniad.simulateHit(item.func_92059_d(), event.world);
                            ItemStack stackCopy = item.func_92059_d().func_77946_l();
                            ListNBT tagList = stackCopy.func_77986_q();
                            tagList.clear();
                            float damageWithoutEnchant = Rhongomyniad.simulateHit(stackCopy, event.world);
                            damage = (float)((double)damage - rhongomyniadNerf * (double)(damage - damageWithoutEnchant));
                            mahou.setAttackDamage(damage -= 1.0f);
                            mahou.setWeight(mahou.getWeight() - 0.02f);
                            Rhongomyniad.setattacktonbt(stack, event.world);
                        }
                        if (MTConfig.RHO_AIAS_KILL_DEBUG) {
                            System.out.println("Advancement Time");
                        }
                        WeaponProjectileEntity wpe = new WeaponProjectileEntity(event.world, p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), stack);
                        wpe.func_213293_j(0.0, -1.0, 0.0);
                        wpe.func_212361_a((Entity)player);
                        toSpawn.add(wpe);
                        toDelete.add(item);
                    }
                }
            }
        }
    }

    @Override
    public boolean treasuryProjection(Item i) {
        return i instanceof ItemLance;
    }
}

