/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.clarent;

import com.google.common.collect.Multimap;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahou;
import stepsword.mahoutsukai.capability.caliburn.CaliburnMahouProvider;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.render.item.ClarentRenderer;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class Clarent
extends SwordItem {
    protected String name = "clarent";
    public static String MT_ATTACK_DAMAGE = "mahoutsukai_clarent_attack";

    public Clarent() {
        super((IItemTier)ItemTier.IRON, 10, 1.0f, new Item.Properties().func_200916_a(ModItems.MAHOUTSUKAI_CREATIVE_TAB).func_200918_c(MTConfig.CLARENT_DURABILITY).setISTER(() -> ClarentRenderer::new));
        this.setRegistryName(this.name);
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof Clarent) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        Clarent.setattacktonbt(stack, worldIn);
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new CaliburnMahouProvider();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (EffectUtil.inEnchantBlacklist(enchantment, MTConfig.POWER_CONSOLIDATION_ENCHANT_BLACKLIST)) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public CompoundNBT getShareTag(ItemStack stack) {
        CompoundNBT ret = super.getShareTag(stack);
        if (ret == null) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            return (CompoundNBT)CaliburnMahouProvider.MAHOU.getStorage().writeNBT(CaliburnMahouProvider.MAHOU, (Object)mahou, null);
        }
        return ret;
    }

    public static void setattacktonbt(ItemStack stack, World world) {
        if (stack != null && !world.field_72995_K) {
            ICaliburnMahou mahou;
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
            }
            if ((mahou = Utils.getCaliburnMahou(stack)) != null) {
                nbt.func_74776_a(MT_ATTACK_DAMAGE, mahou.getAttackDamage());
            }
            stack.func_77982_d(nbt);
        }
    }

    public static void getattackfromnbt(ItemStack stack) {
        ICaliburnMahou mahou;
        CompoundNBT nbt;
        if (stack != null && stack.func_77942_o() && (nbt = stack.func_77978_p()) != null && nbt.func_74764_b(MT_ATTACK_DAMAGE) && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            mahou.setAttackDamage(Math.max(nbt.func_74760_g(MT_ATTACK_DAMAGE), mahou.getAttackDamage()));
        }
    }

    public void readShareTag(ItemStack stack, CompoundNBT nbtt) {
        if (nbtt != null) {
            ICaliburnMahou caliburnMahou = Utils.getCaliburnMahou(stack);
            CaliburnMahou serverCaliburnMahou = new CaliburnMahou();
            CaliburnMahouProvider.MAHOU.getStorage().readNBT(CaliburnMahouProvider.MAHOU, (Object)serverCaliburnMahou, null, (INBT)nbtt);
            if (caliburnMahou != null) {
                caliburnMahou.setAttackDamage(serverCaliburnMahou.getAttackDamage());
            }
        }
        super.readShareTag(stack, nbtt);
    }

    public static float calculateDamageFromWeapon(ItemStack s) {
        float r = 1.0f;
        Multimap map = s.func_77973_b().getAttributeModifiers(EquipmentSlotType.MAINHAND, s);
        float d = 1.0f;
        for (AttributeModifier m : map.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())) {
            if (m.func_220375_c() == AttributeModifier.Operation.ADDITION) {
                r = (float)((double)r + m.func_111164_d());
            }
            d = r;
            if (m.func_220375_c() == AttributeModifier.Operation.MULTIPLY_BASE) {
                d = (float)((double)d + (double)r * m.func_111164_d());
            }
            if (m.func_220375_c() != AttributeModifier.Operation.MULTIPLY_TOTAL) continue;
            d = (float)((double)d * (1.0 + m.func_111164_d()));
        }
        return d;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        if (handIn == Hand.MAIN_HAND) {
            player.func_184598_c(handIn);
        }
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(handIn));
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity player, int cnt) {
        if (!world.field_72995_K) {
            ICaliburnMahou mahou = Utils.getCaliburnMahou(stack);
            if (mahou != null) {
                mahou.setAttackDamage(Math.max(0.0f, mahou.getAttackDamage() - (float)(this.func_77626_a(stack) - cnt) * (float)MTConfig.CLARENT_DECREASE_PER_BLOCKING_TICK));
            }
            Clarent.setattacktonbt(stack, world);
        }
        super.func_77615_a(stack, world, player, cnt);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        float damage = 3.0f;
        Clarent.getattackfromnbt(stack);
        if (slot == EquipmentSlotType.MAINHAND) {
            ICaliburnMahou mahou;
            if (stack != null && (mahou = Utils.getCaliburnMahou(stack)) != null) {
                damage = mahou.getAttackDamage();
            }
            multimap.removeAll((Object)SharedMonsterAttributes.field_111264_e.func_111108_a());
            multimap.removeAll((Object)SharedMonsterAttributes.field_188790_f.func_111108_a());
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)damage, AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -2.600000095367432, AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.CLARENT_DURABILITY;
    }
}

