/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.emrys;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.StrengtheningSpellEffect;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MahouLightningBoltEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.ModItems;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.render.item.StaffEmrysRenderer;
import stepsword.mahoutsukai.tile.exchange.ContractMahoujinTileEntity;
import stepsword.mahoutsukai.util.EffectUtil;

public class StaffEmrys
extends ItemBase {
    public static HashMap<UUID, StaffEmrysUserStorage> staffs = new HashMap();

    public StaffEmrys() {
        super("staff_emrys", new Item.Properties().func_200917_a(1).setISTER(() -> StaffEmrysRenderer::new));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity player, Hand handIn) {
        staffs.remove(player.func_110124_au());
        if (handIn == Hand.OFF_HAND) {
            player.func_184598_c(handIn);
            return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(handIn));
        }
        return new ActionResult(ActionResultType.FAIL, (Object)player.func_184586_b(handIn));
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        StaffEmrysUserStorage storage;
        if (staffs.containsKey(player.func_110124_au())) {
            storage = staffs.get(player.func_110124_au());
        } else {
            storage = new StaffEmrysUserStorage();
            staffs.put(player.func_110124_au(), storage);
        }
        if (!player.field_70170_p.field_72995_K && player instanceof PlayerEntity && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.EMRYS_MANA_COST_FOCUSED / 20, false, false) == MTConfig.EMRYS_MANA_COST_FOCUSED / 20) {
            double d = 30.0;
            double addX = d * (double)player.func_70681_au().nextFloat() - d / 2.0;
            double addZ = d * (double)player.func_70681_au().nextFloat() - d / 2.0;
            double addY = player.func_70681_au().nextInt(2) - 2;
            int charge = this.getRemainingUseDuration(stack, count);
            ((ServerWorld)player.field_70170_p).field_73004_o = Math.min((float)charge / 40.0f, 2.4f);
            ((ServerWorld)player.field_70170_p).field_73017_q = Math.min((float)charge / 40.0f, 2.4f);
            if ((float)charge / 15.0f > 2.4f) {
                if (player.func_70681_au().nextFloat() < 0.2f) {
                    StaffEmrys.addLightningBolt((ServerWorld)player.field_70170_p, new MahouLightningBoltEntity(player.field_70170_p, player.func_226277_ct_() + addX, player.func_226278_cu_() + addY, player.func_226281_cx_() + addZ, false));
                }
                boolean ball = true;
                if (storage.lightnings != null) {
                    for (int i = 0; i < storage.lightnings.size(); ++i) {
                        if (storage.lightnings.get(i).func_70089_S() && ball) {
                            storage.lightnings.get(i).setHasBall(ball);
                            ball = false;
                            continue;
                        }
                        storage.lightnings.get(i).setHasBall(false);
                    }
                }
                if (player.field_70170_p.func_82737_E() % 10L == 0L) {
                    float radius = MTConfig.EMRYS_MAX_RANGE;
                    AxisAlignedBB aabb = new AxisAlignedBB(player.func_226277_ct_() - (double)radius, player.func_226278_cu_() - (double)radius, player.func_226281_cx_() - (double)radius, player.func_226277_ct_() + (double)radius, player.func_226278_cu_() + (double)(radius * 2.0f), player.func_226281_cx_() + (double)radius);
                    List lst = player.field_70170_p.func_217357_a(LivingEntity.class, aabb);
                    Vec3d myloc = player.func_213303_ch();
                    lst.sort((e1, e2) -> (int)(e1.func_213303_ch().func_72436_e(myloc) - e2.func_213303_ch().func_72436_e(myloc)));
                    storage.lightnings.removeIf(a -> !a.func_70089_S());
                    storage.connected = new HashSet();
                    storage.lightnings.forEach(a -> {
                        if (a != null && a.target != null) {
                            storage.connected.add(a.target.func_110124_au());
                        }
                    });
                    for (LivingEntity e : lst) {
                        if (storage.lightnings.size() >= 3) break;
                        if (e.func_110124_au().equals(player.func_110124_au()) || storage.connected.contains(e.func_110124_au()) || ContractMahoujinTileEntity.isImmuneToSpell(player.field_70170_p, player.func_110124_au(), (Entity)e) || !this.validTarget(player, e)) continue;
                        LightningEntity le = new LightningEntity(player.field_70170_p, player, e, 1.0f, 1.0f, 1.0f, 1.0f, 0.02f, false);
                        player.field_70170_p.func_217376_c((Entity)le);
                        storage.lightnings.add(le);
                    }
                    if (storage.lightnings != null) {
                        for (int i = 0; i < storage.lightnings.size(); ++i) {
                            if (i == 0) {
                                storage.lightnings.get(i).setHasBall(true);
                                continue;
                            }
                            storage.lightnings.get(i).setHasBall(false);
                        }
                    }
                }
            }
        }
    }

    public boolean validTarget(LivingEntity caster, LivingEntity target) {
        if (!target.func_70089_S()) {
            return false;
        }
        boolean inrange = EffectUtil.inRange(target, caster, caster.func_213303_ch(), MTConfig.EMRYS_MAX_RANGE, false);
        if (inrange) {
            Vec3d targetEye = target.func_174824_e(1.0f);
            Vec3d casterEye = caster.func_174824_e(1.0f);
            Vec3d diff = targetEye.func_178788_d(casterEye);
            double len = diff.func_72433_c();
            Vec3d dir = diff.func_72432_b();
            int i = 0;
            while ((double)i < len) {
                BlockPos p = new BlockPos(casterEye.func_178787_e(dir.func_186678_a((double)i)));
                if (!caster.field_70170_p.func_175623_d(p)) {
                    return false;
                }
                ++i;
            }
            if (!ContractMahoujinTileEntity.isImmuneToSpell(caster.field_70170_p, caster.func_110124_au(), (Entity)target)) {
                return true;
            }
        }
        return false;
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity caster, int t) {
        if (caster != null) {
            StaffEmrysUserStorage storage;
            if (staffs.containsKey(caster.func_110124_au())) {
                storage = staffs.get(caster.func_110124_au());
            } else {
                storage = new StaffEmrysUserStorage();
                staffs.put(caster.func_110124_au(), storage);
            }
            if (!world.field_72995_K) {
                for (LightningEntity e : storage.lightnings) {
                    e.func_70106_y();
                }
                staffs.remove(caster.func_110124_au());
            }
        }
        super.func_77615_a(stack, world, caster, t);
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BOW;
    }

    public int getMaxDamage(ItemStack stack) {
        return MTConfig.POWER_CONSOLIDATION_DURABILITY;
    }

    public static void addLightningBolt(ServerWorld world, MahouLightningBoltEntity entityIn) {
        world.field_217497_w.add(entityIn);
        world.func_73046_m().func_184103_al().func_148543_a((PlayerEntity)null, entityIn.func_226277_ct_(), entityIn.func_226278_cu_(), entityIn.func_226281_cx_(), 512.0, world.field_73011_w.func_186058_p(), entityIn.func_213297_N());
    }

    public static void zap(LivingEntity e, boolean ignoreZapped, PlayerEntity caster) {
        if (e != null && !e.field_70170_p.field_72995_K) {
            int radius = 4;
            AxisAlignedBB aabb = new AxisAlignedBB(e.func_226277_ct_() - (double)radius, e.func_226278_cu_() - (double)radius, e.func_226281_cx_() - (double)radius, e.func_226277_ct_() + (double)radius, e.func_226278_cu_() + (double)radius, e.func_226281_cx_() + (double)radius);
            List lst = e.field_70170_p.func_217357_a(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (EffectUtil.hasBuff(target, ModEffects.ZAP_COOLDOWN) && !ignoreZapped || target.func_184614_ca().func_77973_b() == ModItems.emrysStaff || target.func_184592_cb().func_77973_b() == ModItems.emrysStaff || caster == null || PlayerManaManager.drainMana(caster, MTConfig.EMRYS_MANA_COST_PASSIVE, false, false) != MTConfig.EMRYS_MANA_COST_PASSIVE) continue;
                target.field_70170_p.func_217376_c((Entity)new LightningEntity(e.field_70170_p, e, target, 1.0f, 1.0f, 1.0f, 1.0f, 0.01f, true));
            }
        }
    }

    public static void emrysHit(AttackEntityEvent event) {
        if (event.getEntityLiving().func_184592_cb().func_77973_b() == ModItems.emrysStaff && !event.getEntityLiving().field_70170_p.field_72995_K && event.getTarget() instanceof LivingEntity && event.getEntityLiving() instanceof PlayerEntity) {
            StaffEmrys.zap((LivingEntity)event.getTarget(), false, (PlayerEntity)event.getEntityLiving());
        }
    }

    public static void emrysLivingHurt(LivingHurtEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if ((event.getEntityLiving().func_184592_cb().func_77973_b() == ModItems.emrysStaff || event.getEntityLiving().func_184614_ca().func_77973_b() == ModItems.emrysStaff) && event.getSource() == DamageSource.field_180137_b) {
                event.setAmount(0.0f);
            }
            if (event.getSource().func_76346_g() instanceof PlayerEntity && ((LivingEntity)event.getSource().func_76346_g()).func_184592_cb().func_77973_b() == ModItems.emrysStaff) {
                StaffEmrys.zap(event.getEntityLiving(), false, (PlayerEntity)event.getSource().func_76346_g());
            }
        }
    }

    public int getRemainingUseDuration(ItemStack stack, int charge) {
        return this.func_77626_a(stack) - charge;
    }

    public static void emrysStruckByLightning(EntityStruckByLightningEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getEntity().field_70170_p.field_72995_K && !MTConfig.DISABLE_EMRYS && ((LivingEntity)event.getEntity()).func_184592_cb().func_77973_b() == Items.field_151055_y && StrengtheningSpellEffect.getStrengthened(((LivingEntity)event.getEntity()).func_184592_cb()) > 0) {
            ItemStack emrys = new ItemStack((IItemProvider)ModItems.emrysStaff);
            StaffEmrys.turnStickIntoItem((PlayerEntity)event.getEntity(), emrys);
        }
    }

    public static void turnStickIntoItem(PlayerEntity player, ItemStack change) {
        ItemStack stack;
        if (player.field_71071_by.field_184439_c.size() > 0 && (stack = (ItemStack)player.field_71071_by.field_184439_c.get(0)).func_77973_b() == Items.field_151055_y && StrengtheningSpellEffect.getStrengthened(stack) > 0) {
            player.field_71071_by.field_184439_c.set(0, (Object)change);
            ModTriggers.EMRYS.trigger((ServerPlayerEntity)player);
        }
    }

    public class StaffEmrysUserStorage {
        public ArrayList<LightningEntity> lightnings = new ArrayList();
        public HashSet<UUID> connected = new HashSet();
    }
}

