/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.mysticcode;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SHeldItemChangePacket;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventory;
import stepsword.mahoutsukai.capability.containers.MysticCodeInventoryProvider;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.item.spells.SpellScroll;
import stepsword.mahoutsukai.item.spells.boundary.BoundarySpellScroll;
import stepsword.mahoutsukai.item.spells.secret.FallenDownSpellScroll;
import stepsword.mahoutsukai.item.spells.secret.GandrSpellScroll;
import stepsword.mahoutsukai.render.item.MysticCodeRenderer;
import stepsword.mahoutsukai.util.Utils;

public class MysticCode
extends ItemBase
implements INamedContainerProvider {
    public MysticCode(String name, Item.Properties prop) {
        super(name, prop);
        this.addPropertyOverrides();
    }

    public MysticCode() {
        super("mystic_code", new Item.Properties().func_200917_a(1).setISTER(() -> MysticCodeRenderer::new));
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof MysticCode) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("slot"), new IItemPropertyGetter(){

            public float call(ItemStack stack, World worldIn, LivingEntity entityIn) {
                return entityIn != null && stack.func_77973_b() instanceof MysticCode ? (float)MysticCode.getSlot(stack) : 0.0f;
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new MysticCodeInventoryProvider();
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BLOCK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (playerIn.func_226273_bm_()) {
            if (!worldIn.field_72995_K) {
                NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerIn), (INamedContainerProvider)this);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
        }
        playerIn.func_184598_c(handIn);
        return new ActionResult(ActionResultType.FAIL, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        ItemStack ammo;
        int slot;
        IItemHandler inventory;
        if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && (ammo = inventory.getStackInSlot(slot)).func_77973_b() instanceof SpellScroll) {
            ((SpellScroll)ammo.func_77973_b()).useAction(ammo, worldIn, entityLiving, true);
            if (!worldIn.field_72995_K) {
                this.saveCapabilityToStack(stack);
            }
        }
        if (!worldIn.field_72995_K) {
            MysticCode.triggerUpdate((ServerPlayerEntity)entityLiving, stack);
        }
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        ItemStack ammo;
        int slot;
        IItemHandler inventory;
        if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3 && ((ammo = inventory.getStackInSlot(slot)).func_77973_b() instanceof GandrSpellScroll || ammo.func_77973_b() instanceof FallenDownSpellScroll)) {
            ammo.func_77973_b().onUsingTick(ammo, player, count);
        }
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        if (player != null) {
            int slot;
            IItemHandler inventory;
            World worldIn = player.field_70170_p;
            Hand hand = ctx.func_221531_n();
            BlockPos pos = ctx.func_195995_a();
            Direction facing = ctx.func_196000_l();
            ItemStack stack = player.func_184586_b(hand);
            if (player.func_226273_bm_()) {
                if (!worldIn.field_72995_K) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)this);
                }
                return ActionResultType.SUCCESS;
            }
            if (stack != null && (inventory = Utils.getMCInventory(stack)) != null && (slot = MysticCode.getSlot(stack)) >= 0 && slot < 3) {
                ItemStack ammo = inventory.getStackInSlot(slot);
                if (ammo.func_77973_b() instanceof BoundarySpellScroll) {
                    ActionResultType s = ((BoundarySpellScroll)ammo.func_77973_b()).boundaryScrollUse(player, worldIn, ammo, pos, facing, true);
                    if (!worldIn.field_72995_K) {
                        this.saveCapabilityToStack(stack);
                    }
                    return s;
                }
                player.func_184598_c(hand);
            }
            if (!worldIn.field_72995_K) {
                MysticCode.triggerUpdate((ServerPlayerEntity)player, stack);
            }
            return ActionResultType.FAIL;
        }
        return ActionResultType.FAIL;
    }

    public static void setSlot(ItemStack stack, int g) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("slot_selected", g);
        stack.func_77982_d(nbt);
    }

    public static int getSlot(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("slot_selected")) {
            return nbt.func_74762_e("slot_selected");
        }
        return 0;
    }

    public void setRandomColor(ItemStack stack, Random rand) {
        this.setColor(stack, rand.nextInt(8));
    }

    public void setColor(ItemStack stack, int z) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a("color", z);
        stack.func_77982_d(nbt);
    }

    public int getColor(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt != null && nbt.func_74764_b("color")) {
            return nbt.func_74762_e("color");
        }
        return 0;
    }

    public void setSlotsForWheel(ItemStack code, ItemStack s1, ItemStack s2, ItemStack s3) {
        CompoundNBT nbt = code.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74778_a("slot1", MysticCode.convertStackToString(s1));
        nbt.func_74778_a("slot2", MysticCode.convertStackToString(s2));
        nbt.func_74778_a("slot3", MysticCode.convertStackToString(s3));
        code.func_77982_d(nbt);
    }

    public List<String> getSlotsForWheel(ItemStack code) {
        CompoundNBT nbt = code.func_77978_p();
        ArrayList<String> lst = new ArrayList<String>();
        if (nbt != null && nbt.func_74764_b("slot1")) {
            lst.add(nbt.func_74779_i("slot1"));
        } else {
            lst.add("SLOT EMPTY");
        }
        if (nbt != null && nbt.func_74764_b("slot2")) {
            lst.add(nbt.func_74779_i("slot2"));
        } else {
            lst.add("SLOT EMPTY");
        }
        if (nbt != null && nbt.func_74764_b("slot3")) {
            lst.add(nbt.func_74779_i("slot3"));
        } else {
            lst.add("SLOT EMPTY");
        }
        return lst;
    }

    public static String convertStackToString(ItemStack s) {
        if (s.func_190926_b()) {
            return "SLOT EMPTY";
        }
        return s.func_77973_b().func_200295_i(s).func_150261_e();
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT nbt) {
        CompoundNBT c;
        ItemStackHandler inv;
        if (nbt != null && nbt.func_74764_b("capability") && (inv = (ItemStackHandler)Utils.getMCInventory(stack)) != null && (c = (CompoundNBT)nbt.func_74781_a("capability")).func_74764_b("Items")) {
            ListNBT lst = c.func_150295_c("Items", 10);
            MysticCodeInventoryProvider.MYSTIC_CODE_INVENTORY.getStorage().readNBT(MysticCodeInventoryProvider.MYSTIC_CODE_INVENTORY, (Object)inv, null, (INBT)lst);
        }
        super.readShareTag(stack, nbt);
    }

    public void saveCapabilityToStack(ItemStack stack) {
        ItemStackHandler inventory;
        if (stack != null && !stack.func_190926_b() && stack.func_77973_b() instanceof MysticCode && (inventory = (ItemStackHandler)Utils.getMCInventory(stack)) != null) {
            CompoundNBT capnbt = inventory.serializeNBT();
            CompoundNBT stacknbt = stack.func_77978_p();
            if (stacknbt == null) {
                stacknbt = new CompoundNBT();
            }
            stacknbt.func_218657_a("capability", (INBT)capnbt);
            stack.func_77982_d(stacknbt);
            this.setSlotsForWheel(stack, inventory.getStackInSlot(0), inventory.getStackInSlot(1), inventory.getStackInSlot(2));
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }

    public static void triggerUpdate(ServerPlayerEntity player, ItemStack stack) {
        player.field_71135_a.func_147359_a((IPacket)new SHeldItemChangePacket(player.field_71071_by.field_70461_c));
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent("Mystic Code");
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        ItemStack stack = playerEntity.func_184614_ca().func_77973_b() instanceof MysticCode ? playerEntity.func_184614_ca() : playerEntity.func_184592_cb();
        return new MysticCodeInventory(i, (ItemStackHandler)Utils.getMCInventory(stack), (IInventory)playerInventory, stack);
    }
}

