/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.item.spells.projection.TreasuryProjection;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShearsItem;
import net.minecraft.item.ShieldItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.item.TridentItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.advancements.ModTriggers;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.effects.projection.ProjectionSpellEffect;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.item.ItemBase;
import stepsword.mahoutsukai.render.item.TreasuryProjectionGauntletRenderer;
import stepsword.mahoutsukai.sounds.ModSounds;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class TreasuryProjectionGauntlet
extends ItemBase {
    private String MODE_TAG = "MAHOUTSUKAI_TREASURY_MODE";

    public TreasuryProjectionGauntlet() {
        super("treasury_projection_gauntlet", new Item.Properties().setISTER(() -> TreasuryProjectionGauntletRenderer::new));
        this.addPropertyOverrides();
    }

    public void addPropertyOverrides() {
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                return !(entityIn.func_184607_cu().func_77973_b() instanceof TreasuryProjectionGauntlet) ? 0.0f : (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            public float call(ItemStack stack, @Nullable World worldIn, @Nullable LivingEntity entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_226273_bm_()) {
            if (!world.field_72995_K) {
                this.setMode(stack, (this.getMode(stack) + 1) % 3);
                int mode = this.getMode(stack);
                TranslationTextComponent tt = mode == 0 ? new TranslationTextComponent("mahoutsukai.treasurygauntlet.targeted", new Object[0]) : (mode == 1 ? new TranslationTextComponent("mahoutsukai.treasurygauntlet.chains", new Object[0]) : new TranslationTextComponent("mahoutsukai.treasurygauntlet.aoe", new Object[0]));
                player.func_146105_b((ITextComponent)tt, true);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public void setMode(ItemStack gauntlet, int mode) {
        CompoundNBT nbt = gauntlet.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74768_a(this.MODE_TAG, mode);
        gauntlet.func_77982_d(nbt);
    }

    public int getMode(ItemStack gauntlet) {
        CompoundNBT nbt = gauntlet.func_77978_p();
        if (nbt != null && nbt.func_74764_b(this.MODE_TAG)) {
            return nbt.func_74762_e(this.MODE_TAG);
        }
        return 0;
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        int mode = this.getMode(stack);
        if (player instanceof PlayerEntity && !player.field_70170_p.field_72995_K) {
            if (mode == 0) {
                int mana = MTConfig.TREASURY_PROJECTION_GAUNTLET_MANA_COST;
                int cooldown = MTConfig.TREASURY_PROJECTION_COOLDOWN;
                if (count % cooldown == cooldown / 2 && PlayerManaManager.drainMana((PlayerEntity)player, mana, false, false) == mana) {
                    Vec3d v = this.findSpotToCast(player.field_70170_p, player);
                    Random random = player.func_70681_au();
                    ArrayList<ItemStack> projectables = this.getProjectables((PlayerEntity)player);
                    if (projectables.size() > 0) {
                        ItemStack projectile = projectables.get(random.nextInt(projectables.size()));
                        TreasuryProjectionGauntlet.shootWeaponAt(projectile, player.field_70170_p, v, player, random);
                    }
                }
            } else if (mode == 1) {
                int mana = MTConfig.TREASURY_PROJECTION_CHAINS_MANA_COST;
                int cooldown = MTConfig.TREASURY_PROJECTION_CHAINS_COOLDOWN;
                int cnt = MTConfig.TREASURY_PROJECTION_CHAINS_COUNT;
                if (count % cooldown == cooldown / 2 && count < this.func_77626_a(stack)) {
                    if (this.func_77626_a(stack) - count <= cooldown) {
                        this.chains(player, true, cnt, mana);
                    } else if (count % 19 * cooldown == 0) {
                        this.chains(player, true, cnt, mana);
                    } else {
                        this.chains(player, false, 1, mana);
                    }
                }
            } else if (mode == 2) {
                ArrayList<ItemStack> projectables;
                int mana = MTConfig.TREASURY_PROJECTION_AOE_MANA_COST;
                int cooldown = MTConfig.TREASURY_PROJECTION_AOE_COOLDOWN;
                if (count % cooldown == cooldown / 2 && PlayerManaManager.drainMana((PlayerEntity)player, mana, false, false) == mana && (projectables = this.getProjectables((PlayerEntity)player)).size() > 0) {
                    ItemStack projectile = projectables.get(field_77697_d.nextInt(projectables.size()));
                    TreasuryProjectionGauntlet.behindShoot(projectile, player.field_70170_p, player, field_77697_d);
                }
            }
        }
        super.onUsingTick(stack, player, count);
    }

    protected boolean isArrow(ItemStack stack) {
        int i;
        boolean sword;
        Item tmpi = stack.func_77973_b();
        if (stack.func_190926_b()) {
            return false;
        }
        List<? extends String> white = MTConfig.TREASURY_PROJECTION_WHITELIST;
        List<? extends String> black = MTConfig.TREASURY_PROJECTION_BLACKLIST;
        boolean allow_all = MTConfig.TREASURY_PROJECTION_ALLOW_ALL;
        boolean deny_all = MTConfig.TREASURY_PROJECTION_DENY_ALL;
        boolean bl = sword = tmpi instanceof SwordItem || tmpi instanceof ToolItem || tmpi instanceof ShieldItem || tmpi instanceof ShearsItem || tmpi instanceof FishingRodItem || tmpi instanceof HoeItem || tmpi instanceof TridentItem || MahouTsukaiMod.jousting.treasuryProjection(tmpi);
        if (deny_all) {
            sword = false;
        }
        boolean inwhite = false;
        boolean inblack = false;
        for (i = 0; i < white.size(); ++i) {
            if (tmpi.getRegistryName() == null || !white.get(i).equals(tmpi.getRegistryName().toString())) continue;
            inwhite = true;
            break;
        }
        for (i = 0; i < black.size(); ++i) {
            if (tmpi.getRegistryName() == null || !black.get(i).equals(tmpi.getRegistryName().toString())) continue;
            inblack = true;
            break;
        }
        if (inblack) {
            return false;
        }
        return sword || inwhite || allow_all;
    }

    public UseAction func_77661_b(ItemStack p_77661_1_) {
        return UseAction.BLOCK;
    }

    public Vec3d findSpotToCast(World world, LivingEntity player) {
        Entity e = ProjectionSpellEffect.playerLook(player, MTConfig.GLOBAL_LOOK_RANGE, world, null);
        Vec3d v = e instanceof LivingEntity ? e.func_213303_ch() : this.getTargetBlock(player);
        return v;
    }

    public ArrayList<ItemStack> getProjectables(PlayerEntity player) {
        ItemStack stack2;
        int j;
        int z;
        IItemHandler inv;
        ItemStack stack1;
        int i;
        int size = player.field_71071_by.field_70462_a.size();
        ArrayList<ItemStack> projectables = new ArrayList<ItemStack>();
        for (i = 0; i < size; ++i) {
            stack1 = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (this.isArrow(stack1)) {
                projectables.add(stack1);
            }
            if ((inv = Utils.getInventory(stack1)) == null) continue;
            z = inv.getSlots();
            for (j = 0; j < z; ++j) {
                stack2 = inv.getStackInSlot(j);
                if (!this.isArrow(stack2)) continue;
                projectables.add(stack2);
            }
        }
        for (i = 0; i < player.func_71005_bN().func_70302_i_(); ++i) {
            stack1 = player.func_71005_bN().func_70301_a(i);
            if (this.isArrow(stack1)) {
                projectables.add(stack1);
            }
            if ((inv = Utils.getInventory(stack1)) == null) continue;
            z = inv.getSlots();
            for (j = 0; j < z; ++j) {
                stack2 = inv.getStackInSlot(j);
                if (!this.isArrow(stack2)) continue;
                projectables.add(stack2);
            }
        }
        return projectables;
    }

    public Vec3d getTargetBlock(LivingEntity player) {
        Vec3d target;
        RayTraceResult result = Utils.rayTraceEyes(player, MTConfig.GLOBAL_LOOK_RANGE);
        Entity e = ProjectionSpellEffect.playerLook(player, MTConfig.GLOBAL_LOOK_RANGE, player.field_70170_p, (Predicate<Entity>)((Predicate)a -> a instanceof LivingEntity));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK && e == null) {
            BlockRayTraceResult br = (BlockRayTraceResult)result;
            target = new Vec3d((double)br.func_216350_a().func_177958_n() + 0.5, (double)br.func_216350_a().func_177956_o(), (double)br.func_216350_a().func_177952_p() + 0.5).func_72441_c(0.0, 1.0, 0.0);
        } else if (e != null) {
            target = e.func_174824_e(1.0f);
        } else {
            Vec3d v = player.func_70676_i(0.0f);
            Vec3d v2 = new Vec3d(v.field_72450_a * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72448_b * (double)MTConfig.GLOBAL_LOOK_RANGE, v.field_72449_c * (double)MTConfig.GLOBAL_LOOK_RANGE);
            Vec3d v3 = player.func_174824_e(1.0f).func_178787_e(v2);
            while (Utils.isBlockAir(player.field_70170_p, new BlockPos(v3)) && v3.field_72448_b > 0.0) {
                v3 = v3.func_178787_e(new Vec3d(0.0, -1.0, 0.0));
            }
            target = v3;
        }
        return target;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public static void shootWeaponAt(ItemStack stack, World world, Vec3d pos, LivingEntity player, Random random) {
        GateWeaponProjectileEntity weapon;
        int d = MTConfig.TREASURY_PROJECTION_DISTANCE;
        int d2 = MTConfig.TREASURY_PROJECTION_MIN_DISTANCE;
        int tries = 0;
        do {
            ++tries;
            int circleDegrees = random.nextInt(360);
            int groundDegrees = random.nextInt(70) + 20;
            int distance = random.nextInt(d2) + (d - d2);
            double height = (double)distance * Math.cos(EffectUtil.toRad(groundDegrees));
            double radius = Math.sqrt((double)(distance * distance) - height * height);
            double zplus = radius * Math.sin(EffectUtil.toRad(circleDegrees));
            double xplus = -radius * Math.cos(EffectUtil.toRad(circleDegrees));
            weapon = new GateWeaponProjectileEntity(world, pos.field_72450_a + xplus, pos.field_72448_b + height, pos.field_72449_c + zplus, stack.func_77946_l(), (Entity)player);
            weapon.field_70125_A = groundDegrees;
            weapon.field_70177_z = circleDegrees - 90;
            Vec3d aim = weapon.func_213303_ch().func_178788_d(pos);
            weapon.func_70186_c(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c, 3.0f, 4.0f);
        } while (!world.func_175623_d(weapon.func_180425_c()) && tries < 20);
        world.func_217376_c((Entity)weapon);
        if (player instanceof ServerPlayerEntity) {
            ModTriggers.TREASURY_PROJECTION.trigger((ServerPlayerEntity)player);
        }
    }

    public static void behindShoot(ItemStack stack, World world, LivingEntity player, Random random) {
        GateWeaponProjectileEntity weapon;
        int tries = 0;
        do {
            Vec3d playerpos;
            ++tries;
            float scale = player.func_70681_au().nextFloat() * 4.0f + 3.0f;
            float height = player.func_70681_au().nextFloat() * 3.0f + 1.0f;
            Vec3d look = player.func_70040_Z();
            Vec3d playerperp = playerpos = player.func_213303_ch();
            playerperp = playerperp.func_178787_e(look.func_72432_b().func_186678_a(-3.0));
            playerperp = player.func_70681_au().nextBoolean() ? playerperp.func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)(player.field_70177_z + 90.0f)).func_72432_b().func_186678_a((double)player.func_70681_au().nextInt(4) - 0.3).func_186678_a(2.0)) : playerperp.func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)(player.field_70177_z - 90.0f)).func_72432_b().func_186678_a((double)player.func_70681_au().nextInt(4) - 0.3).func_186678_a(2.0));
            playerperp = playerperp.func_178787_e(Vec3d.func_189986_a((float)(player.field_70125_A - 90.0f), (float)player.field_70177_z).func_72432_b().func_186678_a((double)player.func_70681_au().nextInt(4) + 1.8).func_186678_a(2.0));
            weapon = new GateWeaponProjectileEntity(world, playerperp.field_72450_a, playerperp.field_72448_b, playerperp.field_72449_c, stack.func_77946_l(), (Entity)player);
            weapon.field_70125_A = player.field_70125_A;
            weapon.field_70177_z = player.field_70177_z;
            Vec3d pos = weapon.func_213303_ch().func_178787_e(player.func_70040_Z());
            Vec3d aim = weapon.func_213303_ch().func_178788_d(pos);
            weapon.func_70186_c(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c, 3.0f, 4.0f);
        } while (!world.func_175623_d(weapon.func_180425_c()) && tries < 20);
        world.func_217376_c((Entity)weapon);
        if (player instanceof ServerPlayerEntity) {
            ModTriggers.TREASURY_PROJECTION.trigger((ServerPlayerEntity)player);
        }
    }

    public void chains(LivingEntity player, boolean prison, int tospawn, int mana) {
        if (PlayerManaManager.drainMana((PlayerEntity)player, mana * tospawn, false, false) == mana * tospawn) {
            float w;
            float h;
            Vec3d v;
            Entity e = ProjectionSpellEffect.playerLook(player, MTConfig.GLOBAL_LOOK_RANGE, player.field_70170_p, (Predicate<Entity>)((Predicate)m -> m instanceof LivingEntity));
            boolean entity = false;
            if (e instanceof LivingEntity) {
                v = e.func_213303_ch();
                h = e.func_213302_cg() + 2.0f;
                w = e.func_213311_cf() + 1.5f;
                entity = true;
            } else {
                v = this.getTargetBlock(player);
                h = 5.0f;
                w = 3.0f;
            }
            if (prison) {
                int i;
                ArrayList<Integer> degreeList = new ArrayList<Integer>();
                for (i = 0; i < tospawn; ++i) {
                    int q = 360 / tospawn;
                    int init = q * i;
                    degreeList.add(init += player.func_70681_au().nextInt(q / 3) - q / 6);
                }
                for (i = 0; i < tospawn; ++i) {
                    Vec3d aimTo;
                    if (i >= degreeList.size()) continue;
                    int circleDegrees = (Integer)degreeList.get(i);
                    double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                    double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                    Vec3d chainpos = v.func_72441_c(0.0, (double)h, 0.0).func_178787_e(new Vec3d(xplus, 0.0, zplus));
                    BlockRayTraceResult raytrace = player.field_70170_p.func_217299_a(new RayTraceContext(chainpos, chainpos.func_178787_e(aimTo = v.func_178788_d(chainpos).func_72432_b().func_72441_c((double)(player.func_70681_au().nextFloat() * 2.0f - 1.0f), (double)player.func_70681_au().nextFloat() - 0.5, (double)(player.func_70681_au().nextFloat() * 2.0f - 1.0f)).func_72432_b().func_186678_a(40.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.SOURCE_ONLY, (Entity)player));
                    Vec3d pos = new Vec3d((Vec3i)raytrace.func_216350_a());
                    if (Utils.isBlockAir(player.field_70170_p, new BlockPos(pos))) continue;
                    GateChainEntity chain = new GateChainEntity(player.field_70170_p, 0.96f, 0.93f, 0.25f, 1.0f, chainpos, pos);
                    if (Math.random() < 0.2) {
                        player.field_70170_p.func_184133_a(null, chain.func_180425_c(), ModSounds.CHAINS, SoundCategory.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                    }
                    Vec3d aim = chain.func_213303_ch().func_178788_d(pos);
                    chain.shoot(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c);
                    chain.setCircleSize(1.0f);
                    player.field_70170_p.func_217376_c((Entity)chain);
                }
            } else if (entity) {
                int circleDegrees = field_77697_d.nextInt(360);
                double zplus = (double)w * Math.sin(EffectUtil.toRad(circleDegrees));
                double xplus = (double)(-w) * Math.cos(EffectUtil.toRad(circleDegrees));
                Vec3d chainpos = v.func_72441_c(0.0, (double)h, 0.0).func_178787_e(new Vec3d(xplus, 0.0, zplus));
                Vec3d pos = e.func_213303_ch();
                GateChainEntity chain = new GateChainEntity(player.field_70170_p, 0.96f, 0.93f, 0.25f, 1.0f, chainpos, pos);
                player.field_70170_p.func_184133_a(null, chain.func_180425_c(), ModSounds.CHAINS, SoundCategory.NEUTRAL, (float)MTConfig.CHAIN_VOLUME, 1.2f);
                Vec3d aim = chain.func_213303_ch().func_178788_d(pos);
                chain.shoot(-aim.field_72450_a, -aim.field_72448_b, -aim.field_72449_c);
                chain.setCircleSize(1.0f);
                player.field_70170_p.func_217376_c((Entity)chain);
            }
        }
    }
}

