/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.capability.caliburn.ICaliburnMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.item.morgan.Morgan;
import stepsword.mahoutsukai.item.spells.projection.PowerConsolidation.Caliburn;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RagePotion;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class ItemAbilityPacket {
    ABILITY ability;

    public ItemAbilityPacket() {
    }

    public ItemAbilityPacket(ABILITY a) {
        this.ability = a;
    }

    public void fromBytes(ByteBuf buf) {
        int n = buf.readInt();
        this.ability = n < ABILITY.values().length ? ABILITY.values()[n] : ABILITY.CALIBURN;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.ability.ordinal());
    }

    public static void encode(ItemAbilityPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ItemAbilityPacket decode(PacketBuffer buf) {
        ItemAbilityPacket msg = new ItemAbilityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(final ItemAbilityPacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                if (message.ability == ABILITY.CALIBURN) {
                    ItemAbilityPacket.handleAbilityCaliburn(((NetworkEvent.Context)context.get()).getSender());
                } else if (message.ability == ABILITY.MORGAN) {
                    ItemAbilityPacket.handleAbilityMorgan(((NetworkEvent.Context)context.get()).getSender());
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void handleAbilityCaliburn(ServerPlayerEntity player) {
        ICaliburnMahou mahou;
        int radius = MTConfig.POWER_CONSOLIDATION_SMITE_RADIUS;
        AxisAlignedBB aabb = new AxisAlignedBB(player.func_180425_c().func_177982_a(-radius, -4, -radius), player.func_180425_c().func_177982_a(radius, 4, radius));
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof Caliburn && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN) && PlayerManaManager.drainMana((PlayerEntity)player, MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST, false, false) == MTConfig.CALIBURN_MORGAN_ABILITY_MANA_COST && (mahou = Utils.getCaliburnMahou(stack)) != null) {
            int targets = 0;
            List lst = player.field_70170_p.func_217357_a(LivingEntity.class, aabb);
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !Caliburn.specialTarget(target)) continue;
                ++targets;
            }
            for (LivingEntity target : lst) {
                if (target.func_110124_au().equals(player.func_110124_au()) || !Caliburn.specialTarget(target)) continue;
                SmiteEntity smite = new SmiteEntity(target.field_70170_p, target, 0.9019608f, 0.9019608f, 0.16470589f, 1.0f, 0.1f, mahou.getAttackDamage() / (float)targets);
                smite.func_70107_b(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                target.field_70170_p.func_217376_c((Entity)smite);
            }
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static void handleAbilityMorgan(ServerPlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof Morgan && !EffectUtil.hasBuff((LivingEntity)player, ModEffects.CM_COOLDOWN)) {
            EffectUtil.buff((LivingEntity)player, ModEffects.RAGE, false, MTConfig.MORGAN_RAGE_TIME);
            RagePotion.notifyIfRage((LivingEntity)player);
            EffectUtil.buff((LivingEntity)player, ModEffects.CM_COOLDOWN, false, MTConfig.MORGAN_CALIBURN_POWER_COOLDOWN);
        }
    }

    public static enum ABILITY {
        MORGAN,
        CALIBURN;

    }
}

