/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;

public class RipperUseEntityPacket {
    Hand hand = Hand.MAIN_HAND;
    int id = 0;

    public RipperUseEntityPacket() {
    }

    public RipperUseEntityPacket(Hand h, int i) {
        this.hand = h;
        this.id = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        int h = buf.readInt();
        this.hand = h >= 0 && h < Hand.values().length ? Hand.values()[h] : Hand.MAIN_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.hand.ordinal());
    }

    public static void encode(RipperUseEntityPacket msg, PacketBuffer buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static RipperUseEntityPacket decode(PacketBuffer buf) {
        RipperUseEntityPacket msg = new RipperUseEntityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(RipperUseEntityPacket message, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        if (player != null) {
            ServerWorld serverworld = (ServerWorld)player.field_70170_p;
            Entity entity = serverworld.func_73045_a(message.id);
            player.func_143004_u();
            if (entity != null) {
                boolean flag = player.func_70685_l(entity);
                double d0 = 36.0;
                if (!flag) {
                    d0 = 9.0;
                }
                if (player.func_70068_e(entity) < d0) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrbEntity || entity instanceof AbstractArrowEntity || entity == player) {
                        return;
                    }
                    TheRipper.attackTargetEntityWithCurrentItem(entity, (PlayerEntity)player, message.hand);
                }
            }
        }
        context.get().setPacketHandled(true);
    }
}

