/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.potion;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import stepsword.mahoutsukai.networking.PacketHandler;
import stepsword.mahoutsukai.networking.RipperInvisiblePacket;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.potion.RipperInvisCooldownPotion;
import stepsword.mahoutsukai.util.EffectUtil;

public class RipperInvisPotion
extends Effect {
    protected RipperInvisPotion() {
        super(EffectType.NEUTRAL, ModEffects.getColorNumber(252, 45, 45));
    }

    public boolean shouldRender(EffectInstance effect) {
        return false;
    }

    public boolean shouldRenderHUD(EffectInstance effect) {
        return false;
    }

    public void func_111187_a(LivingEntity livingEntity, AbstractAttributeMap p_111187_2_, int p_111187_3_) {
        RipperInvisPotion.notifyNotInvisible(livingEntity);
        EffectUtil.debuff(livingEntity, Effects.field_76441_p);
    }

    public void func_111185_a(LivingEntity livingEntity, AbstractAttributeMap p_111185_2_, int p_111185_3_) {
        RipperInvisPotion.notifyIfInvisible(livingEntity);
        EffectUtil.buff(livingEntity, Effects.field_76441_p, false, 2000000000, false);
    }

    public static void notifyIfInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisPotion.notifyTracking(lst, true, e.field_70170_p);
        }
    }

    public static void notifyNotInvisible(LivingEntity e) {
        ArrayList<LivingEntity> lst = new ArrayList<LivingEntity>();
        lst.add(e);
        RipperInvisPotion.notifyTracking(lst, false, e.field_70170_p);
    }

    public static void notifyTracking(ArrayList<LivingEntity> entities, boolean r, World world) {
        if (world instanceof ServerWorld) {
            for (LivingEntity e : entities) {
                PacketHandler.sendTracking((Entity)e, new RipperInvisiblePacket(e.func_145782_y(), r));
            }
        }
    }

    public static void presenceConcealmentLivingTick(LivingEntity e) {
        if (EffectUtil.hasBuff(e, ModEffects.RIPPER_INVISIBILITY)) {
            RipperInvisCooldownPotion.nudge(e);
        }
    }
}

