/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.proxy;

import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import stepsword.mahoutsukai.MahouTsukaiMod;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.client.ClientHandler;
import stepsword.mahoutsukai.item.guide.ContentsPage;
import stepsword.mahoutsukai.item.guide.GuidebookInstance;
import stepsword.mahoutsukai.proxy.CommonProxy;
import stepsword.mahoutsukai.render.gui.MahoujinProjectorScreen;
import stepsword.mahoutsukai.render.gui.WheelGui;
import stepsword.mahoutsukai.render.gui.guide.ContentsPageGui;
import stepsword.mahoutsukai.render.particle.FogParticleType;
import stepsword.mahoutsukai.render.particle.LightningParticleType;
import stepsword.mahoutsukai.render.particle.MagicParticleType;
import stepsword.mahoutsukai.render.particle.ModParticles;
import stepsword.mahoutsukai.render.particle.PetalParticleType;
import stepsword.mahoutsukai.render.shader.ShaderHelper;
import stepsword.mahoutsukai.tile.displacement.ScryingMahoujinTileEntity;
import stepsword.mahoutsukai.util.Utils;

public class ClientProxy
extends CommonProxy {
    boolean sensechanged = false;
    double oldsense;
    static Field entities;
    static Field particles;

    @Override
    public void openProjectorGUI(World w, BlockPos p) {
        Minecraft.func_71410_x().func_147108_a((Screen)new MahoujinProjectorScreen(w, p));
    }

    @Override
    public void openWheelGUI(World w, ItemStack s) {
        Minecraft.func_71410_x().func_147108_a((Screen)new WheelGui(w, s));
    }

    @Override
    public void init() {
        ShaderHelper.initShaders();
        ClientHandler client = new ClientHandler();
        MinecraftForge.EVENT_BUS.register((Object)client);
        MahouTsukaiMod.MOD_EVENT_BUS.register((Object)client);
        super.init();
    }

    @Override
    public boolean handleMaterialAcceleration(Entity entityIn) {
        return false;
    }

    @Override
    public PlayerEntity getPlayerForScry(World world, String viewTarget, CompoundNBT scryNBT, UUID uuid) {
        PlayerEntity playertarget = ScryingMahoujinTileEntity.getPlayerByName(viewTarget, world);
        if (playertarget == null && uuid != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, new GameProfile(uuid, viewTarget));
            try {
                player.func_70020_e(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        if (playertarget != null && scryNBT != null) {
            RemoteClientPlayerEntity player = new RemoteClientPlayerEntity((ClientWorld)world, playertarget.func_146103_bH());
            try {
                player.func_70020_e(scryNBT);
            }
            catch (Exception e) {
                System.err.println("Mahou Tsukai: Could not read player NBT:" + e.toString());
            }
            return player;
        }
        return null;
    }

    @Override
    public void revertPlayer() {
        super.revertPlayer();
    }

    public static HashSet<Entity> getAllEntities(ClientWorld world) {
        if (world.field_217429_b != null) {
            return new HashSet<Entity>((Collection<Entity>)world.field_217429_b.values());
        }
        return new HashSet<Entity>();
    }

    public static HashSet<Particle> getNoRenderParticles(ParticleManager manager) {
        Queue q = (Queue)manager.field_78876_b.get(IParticleRenderType.field_217606_f);
        if (q != null) {
            return new HashSet<Particle>(q);
        }
        return new HashSet<Particle>();
    }

    @Override
    public void openGuideGUI(GuidebookInstance book, PlayerEntity playerIn) {
        if (book.getPage() instanceof ContentsPage) {
            Minecraft.func_71410_x().func_147108_a((Screen)new ContentsPageGui(book, (ContentsPage)book.getPage()));
        }
    }

    @Override
    public void slowDown() {
        if (!this.sensechanged) {
            this.oldsense = Minecraft.func_71410_x().field_71474_y.field_74341_c;
            Minecraft.func_71410_x().field_71474_y.field_74341_c *= (double)0.34f;
            this.sensechanged = true;
        }
    }

    @Override
    public void speedUp() {
        if (this.sensechanged) {
            Minecraft.func_71410_x().field_71474_y.field_74341_c = this.oldsense;
            this.sensechanged = false;
        }
    }

    @Override
    public boolean isMahouTsukai() {
        IMahou mahou = Utils.getPlayerMahou((LivingEntity)Minecraft.func_71410_x().field_71439_g);
        if (mahou != null) {
            return mahou.hasMagic();
        }
        return false;
    }

    @Override
    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity(null, (SoundEvent)soundIn, (SoundCategory)category, (float)volume, (float)pitch);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        soundIn = event.getSound();
        category = event.getCategory();
        volume = event.getVolume();
        this.playSound(x, y, z, soundIn, category, volume, pitch, false);
    }

    public void playSound(double x, double y, double z, SoundEvent soundIn, SoundCategory category, float volume, float pitch, boolean distanceDelay) {
        double d0 = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c().func_186679_c(x, y, z);
        SimpleSound simplesound = new SimpleSound(soundIn, category, volume, pitch, (float)x, (float)y, (float)z);
        if (distanceDelay && d0 > 100.0) {
            double d1 = Math.sqrt(d0) / 40.0;
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)simplesound, (int)(d1 * 20.0));
        } else {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)simplesound);
        }
    }

    @Override
    public void registerFactories() {
        Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)ModParticles.PETAL, PetalParticleType.PetalFactory::new);
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_LIGHTNING, (IParticleFactory)new LightningParticleType.LightningFactory(new Color(255, 0, 0, 255), new Color(255, 120, 120)));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.YELLOW_LIGHTNING, (IParticleFactory)new LightningParticleType.LightningFactory(new Color(255, 255, 0, 255), new Color(255, 255, 70)));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.FOG1, (IParticleFactory)new FogParticleType.FogFactory(new ResourceLocation("mahoutsukai", "textures/particle/fog3.png")));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 1.0f, 0.0f, 0.0f, 1.0f));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.YELLOW_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.6f, 1.0f, 1.0f, 0.2f, 0.9f));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.BLACK_MAGIC, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 0.2f, 0.0f, 0.0f, 0.0f, 1.0f));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.RED_MAGIC_BIG, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 1.0f, 0.0f, 0.0f, 0.0f));
        Minecraft.func_71410_x().field_71452_i.func_199283_a((ParticleType)ModParticles.BLACK_MAGIC_BIG, (IParticleFactory)new MagicParticleType.MagicParticleFactory("textures/particle/white_magic_particle", 1.2f, 0.0f, 0.0f, 0.0f, 1.0f));
    }

    @Override
    public boolean isMe(LivingEntity player) {
        return player == Minecraft.func_71410_x().field_71439_g && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0;
    }

    @Override
    public void smiteParticles(double x, double y, double z, Random rand, boolean boom) {
        block4: {
            BasicParticleType p = ModParticles.YELLOW_MAGIC;
            double range = 0.0;
            if (Minecraft.func_71410_x().field_71441_e == null) break block4;
            if (!boom) {
                for (int i = 0; i < 6; ++i) {
                    double xoff = (rand.nextDouble() - 0.5) * range;
                    double yoff = (rand.nextDouble() - 0.5) * 1.2;
                    double zoff = (rand.nextDouble() - 0.5) * range;
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)p, x + xoff, y + (double)i * 0.16, z + zoff, 0.0, 0.0, 0.0);
                }
            } else {
                for (int i = 0; i < 30; ++i) {
                    double xoff = 0.0;
                    double yoff = 0.0;
                    double zoff = 0.0;
                    Vec3d vec = new Vec3d(rand.nextDouble() - 0.5, 0.0, rand.nextDouble() - 0.5).func_72432_b();
                    Minecraft.func_71410_x().field_71441_e.func_195594_a((IParticleData)p, x, y, z, vec.field_72450_a, 0.0, vec.field_72449_c);
                }
            }
        }
    }
}

