/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.ForgeHooksClient;
import stepsword.mahoutsukai.entity.GateChainEntity;
import stepsword.mahoutsukai.entity.LightningEntity;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.entity.RhongomyniadEntity;
import stepsword.mahoutsukai.entity.SmiteEntity;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownBeamEntity;
import stepsword.mahoutsukai.entity.mahoujin.FallenDownEntity;
import stepsword.mahoutsukai.entity.mahoujin.GandrEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.potion.ModEffects;
import stepsword.mahoutsukai.proxy.ClientProxy;
import stepsword.mahoutsukai.render.ClipWrappedRenderLayer;
import stepsword.mahoutsukai.render.ClippedRenderTypeBuffer;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.FogRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.entity.RenderFaeEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownBeamEntity;
import stepsword.mahoutsukai.render.entity.RenderFallenDownEntity;
import stepsword.mahoutsukai.render.entity.RenderGandrEntity;
import stepsword.mahoutsukai.render.entity.RenderGateChainEntity;
import stepsword.mahoutsukai.render.entity.RenderLightningEntity;
import stepsword.mahoutsukai.render.entity.RenderMorganBallEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderMysticStaffMahoujinEntity;
import stepsword.mahoutsukai.render.entity.RenderRhongomyniadEntity;
import stepsword.mahoutsukai.render.entity.RenderSmiteEntity;
import stepsword.mahoutsukai.render.particle.ParticleFog;
import stepsword.mahoutsukai.render.particle.ParticleLightning;
import stepsword.mahoutsukai.render.particle.ParticleMagic;
import stepsword.mahoutsukai.render.shader.FogShader;
import stepsword.mahoutsukai.util.EffectUtil;

public class RenderUtils {
    public static final ResourceLocation mahoujin = new ResourceLocation("mahoutsukai:textures/block/mahoujin_casting.png");
    public static final ResourceLocation runes = new ResourceLocation("mahoutsukai:textures/block/runes.png");
    public static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    public static int rune_index = 0;

    public static int getRuneIndex() {
        ++rune_index;
        return rune_index %= 2000000000;
    }

    public static void rotateQ(float w, float x, float y, float z, MatrixStack matrix) {
        matrix.func_227863_a_(new Quaternion(new Vector3f(x, y, z), w, true));
    }

    public static RenderType renderRing(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createRunesRenderType(runes, rune_index %= 2000000000);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRingCull(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index) {
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(runes, ring_index));
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderRing(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, int ring_index, ResourceLocation loc) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createRunesRenderType(loc, rune_index %= 2000000000);
        return RenderUtils.renderRing(matrix, buffer, cy, flatness, radius, height, num_segments, lx, ly, r, g, b, a, type);
    }

    public static RenderType renderSphere(MatrixStack matrix, IRenderTypeBuffer buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a) {
        ++rune_index;
        RenderType type = MahoujinRenderType.createSphereRenderType(beam, rune_index %= 2000000000);
        RenderUtils.renderSphere(matrix, buf, radius, gradation, lx, ly, r, g, b, a, type);
        return type;
    }

    public static RenderType renderRing(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IVertexBuilder bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = 0.0f;
        for (int i = 0; i < num_segments + 1; ++i) {
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = (double)(-radius) * Math.sin(tt);
            y = cy;
            z = (double)radius * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = cy - q;
            zb = p * Math.cos(tt);
            bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_181675_d();
            bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        }
        matrix.func_227865_b_();
        return type;
    }

    public static void translateBasic(double x, double y, double z) {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d basic = renderInfo.func_216785_c();
        GlStateManager.func_227689_c_((float)renderInfo.func_216777_e(), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_227689_c_((float)(renderInfo.func_216778_f() + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_227670_b_((double)(x - basic.field_72450_a), (double)(y - basic.field_72448_b), (double)(z - basic.field_72449_c));
    }

    public static void fixTranslucent() {
        ActiveRenderInfo renderInfo = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        Vec3d basic = renderInfo.func_216785_c();
        Tessellator.func_178181_a().func_178180_c().func_181674_a((float)basic.field_72450_a, (float)basic.field_72448_b, (float)basic.field_72449_c);
    }

    public static void bindTexture(ResourceLocation r) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(r);
    }

    public static void renderClippedItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn, float progress, double x, double y, double z, double yaw, double pitch, boolean clip) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag1;
            matrixStackIn.func_227860_a_();
            boolean flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI;
            boolean bl = flag1 = flag || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag1) {
                modelIn = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag1)) {
                RenderType rendertype = RenderTypeLookup.func_228389_a_((ItemStack)itemStackIn);
                RenderType rendertype1 = flag && Objects.equals(rendertype, Atlases.func_228784_i_()) ? Atlases.func_228785_j_() : rendertype;
                rendertype1 = new ClipWrappedRenderLayer(clip, pitch, yaw, x, y, z, progress, rendertype1);
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(rendertype1);
                RenderUtils.renderModel(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_228364_a_(itemStackIn, matrixStackIn, (IRenderTypeBuffer)new ClippedRenderTypeBuffer(bufferIn, clip, pitch, yaw, x, y, z, progress), combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    private static void renderModel(IBakedModel modelIn, ItemStack stack, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IVertexBuilder bufferIn) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, direction, random), stack, combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        Minecraft.func_71410_x().func_175599_af().func_229112_a_(matrixStackIn, bufferIn, modelIn.func_200117_a((BlockState)null, (Direction)null, random), stack, combinedLightIn, combinedOverlayIn);
    }

    public static IVertexBuilder getBuffer(IRenderTypeBuffer bufferIn, RenderType renderTypeIn, boolean isItemIn, boolean glintIn) {
        return glintIn ? VertexBuilderUtils.func_227915_a_((IVertexBuilder)bufferIn.getBuffer(isItemIn ? RenderType.func_228653_j_() : RenderType.func_228655_k_()), (IVertexBuilder)bufferIn.getBuffer(renderTypeIn)) : bufferIn.getBuffer(renderTypeIn);
    }

    public static void render(ItemStack stack, boolean m) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new CompoundNBT();
        }
        nbt.func_74757_a("render", m);
    }

    public static boolean shouldRender(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        if (nbt == null) {
            return true;
        }
        if (stack.func_77978_p().func_74764_b("render")) {
            return stack.func_77978_p().func_74767_n("render");
        }
        return true;
    }

    public static Vec3d vecFromPitchYaw(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static void renderFSQ(MatrixStack stack, ResourceLocation texture, float r1, float g1, float b1, float a1, float xoffset, float yoffset, float x, float y, float z) {
        float r = r1 / 255.0f;
        float g = g1 / 255.0f;
        float b = b1 / 255.0f;
        float a = a1;
        Matrix4f m = stack.func_227866_c_().func_227870_a_();
        Entity e = Minecraft.func_71410_x().func_175606_aa();
        if (e != null) {
            int j = 240;
            int k = 240;
            IRenderTypeBuffer.Impl buffer = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            RenderType type = MahoujinRenderType.createMahoujinRenderType(texture, 0, false);
            IVertexBuilder bb = Minecraft.func_71410_x().func_228019_au_().func_228487_b_().getBuffer(type);
            bb.func_227888_a_(m, 0.0f + xoffset, 0.0f + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, 0.0f + xoffset, y + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, x + xoffset, y + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(j, k).func_181675_d();
            bb.func_227888_a_(m, x + xoffset, 0.0f + yoffset, z).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 0.0f).func_225587_b_(j, k).func_181675_d();
            buffer.func_228462_a_(type);
        }
    }

    public static void renderTextureOverlay(MatrixStack matrix, String loc, int r, int g, int b, float a, float xoffset, float yoffset, float x, float y, float z) {
        ResourceLocation rl = new ResourceLocation(loc);
        RenderUtils.renderFSQ(matrix, rl, r, g, b, a, xoffset, yoffset, x, y, z);
    }

    public static float calculateOverlayFade(int duration, int interval, int fadeTicks, float maxAlpha) {
        int large = duration % interval;
        float alpha = 0.0f;
        if (large > interval - fadeTicks) {
            alpha = ((float)large - ((float)interval - (float)fadeTicks)) / (float)fadeTicks;
            alpha *= maxAlpha;
        }
        return alpha;
    }

    public static void renderSphere(MatrixStack matrix, IRenderTypeBuffer buf, float radius, int gradation, int lx, int ly, float r, float g, float b, float a, RenderType type) {
        float PI = 3.141592f;
        IVertexBuilder bb = buf.getBuffer(type);
        Matrix4f m = matrix.func_227866_c_().func_227870_a_();
        for (float alpha = 0.0f; alpha < 3.141592f; alpha += 3.141592f / (float)gradation) {
            float beta = 0.0f;
            while ((double)beta < 6.31459997177124) {
                float x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha));
                float y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha));
                float z = (float)((double)radius * Math.cos(alpha));
                bb.func_227888_a_(m, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
                x = (float)((double)radius * Math.cos(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                y = (float)((double)radius * Math.sin(beta) * Math.sin(alpha + 3.141592f / (float)gradation));
                z = (float)((double)radius * Math.cos(alpha + 3.141592f / (float)gradation));
                bb.func_227888_a_(m, x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
                beta += 3.141592f / (float)gradation;
            }
        }
    }

    public static void entityRenders(Entity re, MatrixStack matrix, float partialTicks) {
        boolean hasEyes = false;
        if (re instanceof LivingEntity && EffectUtil.hasBuff((LivingEntity)re, ModEffects.FAY_SIGHT_EYES)) {
            hasEyes = true;
        }
        Vec3d proj = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double d3 = proj.field_72450_a;
        double d4 = proj.field_72448_b;
        double d5 = proj.field_72449_c;
        HashSet<Entity> entities = ClientProxy.getAllEntities(Minecraft.func_71410_x().field_71441_e);
        if (entities != null && entities.size() > 0) {
            for (Entity entity : entities) {
                float m;
                double d2;
                double d1;
                double d0;
                if (entity instanceof FaeEntity && entity.func_70068_e(re) < 3600.0 && (hasEyes || EffectUtil.hasBuff((LivingEntity)((FaeEntity)entity), ModEffects.REVERTED))) {
                    double d02 = entity.field_70142_S + (entity.func_226277_ct_() - entity.field_70142_S) * (double)partialTicks;
                    double d12 = entity.field_70137_T + (entity.func_226278_cu_() - entity.field_70137_T) * (double)partialTicks;
                    double d22 = entity.field_70136_U + (entity.func_226281_cx_() - entity.field_70136_U) * (double)partialTicks;
                    float m2 = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
                    matrix.func_227860_a_();
                    RenderFaeEntity.render((FaeEntity)entity, d02 - d3, d12 - d4, d22 - d5, matrix, partialTicks);
                    matrix.func_227865_b_();
                }
                if (entity instanceof MysticStaffMahoujinEntity && entity.func_70068_e(re) < 16384.0) {
                    MysticStaffMahoujinEntity beam = (MysticStaffMahoujinEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderMysticStaffMahoujinEntity.renderCircle((MysticStaffMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MysticStaffBeamMahoujinEntity && entity.func_70068_e(re) < 16384.0) {
                    MysticStaffBeamMahoujinEntity beam = (MysticStaffBeamMahoujinEntity)entity;
                    d0 = beam.prevx + (beam.func_226277_ct_() - beam.prevx) * (double)partialTicks;
                    d1 = beam.prevy + (beam.func_226278_cu_() - beam.prevy) * (double)partialTicks;
                    d2 = beam.prevz + (beam.func_226281_cx_() - beam.prevz) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderMysticStaffBeamMahoujinEntity.renderBeam((MysticStaffBeamMahoujinEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof SmiteEntity && entity.func_70068_e(re) < 16384.0) {
                    SmiteEntity beam = (SmiteEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderSmiteEntity.renderSmite((SmiteEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof MorganBallEntity && entity.func_70068_e(re) < 16384.0) {
                    MorganBallEntity beam = (MorganBallEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderMorganBallEntity.renderMorganBall((MorganBallEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GandrEntity && entity.func_70068_e(re) < 4096.0) {
                    GandrEntity beam = (GandrEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderGandrEntity.renderGandr((GandrEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownEntity && entity.func_70068_e(re) < 16384.0) {
                    FallenDownEntity beam = (FallenDownEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderFallenDownEntity.renderFallenDown((FallenDownEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof FallenDownBeamEntity && entity.func_70068_e(re) < 16384.0) {
                    FallenDownBeamEntity beam = (FallenDownBeamEntity)entity;
                    d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                    d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                    d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderFallenDownBeamEntity.renderFallenDownBeam((FallenDownBeamEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof LightningEntity && entity.func_70068_e(re) < 16384.0) {
                    LightningEntity beam = (LightningEntity)entity;
                    d0 = beam.prev_x + (beam.func_226277_ct_() - beam.prev_x) * (double)partialTicks;
                    d1 = beam.prev_y + (beam.func_226278_cu_() - beam.prev_y) * (double)partialTicks;
                    d2 = beam.prev_z + (beam.func_226281_cx_() - beam.prev_z) * (double)partialTicks;
                    m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                    RenderLightningEntity.renderLightning((LightningEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (entity instanceof GateChainEntity && entity.func_70068_e(re) < 16384.0) {
                    GateChainEntity chain = (GateChainEntity)entity;
                    d0 = chain.field_70169_q + (chain.func_226277_ct_() - chain.field_70169_q) * (double)partialTicks;
                    d1 = chain.field_70167_r + (chain.func_226278_cu_() - chain.field_70167_r) * (double)partialTicks;
                    d2 = chain.field_70166_s + (chain.func_226281_cx_() - chain.field_70166_s) * (double)partialTicks;
                    m = chain.field_70126_B + (chain.field_70177_z - chain.field_70126_B) * partialTicks;
                    RenderGateChainEntity.renderCircle((GateChainEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
                }
                if (!(entity instanceof RhongomyniadEntity) || !(entity.func_70068_e(re) < 16384.0)) continue;
                RhongomyniadEntity beam = (RhongomyniadEntity)entity;
                d0 = beam.field_70169_q + (beam.func_226277_ct_() - beam.field_70169_q) * (double)partialTicks;
                d1 = beam.field_70167_r + (beam.func_226278_cu_() - beam.field_70167_r) * (double)partialTicks;
                d2 = beam.field_70166_s + (beam.func_226281_cx_() - beam.field_70166_s) * (double)partialTicks;
                m = beam.field_70126_B + (beam.field_70177_z - beam.field_70126_B) * partialTicks;
                RenderRhongomyniadEntity.renderRhongomyniad((RhongomyniadEntity)entity, d0 - d3, d1 - d4, d2 - d5, matrix, partialTicks);
            }
        }
    }

    public static void particleRenders(Entity re, MatrixStack matrix, float partialTicks) {
        Vec3d proj = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        double d3 = proj.field_72450_a;
        double d4 = proj.field_72448_b;
        double d5 = proj.field_72449_c;
        HashSet<Particle> particles = ClientProxy.getNoRenderParticles(Minecraft.func_71410_x().field_71452_i);
        ArrayList<Particle> orderedFog = new ArrayList<Particle>();
        if (particles != null && particles.size() > 0) {
            for (Particle particle : particles) {
                Particle p;
                if (particle instanceof ParticleLightning) {
                    p = (ParticleLightning)particle;
                    ParticleLightning.renderLightningParticle((ParticleLightning)p, d3, d4, d5, matrix, partialTicks);
                }
                if (particle instanceof ParticleFog) {
                    p = (ParticleFog)particle;
                    orderedFog.add(p);
                }
                if (!(particle instanceof ParticleMagic)) continue;
                p = (ParticleMagic)particle;
                ParticleMagic.renderMagic((ParticleMagic)p, d3, d4, d5, matrix, partialTicks);
            }
        }
        FogShader.doDepth = true;
        for (ParticleFog particleFog : orderedFog) {
            ParticleFog.renderFog(particleFog, d3, d4, d5, matrix, partialTicks);
        }
        if (FogRenderLayer.fbo != null) {
            // empty if block
        }
    }

    public static RenderType renderSpiral(MatrixStack matrix, IRenderTypeBuffer buffer, double cy, float flatness, float radius, float height, int num_segments, int lx, int ly, float r, float g, float b, float a, RenderType type, float lengthen, float innerradius, float texs) {
        matrix.func_227860_a_();
        Matrix4f positionMatrix = matrix.func_227866_c_().func_227870_a_();
        IVertexBuilder bb = buffer.getBuffer(type);
        double theta = 6.2831852 / (double)num_segments;
        double q = (double)height * Math.sin(EffectUtil.toRad(flatness));
        double h2 = height;
        double r2 = radius;
        double p = (double)radius + (double)height * Math.cos(EffectUtil.toRad(flatness));
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        double xb = 0.0;
        double yb = 0.0;
        double zb = 0.0;
        float squeeze = 3.0f;
        float texx = texs;
        double ygrow = cy;
        for (int i = 0; i < num_segments + 1; ++i) {
            r2 = innerradius + (radius - innerradius) * ((float)(num_segments - i) / (float)num_segments);
            h2 = height * ((float)(num_segments - i) / (float)num_segments);
            p = r2 + h2 * Math.cos(EffectUtil.toRad(flatness));
            q = h2 * Math.sin(EffectUtil.toRad(flatness));
            if ((texx += squeeze * 1.0f / (float)(num_segments + 1)) >= 1.0f) {
                texx = 0.0f;
                texx = squeeze * 1.0f / (float)(num_segments + 1);
                bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
                bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            }
            double tt = (double)i * theta;
            x = -r2 * Math.sin(tt);
            y = ygrow;
            z = r2 * Math.cos(tt);
            xb = -p * Math.sin(tt);
            yb = ygrow - q;
            zb = p * Math.cos(tt);
            bb.func_227888_a_(positionMatrix, (float)x, (float)y, (float)z).func_227885_a_(r, g, b, a).func_225583_a_(texx, 0.0f).func_225587_b_(lx, ly).func_181675_d();
            bb.func_227888_a_(positionMatrix, (float)xb, (float)yb, (float)zb).func_227885_a_(r, g, b, a).func_225583_a_(texx, 1.0f).func_225587_b_(lx, ly).func_181675_d();
            ygrow += (double)lengthen;
        }
        matrix.func_227865_b_();
        return type;
    }
}

