/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.util.ResourceLocation;
import stepsword.mahoutsukai.entity.MorganBallEntity;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class RenderMorganBallEntity
extends EntityRenderer<MorganBallEntity> {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");

    public RenderMorganBallEntity(EntityRendererManager renderManager) {
        super(renderManager);
    }

    public ResourceLocation getEntityTexture(MorganBallEntity entity) {
        return AtlasTexture.field_110575_b;
    }

    public void render(MorganBallEntity entity, float eyaw, float partialTicks, MatrixStack matrix, IRenderTypeBuffer buffer, int packedLight) {
    }

    public static void renderMorganBall(MorganBallEntity entity, double x, double y, double z, MatrixStack matrix, float partialTicks) {
        float spike_len = entity.prev_spike_len + (entity.getSpikeLength() - entity.prev_spike_len) * partialTicks;
        float sphere_size = entity.prev_sphere_size + (entity.getSphereSize() - entity.prev_sphere_size) * partialTicks;
        matrix.func_227860_a_();
        matrix.func_227861_a_(x, y, z);
        matrix.func_227862_a_(sphere_size, sphere_size, sphere_size);
        float[] colors = entity.getColor();
        float outeralpha = 0.06f;
        float beam_y_off = 0.0f;
        int lightmapX = 240;
        int lightmapY = 240;
        float r = colors[0];
        float g = colors[1];
        float b = colors[2];
        float a = colors[3];
        RenderMorganBallEntity.rotate(0.0f, 0.0f, 0.0f, matrix);
        matrix.func_227861_a_(0.0, (double)beam_y_off, 0.0);
        CullWrappedRenderLayer ringtype = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(RenderUtils.runes, 0));
        CullWrappedRenderLayer spheretype2 = new CullWrappedRenderLayer(MahoujinRenderType.createSphereRenderType(beam, 1));
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderUtils.renderSphere(matrix, (IRenderTypeBuffer)buf, sphere_size, 20, 240, 240, 0.0f, 0.0f, 0.0f, 1.0f, spheretype2);
        buf.func_228462_a_((RenderType)spheretype2);
        float unscalesphere = 1.0f / sphere_size;
        matrix.func_227862_a_(unscalesphere, unscalesphere, unscalesphere);
        float scalef = 1.2f;
        float unscalef = 1.0f / scalef;
        if (entity.yaws != null && entity.pitchs != null && entity.ds != null) {
            for (int i = 0; i < entity.yaws.size(); ++i) {
                if (i >= entity.pitchs.size() || i >= entity.ds.size()) continue;
                RenderUtils.rotateQ(entity.yaws.get(i).floatValue(), 0.0f, 1.0f, 0.0f, matrix);
                RenderUtils.rotateQ(entity.pitchs.get(i).floatValue(), 1.0f, 0.0f, 0.0f, matrix);
                matrix.func_227862_a_(0.2f, spike_len / 2.0f * entity.ds.get(i).floatValue(), 0.2f);
                matrix.func_227861_a_(0.0, 1.0, 0.0);
                matrix.func_227862_a_(unscalef, unscalef, unscalef);
                RenderMorganBallEntity.renderPyramid(matrix, buf, 0.0f, 0.0f, 0.0f, 1.0f, beam);
                matrix.func_227862_a_(scalef, scalef, scalef);
                RenderMorganBallEntity.renderPyramid(matrix, buf, r, g, b, 1.0f, RenderUtils.runes);
                matrix.func_227861_a_(0.0, -1.0, 0.0);
                matrix.func_227862_a_(5.0f, 2.0f / (spike_len * entity.ds.get(i).floatValue()), 5.0f);
                RenderUtils.rotateQ(-entity.pitchs.get(i).floatValue(), 1.0f, 0.0f, 0.0f, matrix);
                RenderUtils.rotateQ(-entity.yaws.get(i).floatValue(), 0.0f, 1.0f, 0.0f, matrix);
            }
        }
        float sz = 0.5f * sphere_size / entity.maxsize;
        float ht = 0.2f * sphere_size / entity.maxsize;
        float roll = Minecraft.func_71410_x().field_71441_e.func_82737_E();
        RenderUtils.rotateQ(80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, sphere_size + sz, ht, 32, 240, 240, r, g, b, 1.0f, ringtype);
        buf.func_228462_a_((RenderType)ringtype);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(80.0f, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, sphere_size + sz, ht, 32, 240, 240, r, g, b, 1.0f, ringtype);
        buf.func_228462_a_((RenderType)ringtype);
        RenderUtils.rotateQ(-roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(45.0f, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(-80.0f, 0.0f, 1.0f, 0.0f, matrix);
        matrix.func_227865_b_();
    }

    public static void renderPyramid(MatrixStack stack, IRenderTypeBuffer.Impl buf, float r, float g, float b, float a, ResourceLocation loc) {
        CullWrappedRenderLayer type = new CullWrappedRenderLayer(MahoujinRenderType.createTriangleRenderType(loc, 0));
        IVertexBuilder bb = buf.getBuffer((RenderType)type);
        Matrix4f m = stack.func_227866_c_().func_227870_a_();
        int lx = 240;
        int ly = 240;
        bb.func_227888_a_(m, 0.0f, 1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, -1.0f, -1.0f, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 1.0f, -1.0f, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 0.0f, 1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 1.0f, -1.0f, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 1.0f, -1.0f, -1.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 0.0f, 1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 1.0f, -1.0f, -1.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, -1.0f, -1.0f, -1.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, 0.0f, 1.0f, 0.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.0f, 0.0f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, -1.0f, -1.0f, -1.0f).func_227885_a_(r, g, b, a).func_225583_a_(0.5f, 0.5f).func_225587_b_(lx, ly).func_181675_d();
        bb.func_227888_a_(m, -1.0f, -1.0f, 1.0f).func_227885_a_(r, g, b, a).func_225583_a_(1.0f, 1.0f).func_225587_b_(lx, ly).func_181675_d();
        buf.func_228462_a_((RenderType)type);
    }

    public static void rotate(float yaw, float pitch, float roll, MatrixStack matrix) {
        RenderUtils.rotateQ(roll, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(pitch, 1.0f, 0.0f, 0.0f, matrix);
        RenderUtils.rotateQ(yaw, 0.0f, 1.0f, 0.0f, matrix);
    }
}

