/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.particle;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import stepsword.mahoutsukai.render.CullWrappedRenderLayer;
import stepsword.mahoutsukai.render.MahoujinRenderType;
import stepsword.mahoutsukai.render.RenderUtils;

public class ParticleLightning
extends Particle {
    private static final ResourceLocation beam = new ResourceLocation("mahoutsukai:textures/block/white.png");
    public Color color;
    public Color color2;
    public int[] branch = new int[3];
    public int[] angles;
    public int[] angles2;
    public float[] sizes;
    public float[] widths;
    public int fullrotate;
    public int yawrot;
    int life;

    protected ParticleLightning(World worldIn, Color c, Color c2, double xCoordIn, double yCoordIn, double zCoordIn, float scale, double motionX, double motionY, double motionZ) {
        super(worldIn, xCoordIn, yCoordIn, zCoordIn, 0.0, 0.0, 0.0);
        this.field_70553_i = 0.7137255f;
        this.field_70552_h = 1.0f;
        this.field_70551_j = 0.75686276f;
        float maxAge = 180.0f;
        this.field_70547_e = (int)((double)maxAge / (Math.random() * 0.3 + 0.6));
        this.field_70547_e = (int)((float)this.field_70547_e * scale);
        this.field_190015_G = this.field_190014_F = (float)worldIn.field_73012_v.nextInt(360) * 0.0174533f;
        this.color = c;
        this.color2 = c2;
        this.branch[0] = this.field_187136_p.nextInt(2) + 1;
        this.branch[1] = this.field_187136_p.nextInt(2) + 1;
        this.branch[2] = this.field_187136_p.nextInt(3) + 1;
        int r = this.branch.length;
        for (int j = 0; j < this.branch.length; ++j) {
            r *= this.branch[j];
        }
        this.angles = new int[r];
        this.angles2 = new int[r];
        this.sizes = new float[r];
        this.widths = new float[r];
        this.sizes[0] = 0.14f;
        this.widths[0] = 0.01f;
        for (int k = 0; k < r; ++k) {
            this.angles[k] = this.field_187136_p.nextInt(360);
            this.angles2[k] = this.field_187136_p.nextInt(50) + 20;
            if (k > 0) {
                this.sizes[k] = (0.7f + this.field_187136_p.nextFloat() * 0.2f) * this.sizes[k - 1];
            }
            if (k <= 0) continue;
            this.widths[k] = 1.0f * this.widths[k - 1];
        }
        this.life = this.field_187136_p.nextInt(1);
        this.fullrotate = this.field_187136_p.nextInt(20) + 80;
        this.fullrotate = this.field_187136_p.nextBoolean() ? -this.fullrotate : this.fullrotate;
        this.yawrot = (int)motionX;
    }

    public void func_189213_a() {
        ++this.field_70546_d;
        if (this.field_70546_d > this.life * this.branch.length + 3) {
            this.func_187112_i();
        }
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217606_f;
    }

    public void func_225606_a_(IVertexBuilder builder, ActiveRenderInfo activeRenderInfo, float partial) {
    }

    public static void renderLightningParticle(ParticleLightning particle, double d3, double d4, double d5, MatrixStack matrix, float partialTicks) {
        double d0 = particle.field_187123_c + (particle.field_187126_f - particle.field_187123_c) * (double)partialTicks;
        double d1 = particle.field_187124_d + (particle.field_187127_g - particle.field_187124_d) * (double)partialTicks;
        double d2 = particle.field_187125_e + (particle.field_187128_h - particle.field_187125_e) * (double)partialTicks;
        matrix.func_227860_a_();
        matrix.func_227861_a_(d0 - d3, d1 - d4, d2 - d5);
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        float w = particle.widths[0];
        float h = particle.sizes[0];
        RenderUtils.rotateQ(-particle.yawrot, 0.0f, 1.0f, 0.0f, matrix);
        RenderUtils.rotateQ(particle.fullrotate, 0.0f, 0.0f, 1.0f, matrix);
        IRenderTypeBuffer.Impl buf = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        CullWrappedRenderLayer ringType = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 0));
        CullWrappedRenderLayer ringType2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 1));
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
        buf.func_228462_a_((RenderType)ringType);
        ParticleLightning.recursiveLightning(matrix, buf, particle, 0, 0);
        RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
        buf.func_228462_a_((RenderType)ringType2);
        matrix.func_227865_b_();
    }

    public static int recursiveLightning(MatrixStack matrix, IRenderTypeBuffer.Impl buf, ParticleLightning particle, int branchindex, int oindex) {
        float r = (float)particle.color.getRed() / 255.0f;
        float g = (float)particle.color.getGreen() / 255.0f;
        float b = (float)particle.color.getBlue() / 255.0f;
        float r2 = (float)particle.color2.getRed() / 255.0f;
        float g2 = (float)particle.color2.getGreen() / 255.0f;
        float b2 = (float)particle.color2.getBlue() / 255.0f;
        float a = 0.3f;
        int index = oindex;
        if (particle.field_70546_d > particle.life * branchindex) {
            float agefactor = 1.0f;
            if (branchindex >= particle.branch.length || index >= particle.sizes.length || index >= particle.angles.length) {
                return index;
            }
            float h = particle.sizes[index] * agefactor;
            float w = particle.widths[oindex];
            CullWrappedRenderLayer ringType = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 2 * index + 1));
            CullWrappedRenderLayer ringType2 = new CullWrappedRenderLayer(MahoujinRenderType.createRunesRenderType(beam, 2 * index + 4));
            matrix.func_227861_a_(0.0, (double)(-h), 0.0);
            RenderUtils.rotateQ(particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            RenderUtils.rotateQ(particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w, h, 6, 240, 240, r, g, b, 1.0f, ringType);
            buf.func_228462_a_((RenderType)ringType);
            if (branchindex < particle.branch.length) {
                for (int i = 0; i < particle.branch[branchindex]; ++i) {
                    oindex = ParticleLightning.recursiveLightning(matrix, buf, particle, branchindex + 1, oindex + 1);
                }
            }
            RenderUtils.renderRing(matrix, (IRenderTypeBuffer)buf, 0.0, 90.0f, w * 1.8f, h, 6, 240, 240, r2, g2, b2, a, ringType2);
            buf.func_228462_a_((RenderType)ringType2);
            RenderUtils.rotateQ(-particle.angles2[index], 1.0f, 0.0f, 0.0f, matrix);
            RenderUtils.rotateQ(-particle.angles[index], 0.0f, 1.0f, 0.0f, matrix);
            matrix.func_227861_a_(0.0, (double)h, 0.0);
            return oindex;
        }
        return index;
    }
}

