/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.sounds;

import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffBeamMahoujinEntity;
import stepsword.mahoutsukai.sounds.ModSounds;

public class BeamMovingSound
extends TickableSound {
    private final PlayerEntity player;
    private final MysticStaffBeamMahoujinEntity beam;
    private float lastvolume = 0.0f;

    public BeamMovingSound(PlayerEntity player, MysticStaffBeamMahoujinEntity beam) {
        super(ModSounds.BEAM_TWINKLE, SoundCategory.NEUTRAL);
        this.player = player;
        this.beam = beam;
        this.field_147666_i = ISound.AttenuationType.NONE;
        this.field_147659_g = true;
        this.field_147665_h = 0;
        this.field_147662_b = 0.001f;
        this.lastvolume = 0.001f;
    }

    public void func_73660_a() {
        if (this.beam.func_70089_S()) {
            float len = this.beam.getBeamLength();
            float pt = this.beam.getRotationPitch();
            float yw = this.beam.getRotationYaw();
            Vec3d direction = Vec3d.func_189986_a((float)(90.0f - pt), (float)(360.0f - yw + 180.0f)).func_72432_b();
            Vec3d position = this.beam.func_174791_d();
            double d = this.distanceToLine(position, position.func_178787_e(direction.func_186678_a((double)len)), this.player.func_174791_d().func_178787_e(new Vec3d(0.0, 1.0, 0.0)));
            this.lastvolume = this.field_147662_b;
            if (d > 128.0) {
                this.field_147662_b = 0.0f;
            } else {
                this.field_147663_c = 0.3f + 0.4f * this.beam.getSphereSize() / 0.7f;
                this.field_147663_c += this.beam.getBeamSize() * 0.4f / 0.7f;
                this.field_147662_b = (float)Math.min((double)(this.beam.getSphereSize() * 0.1f + this.beam.getBeamSize() * 0.1f) * (4.0 / d), 1.0);
                this.field_147662_b = (float)((double)this.field_147662_b * MTConfig.MYSTIC_STAFF_BEAM_VOLUME_FACTOR);
            }
        } else {
            this.field_147668_j = true;
        }
    }

    public double distanceToLine(Vec3d v, Vec3d w, Vec3d p) {
        Vec3d VW = v.func_178788_d(w);
        if (VW.func_189985_c() == 0.0) {
            return p.func_72438_d(v);
        }
        Vec3d z = v.func_178788_d(VW.func_186678_a(v.func_178788_d(p).func_72430_b(VW) / VW.func_72430_b(VW)));
        double dv = z.func_72436_e(v);
        double dw = z.func_72436_e(w);
        double dvw = v.func_72436_e(w);
        if (dv > dvw) {
            return p.func_72438_d(w);
        }
        if (dw > dvw) {
            return p.func_72438_d(v);
        }
        return p.func_72438_d(z);
    }
}

