/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.displacement;

import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.MahouTsukaiTeleporter;

public class OrderedDisplacementMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;
    private int receivingTickCounter = 0;
    public static String TELEPORTER_ID_TAG = "MAHOUTSUKAI_TELEPORTER_ID";
    private long teleporter_id;

    public OrderedDisplacementMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.orderedDisplacement);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74772_a(TELEPORTER_ID_TAG, this.teleporter_id);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.teleporter_id = compound.func_74763_f(TELEPORTER_ID_TAG);
        super.func_145839_a(compound);
    }

    public long getTeleporterId() {
        return this.teleporter_id;
    }

    public void setTeleporterId(long t) {
        this.teleporter_id = t;
    }

    public void setReceivingTickCounter(int t) {
        this.receivingTickCounter = t;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.receivingTickCounter <= 0) {
                if (this.tickCounter == MTConfig.ORDERED_DISPLACEMENT_BLOCK_CYCLE) {
                    List lst;
                    BlockPos target = this.getTarget();
                    if (target != null && !(lst = this.field_145850_b.func_217357_a(Entity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)))).isEmpty()) {
                        PlayerEntity caster = this.getCaster();
                        for (Entity entityIn : lst) {
                            boolean nearbyBatteriesGaveMana;
                            if (entityIn.func_226273_bm_() || !(nearbyBatteriesGaveMana = PlayerManaManager.getManaFromBatteriesFirst(this.field_174879_c, this.field_145850_b, this.getCasterUUID(), MTConfig.ORDERED_DISPLACEMENT_MANA_COST)) && (caster == null || PlayerManaManager.drainMana(caster, MTConfig.ORDERED_DISPLACEMENT_MANA_COST, false, false) != MTConfig.ORDERED_DISPLACEMENT_MANA_COST)) continue;
                            MahouTsukaiTeleporter.teleport(entityIn, (double)target.func_177958_n() + 0.5, target.func_177956_o(), (double)target.func_177952_p() + 0.5, entityIn.field_71093_bK);
                            TileEntity te = this.field_145850_b.func_175625_s(target);
                            if (!(te instanceof OrderedDisplacementMahoujinTileEntity)) continue;
                            OrderedDisplacementMahoujinTileEntity mte = (OrderedDisplacementMahoujinTileEntity)te;
                            mte.setReceivingTickCounter(MTConfig.ORDERED_DISPLACEMENT_RECEIVE_COOLDOWN);
                        }
                    }
                    this.tickCounter = 0;
                }
                ++this.tickCounter;
            } else {
                --this.receivingTickCounter;
            }
        }
    }

    public BlockPos getTarget() {
        int radius = MTConfig.ORDERED_DISPLACEMENT_RADIUS;
        ChunkPos cpa = new ChunkPos(this.field_174879_c.func_177982_a(-radius, -radius, -radius));
        ChunkPos cpb = new ChunkPos(this.field_174879_c.func_177982_a(radius, radius, radius));
        HashSet poss = new HashSet();
        for (int i = cpa.field_77276_a; i < cpb.field_77276_a + 1; ++i) {
            for (int j = cpa.field_77275_b; j < cpb.field_77275_b + 1; ++j) {
                Chunk c = this.field_145850_b.func_212866_a_(i, j);
                poss.addAll(c.func_203066_o());
            }
        }
        BlockPos target = null;
        long targetID = -1L;
        BlockPos backupTarget = null;
        long lowestID = -1L;
        for (BlockPos z : poss) {
            OrderedDisplacementMahoujinTileEntity mte;
            TileEntity te = this.field_145850_b.func_175625_s(z);
            if (!(te instanceof OrderedDisplacementMahoujinTileEntity) || this.field_174879_c.equals((Object)z) || !(mte = (OrderedDisplacementMahoujinTileEntity)te).getCasterUUID().equals(this.getCasterUUID()) || z.equals((Object)this.field_174879_c)) continue;
            if ((targetID == -1L || mte.getTeleporterId() < targetID) && mte.getTeleporterId() > this.getTeleporterId()) {
                targetID = mte.getTeleporterId();
                target = z;
            }
            if (mte.getTeleporterId() >= lowestID && lowestID != -1L) continue;
            lowestID = mte.getTeleporterId();
            backupTarget = z;
        }
        if (targetID < this.getTeleporterId()) {
            return backupTarget;
        }
        return target;
    }
}

