/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.capability.mahou.PlayerManaManager;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.Utils;

public class DurabilityExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements ITickableTileEntity {
    private int tickCounter = 0;

    public DurabilityExchangeMahoujinTileEntity() {
        super((TileEntityType)ModTileEntities.durabilityExchange);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tickCounter == MTConfig.DURABILITY_EXCHANGE_BLOCK_CYCLE) {
                this.consumeDurabilityOnTop();
                this.consumeDurabilityBelow();
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void consumeDurabilityBelow() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177982_a(0, -1, 0));
        int restored = 0;
        if (te != null && this.getCaster() != null) {
            IMahou mahou = Utils.getPlayerMahou((LivingEntity)this.getCaster());
            IItemHandler invCap = Utils.getInventory(te);
            if (invCap != null && mahou != null) {
                boolean flag = false;
                for (int i = 0; i < invCap.getSlots(); ++i) {
                    boolean unbreakable;
                    ItemStack stack = invCap.getStackInSlot(i);
                    CompoundNBT nbt = stack.func_77978_p();
                    boolean bl = unbreakable = nbt != null && nbt.func_74764_b("Unbreakable") && nbt.func_74767_n("Unbreakable");
                    if (!stack.func_190926_b() && stack.func_77973_b().func_77645_m() && !unbreakable && stack.func_77952_i() < stack.func_77958_k() && !this.blacklisted(stack.func_77973_b())) {
                        while (stack.func_77952_i() < stack.func_77958_k()) {
                            if (mahou.getStoredMana() >= mahou.getMaxMana()) {
                                mahou.setStoredMana(mahou.getMaxMana());
                                flag = true;
                                break;
                            }
                            int tmp = stack.func_77952_i();
                            stack.func_222118_a(MTConfig.DURABILITY_EXCHANGE_EFFICIENCY, (LivingEntity)this.getCaster(), a -> {});
                            if (stack.func_77952_i() <= tmp) break;
                            mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + 1));
                            if (++restored < MTConfig.DURABILITY_EXCHANGE_MANA_GAIN_CAP) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (flag) break;
                }
            }
        }
    }

    public void consumeDurabilityOnTop() {
        List lst = this.field_145850_b.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 1), (double)(this.field_174879_c.func_177952_p() + 1)));
        boolean flag = false;
        int restored = 0;
        if (this.getCaster() != null) {
            IMahou mahou = Utils.getPlayerMahou((LivingEntity)this.getCaster());
            if (!lst.isEmpty() && mahou != null) {
                for (ItemEntity tmp : lst) {
                    boolean unbreakable;
                    ItemStack stack = tmp.func_92059_d();
                    CompoundNBT nbt = stack.func_77978_p();
                    boolean bl = unbreakable = nbt != null && nbt.func_74764_b("Unbreakable") && nbt.func_74767_n("Unbreakable");
                    if (!unbreakable && stack.func_77973_b().func_77645_m() && stack.func_77952_i() < stack.func_77958_k() && !this.blacklisted(stack.func_77973_b())) {
                        while (stack.func_77952_i() < stack.func_77958_k()) {
                            if (mahou.getStoredMana() >= mahou.getMaxMana()) {
                                mahou.setStoredMana(mahou.getMaxMana());
                                flag = true;
                                break;
                            }
                            int tmp2 = stack.func_77952_i();
                            stack.func_222118_a(MTConfig.DURABILITY_EXCHANGE_EFFICIENCY, (LivingEntity)this.getCaster(), a -> {});
                            if (stack.func_77952_i() <= tmp2) break;
                            mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + 1));
                            ++restored;
                            if (stack.func_77952_i() >= stack.func_77958_k()) {
                                tmp.func_70106_y();
                            }
                            if (restored < MTConfig.DURABILITY_EXCHANGE_MANA_GAIN_CAP) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (!flag) continue;
                    break;
                }
                PlayerManaManager.updateClientMahou((ServerPlayerEntity)this.getCaster(), mahou);
            }
        }
    }

    public boolean blacklisted(Item item) {
        for (int i = 0; i < MTConfig.DURABILITY_EXCHANGE_BLACKLIST.size(); ++i) {
            if (item.getRegistryName() == null || !MTConfig.DURABILITY_EXCHANGE_BLACKLIST.get(i).equals(item.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }
}

