/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.util;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import stepsword.mahoutsukai.item.spells.mystic.MysticStaff.FakeExplosion;
import stepsword.mahoutsukai.util.SafeFakePlayer;

public class EffectUtil {
    public static ResourceLocation effectIcon = new ResourceLocation("mahoutsukai", "textures/items/spell_scroll.png");

    public static void tryFakeExplosion(List<BlockPos> affected, Entity target, PlayerEntity caster, String name, boolean drop) {
        if (!target.field_70170_p.field_72995_K) {
            Object player = caster == null ? new SafeFakePlayer((ServerWorld)target.field_70170_p, new GameProfile(UUID.randomUUID(), name)) : caster;
            FakeExplosion explosion = new FakeExplosion(target.field_70170_p, (Entity)player, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 10.0f, affected);
            ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(target.field_70170_p, (Explosion)explosion, new ArrayList());
            ForgeEventFactory.onExplosionDetonate((World)target.field_70170_p, (Explosion)explosion, new ArrayList(), (double)10.0);
            if (!ee.isCanceled()) {
                for (BlockPos p : ee.getAffectedBlocks()) {
                    BlockState bs = target.field_70170_p.func_180495_p(p);
                    if (bs.func_177230_c() == Blocks.field_150357_h || bs.func_177230_c().isAir(bs, (IBlockReader)target.field_70170_p, p)) continue;
                    if (drop) {
                        Block.func_220059_a((BlockState)bs, (World)target.field_70170_p, (BlockPos)p, (TileEntity)target.field_70170_p.func_175625_s(p));
                    }
                    target.field_70170_p.func_217377_a(p, false);
                    target.field_70170_p.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void tryFakeExplosion(List<BlockPos> affected, PlayerEntity caster, String name, boolean drop) {
        if (!caster.field_70170_p.field_72995_K) {
            Object player = caster == null ? new SafeFakePlayer((ServerWorld)caster.field_70170_p, new GameProfile(UUID.randomUUID(), name)) : caster;
            FakeExplosion explosion = new FakeExplosion(caster.field_70170_p, (Entity)player, caster.func_226277_ct_(), caster.func_226278_cu_(), caster.func_226281_cx_(), 10.0f, affected);
            ExplosionEvent.Detonate ee = new ExplosionEvent.Detonate(caster.field_70170_p, (Explosion)explosion, new ArrayList());
            ForgeEventFactory.onExplosionDetonate((World)caster.field_70170_p, (Explosion)explosion, new ArrayList(), (double)4.0);
            if (!ee.isCanceled()) {
                for (BlockPos p : ee.getAffectedBlocks()) {
                    BlockState bs = caster.field_70170_p.func_180495_p(p);
                    if (bs.func_177230_c() == Blocks.field_150357_h || bs.func_177230_c().isAir(bs, (IBlockReader)caster.field_70170_p, p)) continue;
                    if (drop) {
                        Block.func_220059_a((BlockState)bs, (World)caster.field_70170_p, (BlockPos)p, (TileEntity)caster.field_70170_p.func_175625_s(p));
                    }
                    caster.field_70170_p.func_217377_a(p, false);
                    caster.field_70170_p.func_175656_a(p, Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public static void buff(LivingEntity player, Effect potion, boolean additiveBuff, int ticks) {
        EffectUtil.buff(player, potion, additiveBuff, ticks, true);
    }

    public static void buff(LivingEntity player, Effect potion, boolean additiveBuff, int ticks, boolean showparticles) {
        EffectInstance e;
        int time = ticks;
        if (additiveBuff && player.func_70644_a(potion) && (e = player.func_70660_b(potion)) != null && e.func_76459_b() > 0) {
            time += e.func_76459_b();
        }
        player.func_195064_c(new EffectInstance(potion, time, 0, false, showparticles));
    }

    public static boolean hasBuff(LivingEntity e, Effect potion) {
        return e.func_70644_a(potion);
    }

    public static void debuff(LivingEntity e, Effect potion) {
        if (EffectUtil.hasBuff(e, potion)) {
            e.func_195063_d(potion);
        }
    }

    public static boolean inRange(LivingEntity victim, LivingEntity binder, Vec3d vicPos, int range, boolean facingRequired) {
        Vec3d look = binder.func_70040_Z();
        Vec3d eyes = binder.func_174824_e(1.0f);
        if (EffectUtil.pointToLineDistance(vicPos, eyes, look.func_178787_e(eyes)) < (double)range) {
            if (!facingRequired) {
                return EffectUtil.isLookingAtMe(victim, binder);
            }
            float facing = victim.field_70177_z - binder.field_70177_z;
            if ((facing %= 360.0f) < 0.0f) {
                facing += 360.0f;
            }
            return facing > 90.0f && facing < 270.0f;
        }
        return false;
    }

    public static boolean isLookingAtMe(LivingEntity me, LivingEntity player) {
        return EffectUtil.isLookingAtMe(me, player, 0);
    }

    public static boolean isLookingAtMe(LivingEntity me, LivingEntity player, int limit) {
        Vec3d mv = me.func_174791_d();
        float angleToMe = (float)Math.atan2(mv.field_72449_c - player.func_226281_cx_(), mv.field_72450_a - player.func_226277_ct_()) * 57.2958f;
        float yaw = player.field_70177_z;
        yaw %= 360.0f;
        angleToMe %= 360.0f;
        if (yaw < 0.0f) {
            yaw += 360.0f;
        }
        if (angleToMe < 0.0f) {
            angleToMe += 360.0f;
        }
        float boundUpper = (yaw + 90.0f + 90.0f - (float)limit) % 360.0f;
        float boundLower = (yaw + (float)limit) % 360.0f;
        if (boundLower < 0.0f) {
            boundLower += 360.0f;
        }
        if (boundUpper < 0.0f) {
            boundUpper += 360.0f;
        }
        if (angleToMe < boundUpper && angleToMe > boundLower) {
            return true;
        }
        return boundUpper < boundLower && (angleToMe < boundUpper || angleToMe > boundLower);
    }

    public static void buff(LivingEntity player, Effect potion, boolean additiveBuff, int ticks, int amplifier) {
        EffectInstance e;
        int time = ticks;
        if (additiveBuff && player.func_70644_a(potion) && (e = player.func_70660_b(potion)) != null && e.func_76459_b() > 0) {
            time += e.func_76459_b();
        }
        player.func_195064_c(new EffectInstance(potion, time, amplifier));
    }

    public static int getBuffLevel(LivingEntity e, Effect potion) {
        EffectInstance effect = e.func_70660_b(potion);
        if (effect != null) {
            return effect.func_76458_c();
        }
        return 0;
    }

    public static double pointToLineDistance(Vec3d point, Vec3d line1, Vec3d line2) {
        double d = line2.func_178788_d(line1).func_72431_c(line1.func_178788_d(point)).func_72433_c();
        return d /= line2.func_72438_d(line1);
    }

    public static Vec3d pointToCenter(Vec3d point, Vec3d line1, Vec3d line2) {
        Vec3d z = line2.func_178788_d(line1).func_72431_c(line1.func_178788_d(point));
        return z;
    }

    public static int getEffectDuration(LivingEntity e, Effect p) {
        EffectInstance effect = e.func_70660_b(p);
        if (effect != null) {
            return effect.func_76459_b();
        }
        return 0;
    }

    public static void tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, World world, PlayerEntity player) {
        EffectUtil.tryChangeBlockState(killTE, p, newstate, world, player, null);
    }

    public static boolean tryChangeBlockState(boolean killTE, BlockPos p, BlockState newstate, World world, PlayerEntity player, UUID uuid) {
        if (world != null && !world.field_72995_K) {
            BlockState state = world.func_180495_p(p);
            if (state.func_177230_c() == Blocks.field_150357_h) {
                return false;
            }
            if (!killTE && world.func_175625_s(p) != null) {
                return false;
            }
            if (uuid != null) {
                player = new SafeFakePlayer((ServerWorld)world, new GameProfile(uuid, "faker"));
            }
            if (player == null) {
                player = new SafeFakePlayer((ServerWorld)world, new GameProfile(UUID.randomUUID(), "faker"));
            }
            if (p != null && world != null && player != null && state != null) {
                BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, p, state, player);
                MinecraftForge.EVENT_BUS.post((Event)event);
                if (!event.isCanceled() && event.getResult() != Event.Result.DENY) {
                    world.func_175656_a(p, newstate);
                    return true;
                }
            }
        }
        return false;
    }

    public static int getEnchantmentLevel(ItemStack s, Enchantment e) {
        return EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)s);
    }

    public static boolean hasEnchantment(ItemStack s, Enchantment e) {
        return EffectUtil.getEnchantmentLevel(s, e) > 0;
    }

    public static void addEnchantment(ItemStack s, Enchantment e, int value) {
        Map enchants = EnchantmentHelper.func_82781_a((ItemStack)s);
        enchants.put(e, value);
        EnchantmentHelper.func_82782_a((Map)enchants, (ItemStack)s);
    }

    public static float toRad(float degrees) {
        return degrees * ((float)Math.PI / 180);
    }

    public static float toDegrees(float rad) {
        return rad * 57.29578f;
    }

    public static boolean inEntityBlacklist(Entity e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.func_200600_R() != null && e.func_200600_R().getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.func_200600_R().getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.func_200600_R().getRegistryName().func_110624_b());
        }
        return ret;
    }

    public static boolean inItemBlacklist(Item e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.getRegistryName().func_110624_b());
        }
        return ret;
    }

    public static boolean inEnchantBlacklist(Enchantment e, List<? extends String> z) {
        boolean ret = false;
        if (e != null && e.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = e.getRegistryName().toString();
            ret = set.contains(s) || set.contains(e.getRegistryName().func_110624_b());
        }
        return ret;
    }

    public static boolean inBlockBlacklist(Block b, List<? extends String> z) {
        boolean ret = false;
        if (b != null && b.getRegistryName() != null && z != null && z.size() > 0) {
            HashSet<? extends String> set = new HashSet<String>(z);
            String s = b.getRegistryName().toString();
            ret = set.contains(s) || set.contains(b.getRegistryName().func_110624_b());
        }
        return ret;
    }

    public static void magicAttack(LivingEntity living, float d) {
        living.field_70718_bc = 100;
        living.func_70097_a(DamageSource.field_76376_m, d);
    }
}

