/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.entity.projectile;

import com.oblivioussp.spartanweaponry.entity.projectile.ThrowingWeaponEntity;
import com.oblivioussp.spartanweaponry.init.ModEnchantments;
import com.oblivioussp.spartanweaponry.init.ModEntities;
import com.oblivioussp.spartanweaponry.init.ModSounds;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;

public class BoomerangEntity
extends ThrowingWeaponEntity {
    protected final String NBT_RETURN_POSITION = "ReturnPosition";
    protected final String NBT_X = "X";
    protected final String NBT_Y = "Y";
    protected final String NBT_Z = "Z";
    protected final String NBT_RETURNING = "Returning";
    protected final String NBT_DISTANCE_TO_RETURN = "DistanceToReturn";
    public static final double DISTANCE_TO_RETURN = 5.0;
    protected final double MAX_VELOCITY = 2.0;
    protected final double ACCELERATION = 0.1;
    protected final int TICKS_PER_SOUND = 5;
    protected Vec3d returnPos = null;
    protected boolean isReturning = false;
    protected double maxDistance = 5.0;
    protected int ticksUntilSound = 0;
    protected boolean affectedByWaterDrag = true;

    public BoomerangEntity(EntityType<? extends ThrowingWeaponEntity> type, World world) {
        super(type, world);
        this.initEntity();
    }

    public BoomerangEntity(World world, LivingEntity shooter) {
        super(ModEntities.BOOMERANG, shooter, world);
        this.initEntity();
    }

    public BoomerangEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(ModEntities.BOOMERANG, world);
        this.initEntity();
    }

    protected void initEntity() {
        this.func_189654_d(true);
    }

    protected void setReturnPosition(Entity shooter) {
        if (shooter != null) {
            this.returnPos = new Vec3d(shooter.func_226277_ct_(), shooter.func_226278_cu_() + (double)shooter.func_70047_e() * 0.9 - 0.1, shooter.func_226281_cx_());
        }
    }

    public void setDistanceToReturn(double distance) {
        this.maxDistance = distance;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70254_i) {
            return;
        }
        this.setReturnPosition(this.func_212360_k());
        double distance = -1.0;
        if (this.returnPos != null) {
            distance = this.returnPos.func_72438_d(this.func_174791_d());
        }
        if (this.func_189652_ae()) {
            boolean bl = this.affectedByWaterDrag = this.getWeaponStack() == null || this.getWeaponStack().func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.THROWING_HYDRODYNAMIC, (ItemStack)this.getWeaponStack()) == 0;
            if (distance < 1.0 && this.isReturning || this.field_70171_ac && this.affectedByWaterDrag || this.returnPos == null) {
                this.func_189654_d(false);
            }
            if (distance > this.maxDistance && !this.isReturning) {
                this.isReturning = true;
            }
            if (this.isReturning && this.returnPos != null) {
                Vec3d distanceVec = this.func_174791_d().func_178788_d(this.returnPos);
                double length = distanceVec.func_72433_c();
                if (length < 5.0) {
                    this.func_213293_j(-distanceVec.field_72450_a / length, -distanceVec.field_72448_b / length, -distanceVec.field_72449_c / length);
                } else {
                    this.func_213317_d(this.func_213322_ci().func_72441_c(-0.1 * (distanceVec.field_72450_a / length), -0.1 * (distanceVec.field_72448_b / length), -0.1 * (distanceVec.field_72449_c / length)));
                }
            }
            if (this.ticksUntilSound <= 0) {
                this.ticksUntilSound = 5;
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.getFlySound(), SoundCategory.NEUTRAL, 2.0f, 0.5f);
                }
            }
            --this.ticksUntilSound;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa > 200) {
            if (this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                this.func_70099_a(this.func_184550_j(), 0.1f);
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && !this.field_70254_i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    protected void func_184548_a(LivingEntity living) {
        this.isReturning = true;
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        if (raytraceResultIn.func_216346_c() == RayTraceResult.Type.BLOCK && this.func_189652_ae()) {
            this.isReturning = true;
            BlockRayTraceResult blockRaytrace = (BlockRayTraceResult)raytraceResultIn;
            BlockPos blockPos = blockRaytrace.func_216350_a();
            BlockState blockState = this.field_70170_p.func_180495_p(blockPos);
            Vec3i faceNormali = blockRaytrace.func_216354_b().func_176730_m();
            Vec3d faceNormalVec = new Vec3d((double)faceNormali.func_177958_n(), (double)faceNormali.func_177956_o(), (double)faceNormali.func_177952_p());
            Vec3d motionVec = this.func_213322_ci();
            faceNormalVec.func_72432_b();
            Vec3d reflectVec = faceNormalVec.func_186678_a(2.0 * motionVec.func_72430_b(faceNormalVec)).func_178788_d(motionVec);
            this.func_213317_d(reflectVec.func_186678_a(-0.75));
            this.func_184185_a(this.getBounceSound(), 1.0f, 2.2f / this.field_70146_Z.nextFloat() * 0.2f + 0.9f);
            if (blockState.func_185904_a() != Material.field_151579_a) {
                blockState.func_215690_a(this.field_70170_p, blockState, blockRaytrace, (Entity)this);
            }
        } else {
            super.func_184549_a(raytraceResultIn);
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("ReturnPosition")) {
            CompoundNBT returnPosNBT = compound.func_74775_l("ReturnPosition");
            if (!returnPosNBT.isEmpty()) {
                double x = returnPosNBT.func_74769_h("X");
                double y = returnPosNBT.func_74769_h("Y");
                double z = returnPosNBT.func_74769_h("Z");
                this.returnPos = new Vec3d(x, y, z);
            } else {
                this.returnPos = null;
            }
            this.maxDistance = compound.func_74769_h("DistanceToReturn");
        } else {
            this.returnPos = null;
        }
        this.isReturning = compound.func_74767_n("Returning");
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.returnPos != null) {
            CompoundNBT returnPosNBT = new CompoundNBT();
            returnPosNBT.func_74780_a("X", this.returnPos.field_72450_a);
            returnPosNBT.func_74780_a("Y", this.returnPos.field_72448_b);
            returnPosNBT.func_74780_a("Z", this.returnPos.field_72449_c);
            compound.func_218657_a("ReturnPosition", (INBT)returnPosNBT);
            compound.func_74780_a("DistanceToReturn", this.maxDistance);
        } else {
            compound.func_82580_o("ReturnPosition");
        }
        compound.func_74757_a("Returning", this.isReturning);
    }

    protected float func_203044_p() {
        return this.affectedByWaterDrag ? super.func_203044_p() : 0.99f;
    }

    @Override
    protected boolean canBeCaughtInMidair(Entity shooter, Entity entityHit) {
        return shooter.func_70028_i(entityHit);
    }

    public void func_70103_a(byte id) {
        super.func_70103_a(id);
    }

    @Override
    protected SoundEvent getGroundHitSound() {
        return ModSounds.BOOMERANG_HIT_GROUND;
    }

    @Override
    protected SoundEvent getMobHitSound() {
        return ModSounds.BOOMERANG_HIT_MOB;
    }

    protected SoundEvent getFlySound() {
        return ModSounds.BOOMERANG_FLY;
    }

    protected SoundEvent getBounceSound() {
        return ModSounds.BOOMERANG_BOUNCE;
    }
}

