/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.item.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.oblivioussp.spartanweaponry.init.ModRecipeSerializers;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TippedProjectileBaseRecipe
extends SpecialRecipe {
    protected final Item projectileIn;
    protected final Item projectileOut;

    public TippedProjectileBaseRecipe(ResourceLocation idIn, Item arrowIn, Item arrowOut) {
        super(idIn);
        this.projectileIn = arrowIn;
        this.projectileOut = arrowOut;
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        if (inv.func_174922_i() == 3 && inv.func_174923_h() == 3) {
            for (int i = 0; i < inv.func_174922_i(); ++i) {
                for (int j = 0; j < inv.func_174923_h(); ++j) {
                    ItemStack stack = inv.func_70301_a(j * inv.func_174922_i() + i);
                    if (stack.func_190926_b()) {
                        return false;
                    }
                    Item item = stack.func_77973_b();
                    if (!(i == 1 && j == 1 ? item != Items.field_185156_bI : item != this.projectileIn)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        Potion potion;
        ItemStack potionStack = inv.func_70301_a(1 + inv.func_174922_i());
        if (potionStack.func_77973_b() == Items.field_185156_bI && !(potion = PotionUtils.func_185191_c((ItemStack)potionStack)).func_185170_a().isEmpty()) {
            ItemStack arrowResult = new ItemStack((IItemProvider)this.projectileOut, 8);
            PotionUtils.func_185188_a((ItemStack)arrowResult, (Potion)potion);
            return arrowResult;
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 2 && height >= 2;
    }

    public boolean func_192399_d() {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipeSerializers.TIPPED_PROJECTILE_BASE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<TippedProjectileBaseRecipe> {
        public TippedProjectileBaseRecipe read(ResourceLocation recipeId, JsonObject json) {
            String projInName = JSONUtils.func_151200_h((JsonObject)json, (String)"projectile");
            String projOutName = JSONUtils.func_151200_h((JsonObject)json, (String)"result");
            Item projIn = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(projInName));
            Item projOut = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(projOutName));
            if (projIn == null) {
                throw new JsonSyntaxException("Input projectile " + projInName + " doesn't exist!");
            }
            if (projOut == null) {
                throw new JsonSyntaxException("Result projectile " + projOutName + " doesn't exist!");
            }
            return new TippedProjectileBaseRecipe(recipeId, projIn, projOut);
        }

        public TippedProjectileBaseRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            ResourceLocation projInLoc = buffer.func_192575_l();
            ResourceLocation projOutLoc = buffer.func_192575_l();
            Item projIn = (Item)ForgeRegistries.ITEMS.getValue(projInLoc);
            Item projOut = (Item)ForgeRegistries.ITEMS.getValue(projOutLoc);
            return new TippedProjectileBaseRecipe(recipeId, projIn, projOut);
        }

        public void write(PacketBuffer buffer, TippedProjectileBaseRecipe recipe) {
            buffer.func_192572_a(recipe.projectileIn.getRegistryName());
            buffer.func_192572_a(recipe.projectileOut.getRegistryName());
        }
    }
}

