/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oblivioussp.spartanweaponry.util.Config;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class TypeDisabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("spartanweaponry", "type_disabled");
    private final List<String> types;

    public TypeDisabledCondition(List<String> types) {
        this.types = types;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        for (String type : this.types) {
            if (!Config.INSTANCE.disabledRecipeTypes.contains(type)) continue;
            return false;
        }
        return true;
    }

    public static class Serializer
    implements IConditionSerializer<TypeDisabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, TypeDisabledCondition value) {
            JsonArray array = new JsonArray();
            for (String type : value.types) {
                array.add(type);
            }
            json.add("disabled", (JsonElement)array);
        }

        public TypeDisabledCondition read(JsonObject json) {
            JsonArray array = JSONUtils.func_151214_t((JsonObject)json, (String)"disabled");
            ArrayList<String> typeList = new ArrayList<String>();
            for (int i = 0; i < array.size(); ++i) {
                String str = array.get(i).getAsString();
                typeList.add(str);
            }
            return new TypeDisabledCondition(typeList);
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

