/*
 * Decompiled with CFR 0.152.
 */
package com.focamacho.vampiresneedumbrellas.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigUmbrella {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    private static final General GENERAL = new General(BUILDER);
    public static final ForgeConfigSpec spec = BUILDER.build();
    public static ForgeConfigSpec.IntValue configIronUmbrellaDurability;
    public static ForgeConfigSpec.IntValue configGoldUmbrellaDurability;
    public static ForgeConfigSpec.IntValue configDiamondUmbrellaDurability;
    public static ForgeConfigSpec.BooleanValue configUmbrellaMainHand;
    public static ForgeConfigSpec.BooleanValue configUmbrellaOffHand;
    public static ForgeConfigSpec.BooleanValue configUmbrellaAnvil;
    public static ForgeConfigSpec.BooleanValue configUmbrellaBauble;
    public static ForgeConfigSpec.BooleanValue configCreativeUmbrellaConfigs;

    public static class General {
        public General(ForgeConfigSpec.Builder builder) {
            builder.push("Umbrellas Durability");
            configIronUmbrellaDurability = builder.comment("The durability in seconds of the Iron Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.ironUmbrellaDurability").defineInRange("ironUmbrellaDurability", 600, -1, 432000);
            configGoldUmbrellaDurability = builder.comment("The durability in seconds of the Gold Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.goldUmbrellaDurability").defineInRange("goldUmbrellaDurability", 2400, -1, 432000);
            configDiamondUmbrellaDurability = builder.comment("The durability in seconds of the Diamond Umbrella when in the sun. Set to -1 if you want it to be unbreakable").translation("vampiresneedumbrellas.config.diamondUmbrellaDurability").defineInRange("diamondUmbrellaDurability", 9600, -1, 432000);
            builder.pop();
            builder.push("Umbrellas Mechanics");
            configUmbrellaMainHand = builder.comment("Set to false if you don't want the umbrella to work in the main-hand").translation("vampiresneedumbrellas.config.umbrellaMainHand").define("umbrellaMainHand", true);
            configUmbrellaOffHand = builder.comment("Set to false if you don't want the umbrella to work in the off-hand").translation("vampiresneedumbrellas.config.umbrellaOffHand").define("umbrellaOffHand", true);
            configUmbrellaAnvil = builder.comment("Set to false if you don't want the umbrella to be enchanted using anvils.").translation("vampiresneedumbrellas.config.umbrellaAnvil").define("umbrellaAnvil", false);
            configUmbrellaBauble = builder.comment("Set to false if you don't want the umbrella to be used in the curios slot").translation("vampiresneedumbrellas.config.umbrellaBauble").define("umbrellaBauble", false);
            builder.pop();
            builder.push("Others");
            configCreativeUmbrellaConfigs = builder.comment("If true, the Creative Umbrella will respect the \"umbrellaMainHand\" and \"umbrellaOffHand\" configs.\nIf false, the Creative Umbrella will always works in main-hand and off-hand").translation("vampiresneedumbrellas.config.creativeUmbrellaConfigs").define("creativeUmbrellaConfigs", false);
            builder.pop();
        }
    }
}

