/*
 * Decompiled with CFR 0.152.
 */
package lain.mods.cos.impl.inventory;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import lain.mods.cos.impl.ModObjects;
import lain.mods.cos.impl.inventory.InventoryCosArmor;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerCosArmor
extends RecipeBookContainer<CraftingInventory> {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    private final PlayerEntity player;
    private final CraftingInventory craftingInventory = new CraftingInventory((Container)this, 2, 2);
    private final CraftResultInventory craftResultInventory = new CraftResultInventory();

    private static void updateCrafting(int windowId, World world, PlayerEntity player, CraftingInventory craftingInventory, CraftResultInventory craftResultInventory) {
        if (!world.field_72995_K) {
            ICraftingRecipe recipe;
            ServerPlayerEntity serverplayer = (ServerPlayerEntity)player;
            ItemStack stack = ItemStack.field_190927_a;
            Optional optionalrecipe = world.func_73046_m().func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)craftingInventory, world);
            if (optionalrecipe.isPresent() && craftResultInventory.func_201561_a(world, serverplayer, (IRecipe)(recipe = (ICraftingRecipe)optionalrecipe.get()))) {
                stack = recipe.func_77572_b((IInventory)craftingInventory);
            }
            craftResultInventory.func_70299_a(0, stack);
            serverplayer.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(windowId, 0, stack));
        }
    }

    public ContainerCosArmor(PlayerInventory invPlayer, InventoryCosArmor invCosArmor, final PlayerEntity player, int windowId) {
        super(ModObjects.typeContainerCosArmor, windowId);
        int i;
        this.player = player;
        this.func_75146_a((Slot)new CraftingResultSlot(player, this.craftingInventory, (IInventory)this.craftResultInventory, 0, 154, 28));
        for (i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftingInventory, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)invPlayer, 39 - k, 8, 8 + k * 18){

                public boolean func_82869_a(PlayerEntity playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return !itemstack.func_190926_b() && !playerIn.func_184812_l_() && EnchantmentHelper.func_190938_b((ItemStack)itemstack) ? false : super.func_82869_a(playerIn);
                }

                @Nullable
                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.func_188454_b()]);
                }

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)player);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)invPlayer, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)invPlayer, i1, 8 + i1 * 18, 142));
        }
        this.func_75146_a(new Slot((IInventory)invPlayer, 40, 77, 62){

            @Nullable
            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
        for (i = 0; i < 4; ++i) {
            final int j = i;
            this.func_75146_a(new Slot(invCosArmor, 3 - i, 98 + i * 18, 62){

                @Nullable
                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[VALID_EQUIPMENT_SLOTS[j].func_188454_b()]);
                }

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(ItemStack stack) {
                    return stack.canEquip(VALID_EQUIPMENT_SLOTS[j], (Entity)player);
                }
            });
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return slotIn.field_75224_c != this.craftResultInventory && super.func_94530_a(stack, slotIn);
    }

    public void func_201768_e() {
        this.craftResultInventory.func_174888_l();
        this.craftingInventory.func_174888_l();
    }

    public void func_201771_a(RecipeItemHelper arg0) {
        this.craftingInventory.func_194018_a(arg0);
    }

    public int func_201772_h() {
        return this.craftingInventory.func_174923_h();
    }

    public int func_201767_f() {
        return 0;
    }

    public List<RecipeBookCategories> getRecipeBookCategories() {
        return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.SEARCH, RecipeBookCategories.EQUIPMENT, RecipeBookCategories.BUILDING_BLOCKS, RecipeBookCategories.MISC, RecipeBookCategories.REDSTONE});
    }

    public int func_203721_h() {
        return 5;
    }

    public int func_201770_g() {
        return this.craftingInventory.func_174922_i();
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> arg0) {
        return arg0.func_77569_a((IInventory)this.craftingInventory, this.player.field_70170_p);
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.craftResultInventory.func_174888_l();
        if (!playerIn.field_70170_p.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.craftingInventory);
        }
    }

    public void func_75130_a(IInventory inventoryIn) {
        ContainerCosArmor.updateCrafting(this.field_75152_c, this.player.field_70170_p, this.player, this.craftingInventory, this.craftResultInventory);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotNumber) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotNumber);
        if (slot != null && slot.func_75216_d()) {
            int j;
            ItemStack stack1 = slot.func_75211_c();
            stack = stack1.func_77946_l();
            EquipmentSlotType desiredSlot = MobEntity.func_184640_d((ItemStack)stack);
            if (slotNumber == 0) {
                if (!this.func_75135_a(stack1, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack1, stack);
            } else if (slotNumber >= 1 && slotNumber < 5 ? !this.func_75135_a(stack1, 9, 45, false) : (slotNumber >= 5 && slotNumber < 9 ? !this.func_75135_a(stack1, 9, 45, false) : (slotNumber >= 46 && slotNumber < 50 ? !this.func_75135_a(stack1, 9, 45, false) : (desiredSlot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(8 - desiredSlot.func_188454_b())).func_75216_d() ? !this.func_75135_a(stack1, j = 8 - desiredSlot.func_188454_b(), j + 1, false) : (desiredSlot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(49 - desiredSlot.func_188454_b())).func_75216_d() ? !this.func_75135_a(stack1, j = 49 - desiredSlot.func_188454_b(), j + 1, false) : (slotNumber >= 9 && slotNumber < 36 ? !this.func_75135_a(stack1, 36, 45, false) : (slotNumber >= 36 && slotNumber < 45 ? !this.func_75135_a(stack1, 9, 36, false) : !this.func_75135_a(stack1, 9, 45, false)))))))) {
                return ItemStack.field_190927_a;
            }
            if (stack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack1.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack2 = slot.func_190901_a(player, stack1);
            if (slotNumber == 0) {
                player.func_71019_a(stack2, false);
            }
        }
        return stack;
    }
}

