/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.util.ArrayList;
import javax.annotation.Nullable;
import mezz.jei.network.Network;
import mezz.jei.network.packets.PacketCheatPermission;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.GiveMode;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CommandUtilServer {
    private static final Logger LOGGER = LogManager.getLogger();

    private CommandUtilServer() {
    }

    public static String[] getGiveCommandParameters(PlayerEntity sender, ItemStack itemStack, int amount) {
        ITextComponent senderName = sender.func_200200_C_();
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName.getString());
        String itemArgument = itemResourceLocation.toString();
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            itemArgument = itemArgument + tagCompound;
        }
        commandStrings.add(itemArgument);
        commandStrings.add(String.valueOf(amount));
        return commandStrings.toArray(new String[0]);
    }

    public static void writeChatMessage(PlayerEntity player, String translationKey, TextFormatting color) {
        TranslationTextComponent component = new TranslationTextComponent(translationKey, new Object[0]);
        component.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)component);
    }

    public static boolean hasPermission(PlayerEntity sender) {
        if (sender.func_184812_l_()) {
            return true;
        }
        CommandNode<CommandSource> giveCommand = CommandUtilServer.getGiveCommand(sender);
        CommandSource commandSource = sender.func_195051_bN();
        if (giveCommand != null) {
            return giveCommand.canUse((Object)commandSource);
        }
        MinecraftServer minecraftServer = sender.func_184102_h();
        if (minecraftServer == null) {
            return false;
        }
        int opPermissionLevel = minecraftServer.func_110455_j();
        return commandSource.func_197034_c(opPermissionLevel);
    }

    public static void executeGive(ServerPlayerEntity sender, ItemStack itemStack, GiveMode giveMode) {
        if (CommandUtilServer.hasPermission((PlayerEntity)sender)) {
            if (giveMode == GiveMode.INVENTORY) {
                CommandUtilServer.giveToInventory((PlayerEntity)sender, itemStack);
            } else if (giveMode == GiveMode.MOUSE_PICKUP) {
                CommandUtilServer.mousePickupItemStack((PlayerEntity)sender, itemStack);
            }
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void setHotbarSlot(ServerPlayerEntity sender, ItemStack itemStack, int hotbarSlot) {
        if (CommandUtilServer.hasPermission((PlayerEntity)sender)) {
            if (!PlayerInventory.func_184435_e((int)hotbarSlot)) {
                LOGGER.error("Tried to set slot that is not in the hotbar: {}", (Object)hotbarSlot);
                return;
            }
            ItemStack stackInSlot = sender.field_71071_by.func_70301_a(hotbarSlot);
            if (ItemStack.func_77989_b((ItemStack)stackInSlot, (ItemStack)itemStack)) {
                return;
            }
            ItemStack itemStackCopy = itemStack.func_77946_l();
            sender.field_71071_by.func_70299_a(hotbarSlot, itemStack);
            sender.field_70170_p.func_184148_a(null, sender.func_226277_ct_(), sender.func_226278_cu_(), sender.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((sender.func_70681_au().nextFloat() - sender.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.field_71069_bz.func_75142_b();
            CommandUtilServer.notifyGive((PlayerEntity)sender, itemStackCopy);
        } else {
            Network.sendPacketToClient(new PacketCheatPermission(false), sender);
        }
    }

    public static void mousePickupItemStack(PlayerEntity sender, ItemStack itemStack) {
        int giveCount;
        ItemStack itemStackCopy = itemStack.func_77946_l();
        ItemStack existingStack = sender.field_71071_by.func_70445_o();
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)existingStack, (ItemStack)itemStack)) {
            int newCount = Math.min(existingStack.func_77976_d(), existingStack.func_190916_E() + itemStack.func_190916_E());
            giveCount = newCount - existingStack.func_190916_E();
            existingStack.func_190920_e(newCount);
        } else {
            sender.field_71071_by.func_70437_b(itemStack);
            giveCount = itemStack.func_190916_E();
        }
        if (sender instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)sender;
            itemStackCopy.func_190920_e(giveCount);
            CommandUtilServer.notifyGive((PlayerEntity)serverPlayerEntity, itemStackCopy);
            serverPlayerEntity.func_71113_k();
        }
    }

    private static void giveToInventory(PlayerEntity entityplayermp, ItemStack itemStack) {
        ItemStack itemStackCopy = itemStack.func_77946_l();
        boolean flag = entityplayermp.field_71071_by.func_70441_a(itemStack);
        if (flag && itemStack.func_190926_b()) {
            itemStack.func_190920_e(1);
            ItemEntity entityitem = entityplayermp.func_71019_a(itemStack, false);
            if (entityitem != null) {
                entityitem.func_174870_v();
            }
            entityplayermp.field_70170_p.func_184148_a(null, entityplayermp.func_226277_ct_(), entityplayermp.func_226278_cu_(), entityplayermp.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((entityplayermp.func_70681_au().nextFloat() - entityplayermp.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            entityplayermp.field_71069_bz.func_75142_b();
        } else {
            ItemEntity entityitem = entityplayermp.func_71019_a(itemStack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_200217_b(entityplayermp.func_110124_au());
            }
        }
        CommandUtilServer.notifyGive(entityplayermp, itemStackCopy);
    }

    private static void notifyGive(PlayerEntity entityPlayerMP, ItemStack stack) {
        CommandSource commandSource = entityPlayerMP.func_195051_bN();
        int count = stack.func_190916_E();
        ITextComponent stackTextComponent = stack.func_151000_E();
        ITextComponent displayName = entityPlayerMP.func_145748_c_();
        TranslationTextComponent message = new TranslationTextComponent("commands.give.success.single", new Object[]{count, stackTextComponent, displayName});
        commandSource.func_197030_a((ITextComponent)message, true);
    }

    @Nullable
    private static CommandNode<CommandSource> getGiveCommand(PlayerEntity sender) {
        MinecraftServer minecraftServer = sender.func_184102_h();
        if (minecraftServer == null) {
            return null;
        }
        Commands commandManager = minecraftServer.func_195571_aL();
        CommandDispatcher dispatcher = commandManager.func_197054_a();
        RootCommandNode root = dispatcher.getRoot();
        return root.getChild("give");
    }
}

