/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui;

import com.creativemd.creativecore.common.gui.CoreControl;
import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiColorPicker;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButtonTranslated;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.littletiles.common.particle.LittleParticlePresets;
import com.creativemd.littletiles.common.particle.LittleParticleTexture;
import com.creativemd.littletiles.common.structure.type.premade.LittleParticleEmitter;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.util.Color;

public class SubGuiParticle
extends SubGui {
    public LittleParticleEmitter particle;
    private static LinkedHashMap<String, ParticleSpreadGuiHandler> spreadHandlers = new LinkedHashMap();
    private static HashMap<Class, String> spreadClass = new HashMap();

    public SubGuiParticle(LittleParticleEmitter particle) {
        super(200, 230);
        this.particle = particle;
    }

    public void createControls() {
        ArrayList<String> textures = new ArrayList<String>();
        for (int i = 0; i < LittleParticleTexture.values().length; ++i) {
            textures.add(LittleParticleTexture.values()[i].translatedName());
        }
        ArrayList<String> presets = new ArrayList<String>();
        presets.add("");
        for (LittleParticlePresets preset : LittleParticlePresets.values()) {
            presets.add(SubGuiParticle.translate((String)("gui.particle.preset." + preset.name().toLowerCase())));
        }
        final GuiComboBox box = new GuiComboBox("presets", 0, 0, 125, presets);
        this.controls.add(box);
        this.controls.add(new GuiButton(SubGuiParticle.translate((String)"gui.particle.load"), 135, 0){

            public void onClicked(int x, int y, int button) {
                if (box.index > 0) {
                    SubGuiParticle.this.loadPreset(LittleParticlePresets.values()[box.index - 1]);
                }
            }
        });
        this.controls.add(new GuiLabel("textureLabel", SubGuiParticle.translate((String)"gui.particle.texture"), 0, 27));
        this.controls.add(new GuiComboBox("textures", 78, 25, 116, textures));
        this.controls.add(new GuiLabel("sizeLabel", SubGuiParticle.translate((String)"gui.particle.size"), 0, 48));
        this.controls.add(new GuiTextfield("size", "0.4", 30, 46, 25, 12).setFloatOnly());
        this.controls.add(new GuiLabel("sizeEndLabel", "->", 62, 48));
        this.controls.add(new GuiTextfield("sizeend", "0.4", 79, 46, 25, 12).setFloatOnly());
        this.controls.add(new GuiLabel("sizeDeviationLabel", SubGuiParticle.translate((String)"gui.particle.sizedeviation"), 115, 48));
        this.controls.add(new GuiTextfield("sizedeviation", "0.02", 165, 46, 25, 12).setFloatOnly());
        this.controls.add(new GuiColorPicker("color", 0, 65, new Color(255, 255, 255), true, 1));
        this.controls.add(new GuiCheckBox("randomColor", SubGuiParticle.translate((String)"gui.particle.randomcolor"), 110, 95, this.particle.settings.randomColor));
        this.controls.add(new GuiLabel("ageLabel", SubGuiParticle.translate((String)"gui.particle.age"), 0, 111));
        this.controls.add(new GuiSteppedSlider("age", 30, 110, 50, 8, 20, 1, 100));
        this.controls.add(new GuiLabel("ageDeviationLabel", SubGuiParticle.translate((String)"gui.particle.agedeviation"), 86, 111));
        this.controls.add(new GuiTextfield("agedeviation", "5", 140, 110, 30, 8).setNumbersOnly());
        this.controls.add(new GuiLabel("countLabel", SubGuiParticle.translate((String)"gui.particle.count"), 0, 132));
        this.controls.add(new GuiTextfield("count", "" + this.particle.count, 40, 130, 30, 12).setNumbersOnly());
        this.controls.add(new GuiLabel("perLabel", SubGuiParticle.translate((String)"gui.particle.per"), 80, 132));
        this.controls.add(new GuiTextfield("delay", "" + this.particle.delay, 110, 130, 30, 12).setNumbersOnly());
        this.controls.add(new GuiLabel("tickLabel", SubGuiParticle.translate((String)"gui.particle.tick"), 150, 132));
        this.controls.add(new GuiLabel("gravityLabel", SubGuiParticle.translate((String)"gui.particle.gravity"), 96, 151));
        this.controls.add(new GuiAnalogeSlider("gravity", 140, 150, 50, 8, 0.0, -1.0, 1.0));
        GuiTabStateButtonTranslated state = new GuiTabStateButtonTranslated("spread", 0, "gui.particle.spread", 0, 150, 12, SubGuiParticle.spreadHandlerNames());
        state.selected = ArrayUtils.indexOf((Object[])state.states, (Object)SubGuiParticle.getSpreadId(this.particle.spread.getClass()));
        if (state.selected == -1) {
            state.selected = 0;
        }
        this.controls.add(state);
        this.controls.add(new GuiPanel("spreadpanel", 0, 170, 194, 38));
        this.loadSpread(this.particle.spread);
        this.controls.add(new GuiButton("save", SubGuiParticle.translate((String)"gui.save"), 165, 216, 29, 8){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                GuiTextfield count = (GuiTextfield)SubGuiParticle.this.get("count");
                nbt.func_74768_a("tickCount", count.parseInteger());
                GuiTextfield delay = (GuiTextfield)SubGuiParticle.this.get("delay");
                nbt.func_74768_a("tickDelay", delay.parseInteger());
                LittleParticleEmitter.ParticleSpread spread = SubGuiParticle.this.parseSpread();
                spread.write(nbt);
                LittleParticleEmitter.ParticleSettings newSettings = new LittleParticleEmitter.ParticleSettings();
                GuiCheckBox randomColor = (GuiCheckBox)SubGuiParticle.this.get("randomColor");
                newSettings.randomColor = randomColor.value;
                GuiComboBox textures = (GuiComboBox)SubGuiParticle.this.get("textures");
                newSettings.texture = LittleParticleTexture.get(textures.getCaption());
                GuiSteppedSlider age = (GuiSteppedSlider)SubGuiParticle.this.get("age");
                newSettings.lifetime = (int)age.value;
                GuiTextfield agedeviation = (GuiTextfield)SubGuiParticle.this.get("agedeviation");
                newSettings.lifetimeDeviation = agedeviation.parseInteger();
                GuiColorPicker color = (GuiColorPicker)SubGuiParticle.this.get("color");
                newSettings.color = ColorUtils.RGBAToInt((Color)color.color);
                GuiAnalogeSlider gravity = (GuiAnalogeSlider)SubGuiParticle.this.get("gravity");
                newSettings.gravity = (float)gravity.value;
                GuiTextfield size = (GuiTextfield)SubGuiParticle.this.get("size");
                newSettings.startSize = size.parseFloat();
                GuiTextfield sizeend = (GuiTextfield)SubGuiParticle.this.get("sizeend");
                newSettings.endSize = sizeend.parseFloat();
                GuiTextfield sizedeviation = (GuiTextfield)SubGuiParticle.this.get("sizedeviation");
                newSettings.sizeDeviation = sizedeviation.parseFloat();
                NBTTagCompound data = new NBTTagCompound();
                newSettings.write(data);
                nbt.func_74782_a("settings", (NBTBase)data);
                SubGuiParticle.this.sendPacketToServer(nbt);
                SubGuiParticle.this.closeGui();
            }
        });
        this.loadParticleSettings(this.particle.settings);
    }

    public void loadPreset(LittleParticlePresets preset) {
        this.loadParticleSettings(preset.settings);
        GuiTextfield count = (GuiTextfield)this.get("count");
        count.text = "" + preset.count;
        GuiTextfield delay = (GuiTextfield)this.get("delay");
        delay.text = "" + preset.delay;
        GuiTabStateButton spread = (GuiTabStateButton)this.get("spread");
        GuiTabStateButtonTranslated state = new GuiTabStateButtonTranslated("spread", 0, "gui.particle.spread", 0, 150, 12, SubGuiParticle.spreadHandlerNames());
        state.selected = ArrayUtils.indexOf((Object[])state.states, (Object)SubGuiParticle.getSpreadId(this.particle.spread.getClass()));
        if (state.selected == -1) {
            state.selected = 0;
        }
        this.loadSpread(preset.spread);
    }

    public void loadSpread(LittleParticleEmitter.ParticleSpread particleSpread) {
        GuiTabStateButton spread = (GuiTabStateButton)this.get("spread");
        ParticleSpreadGuiHandler handler = SubGuiParticle.getSpreadHanlder(spread.getCaption());
        if (handler != null) {
            GuiPanel panel = (GuiPanel)this.get("spreadpanel");
            panel.controls.clear();
            handler.createControls((GuiParent)panel, particleSpread);
        }
    }

    public LittleParticleEmitter.ParticleSpread parseSpread() {
        GuiTabStateButton tab = (GuiTabStateButton)this.get("spread");
        ParticleSpreadGuiHandler handler = SubGuiParticle.getSpreadHanlder(tab.getCaption());
        GuiPanel panel = (GuiPanel)this.get("spreadpanel");
        if (handler != null) {
            return handler.parse((GuiParent)panel);
        }
        return new LittleParticleEmitter.ParticleSpreadRandom();
    }

    @CustomEventSubscribe
    public void onParticleChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"spread"})) {
            this.loadSpread(this.particle.spread);
        }
    }

    public void loadParticleSettings(LittleParticleEmitter.ParticleSettings settings) {
        GuiComboBox textures = (GuiComboBox)this.get("textures");
        textures.select(settings.texture.translatedName());
        GuiSteppedSlider age = (GuiSteppedSlider)this.get("age");
        age.setValue((double)settings.lifetime);
        GuiTextfield agedeviation = (GuiTextfield)this.get("agedeviation");
        agedeviation.text = "" + settings.lifetimeDeviation;
        GuiColorPicker color = (GuiColorPicker)this.get("color");
        color.setColor(ColorUtils.IntToRGBA((int)settings.color));
        GuiAnalogeSlider gravity = (GuiAnalogeSlider)this.get("gravity");
        gravity.setValue((double)settings.gravity);
        GuiTextfield size = (GuiTextfield)this.get("size");
        size.text = "" + settings.startSize;
        GuiTextfield sizeend = (GuiTextfield)this.get("sizeend");
        sizeend.text = "" + settings.endSize;
        GuiTextfield sizedeviation = (GuiTextfield)this.get("sizedeviation");
        sizedeviation.text = "" + settings.sizeDeviation;
    }

    public static String[] spreadHandlerNames() {
        return spreadHandlers.keySet().toArray(new String[0]);
    }

    public static ParticleSpreadGuiHandler getSpreadHanlder(String key) {
        return spreadHandlers.get(key);
    }

    public static String getSpreadId(Class<? extends LittleParticleEmitter.ParticleSpread> clazz) {
        return spreadClass.getOrDefault(clazz, "random");
    }

    public static void registerParticleSpreadGuiHandler(String key, Class<? extends LittleParticleEmitter.ParticleSpread> clazz, ParticleSpreadGuiHandler handler) {
        spreadClass.put(clazz, key);
        spreadHandlers.put(key, handler);
    }

    static {
        SubGuiParticle.registerParticleSpreadGuiHandler("random", LittleParticleEmitter.ParticleSpreadRandom.class, new ParticleSpreadGuiHandler(){

            @Override
            public LittleParticleEmitter.ParticleSpread parse(GuiParent parent) {
                LittleParticleEmitter.ParticleSpreadRandom spread = new LittleParticleEmitter.ParticleSpreadRandom();
                GuiTextfield speedx = (GuiTextfield)parent.get("speedx");
                spread.speedX = speedx.parseFloat();
                GuiTextfield speedy = (GuiTextfield)parent.get("speedy");
                spread.speedY = speedy.parseFloat();
                GuiTextfield speedz = (GuiTextfield)parent.get("speedz");
                spread.speedZ = speedz.parseFloat();
                GuiTextfield spreadT = (GuiTextfield)parent.get("deviation");
                spread.spread = spreadT.parseFloat();
                return spread;
            }

            @Override
            public void createControls(GuiParent parent, LittleParticleEmitter.ParticleSpread spread) {
                parent.addControl((GuiControl)new GuiLabel("speedyLabel", CoreControl.translate((String)"gui.particle.spread.speedy"), 0, 2));
                parent.addControl((GuiControl)new GuiTextfield("speedy", "" + spread.speedY, 43, 0, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("spreadLabel", CoreControl.translate((String)"gui.particle.spread.spread"), 90, 2));
                parent.addControl((GuiControl)new GuiTextfield("deviation", "" + spread.spread, 145, 0, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("speedxLabel", CoreControl.translate((String)"gui.particle.spread.speedx"), 0, 22));
                parent.addControl((GuiControl)new GuiTextfield("speedx", "" + (spread instanceof LittleParticleEmitter.ParticleSpreadRandom ? ((LittleParticleEmitter.ParticleSpreadRandom)spread).speedX : 0.1f), 43, 20, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("speedzLabel", CoreControl.translate((String)"gui.particle.spread.speedz"), 90, 22));
                parent.addControl((GuiControl)new GuiTextfield("speedz", "" + (spread instanceof LittleParticleEmitter.ParticleSpreadRandom ? ((LittleParticleEmitter.ParticleSpreadRandom)spread).speedZ : 0.1f), 145, 20, 40, 12).setFloatOnly());
            }
        });
        SubGuiParticle.registerParticleSpreadGuiHandler("circular", LittleParticleEmitter.ParticleSpreadCircular.class, new ParticleSpreadGuiHandler(){

            @Override
            public LittleParticleEmitter.ParticleSpread parse(GuiParent parent) {
                LittleParticleEmitter.ParticleSpreadCircular spread = new LittleParticleEmitter.ParticleSpreadCircular();
                GuiTextfield radius = (GuiTextfield)parent.get("radius");
                spread.radius = radius.parseFloat();
                GuiTextfield spreadT = (GuiTextfield)parent.get("deviation");
                spread.spread = spreadT.parseFloat();
                GuiTextfield speedy = (GuiTextfield)parent.get("speedy");
                spread.speedY = speedy.parseFloat();
                GuiTextfield steps = (GuiTextfield)parent.get("steps");
                spread.steps = steps.parseInteger();
                return spread;
            }

            @Override
            public void createControls(GuiParent parent, LittleParticleEmitter.ParticleSpread spread) {
                parent.addControl((GuiControl)new GuiLabel("speedyLabel", CoreControl.translate((String)"gui.particle.spread.speedy"), 0, 2));
                parent.addControl((GuiControl)new GuiTextfield("speedy", "" + spread.speedY, 43, 0, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("spreadLabel", CoreControl.translate((String)"gui.particle.spread.spread"), 90, 2));
                parent.addControl((GuiControl)new GuiTextfield("deviation", "" + spread.spread, 145, 0, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("radiusLabel", CoreControl.translate((String)"gui.particle.spread.radius"), 0, 22));
                parent.addControl((GuiControl)new GuiTextfield("radius", "" + (spread instanceof LittleParticleEmitter.ParticleSpreadCircular ? ((LittleParticleEmitter.ParticleSpreadCircular)spread).radius : 0.1f), 43, 20, 40, 12).setFloatOnly());
                parent.addControl((GuiControl)new GuiLabel("stepsLabel", CoreControl.translate((String)"gui.particle.spread.steps"), 90, 22));
                parent.addControl((GuiControl)new GuiTextfield("steps", "" + (spread instanceof LittleParticleEmitter.ParticleSpreadCircular ? ((LittleParticleEmitter.ParticleSpreadCircular)spread).steps : 30), 145, 20, 40, 12).setNumbersOnly());
            }
        });
    }

    public static abstract class ParticleSpreadGuiHandler {
        public abstract void createControls(GuiParent var1, LittleParticleEmitter.ParticleSpread var2);

        public abstract LittleParticleEmitter.ParticleSpread parse(GuiParent var1);
    }
}

