/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render.cache;

import com.creativemd.creativecore.client.rendering.model.BufferBuilderUtils;
import com.creativemd.littletiles.client.render.cache.ChunkBlockLayerManager;
import com.creativemd.littletiles.client.render.cache.LayeredRenderBufferCache;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.BufferBuilder;

public class BufferHolder {
    public static final Object BUFFER_CHANGE_LOCK = new Object();
    public final int length;
    public final int vertexCount;
    public final LayeredRenderBufferCache parent;
    public final int layer;
    private ChunkBlockLayerManager manager;
    private ByteBuffer byteBuffer;
    private int index = -1;
    private boolean removed = false;

    public BufferHolder(LayeredRenderBufferCache parent, int layer, BufferBuilder buffer) {
        this.parent = parent;
        this.layer = layer;
        this.length = BufferBuilderUtils.getBufferSizeByte((BufferBuilder)buffer);
        this.vertexCount = buffer.func_178989_h();
        this.byteBuffer = buffer.func_178966_f();
    }

    public BufferHolder(LayeredRenderBufferCache parent, int layer, ByteBuffer buffer, int byteSize, int count) {
        this.parent = parent;
        this.layer = layer;
        this.length = byteSize;
        this.vertexCount = count;
        this.byteBuffer = buffer;
    }

    public ChunkBlockLayerManager getManager() {
        return this.manager;
    }

    public int getIndex() {
        return this.index;
    }

    public void add(BufferBuilder builder) {
        int index = BufferBuilderUtils.getBufferSizeByte((BufferBuilder)builder);
        if (!this.hasBufferInRAM()) {
            throw new IllegalStateException("Buffer is still in VRAM");
        }
        this.index = index;
        BufferBuilderUtils.addBuffer((BufferBuilder)builder, (ByteBuffer)this.byteBuffer, (int)this.length, (int)this.vertexCount);
    }

    public boolean hasBufferInRAM() {
        return this.byteBuffer != null;
    }

    public void useVRAM(ChunkBlockLayerManager manager) {
        this.manager = manager;
        this.byteBuffer = null;
    }

    public void useRAM(ByteBuffer buffer) {
        this.byteBuffer = buffer;
        this.index = -1;
        this.manager = null;
    }

    public ByteBuffer getBufferRAM() {
        return this.byteBuffer;
    }

    public ByteBuffer tryGetBufferVRAM() {
        return this.manager.getTempBuffer(this);
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void remove() {
        this.parent.remove(this.layer);
    }

    public void onRemoved() {
        this.removed = true;
        this.byteBuffer = null;
        this.manager = null;
        this.index = -1;
    }
}

