/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.entity;

import com.creativemd.creativecore.common.utils.math.box.BoxUtils;
import com.creativemd.creativecore.common.utils.math.box.OrientatedBoundingBox;
import java.util.List;

public class AABBCombiner {
    public final double deviation;
    public final List<OrientatedBoundingBox> boxes;
    private boolean finished = false;
    private int i = -1;
    private int j = -1;
    public int timedOperation = 100;
    public long workingTime = 30000L;

    public AABBCombiner(List<OrientatedBoundingBox> boxes, double deviation) {
        this.boxes = boxes;
        this.deviation = deviation;
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public void work() {
        boolean skipThrough;
        long started = System.nanoTime();
        int operations = 0;
        boolean bl = skipThrough = this.i != -1;
        if (!skipThrough) {
            this.i = 0;
        }
        while (this.i < this.boxes.size()) {
            if (!skipThrough) {
                this.j = 0;
            }
            while (this.j < this.boxes.size()) {
                if (!skipThrough) {
                    OrientatedBoundingBox box;
                    if (this.i != this.j && (box = AABBCombiner.combineBoxes(this.boxes.get(this.i), this.boxes.get(this.j), this.deviation)) != null) {
                        if (this.i > this.j) {
                            this.boxes.remove(this.i);
                            this.boxes.remove(this.j);
                            --this.i;
                        } else {
                            this.boxes.remove(this.j);
                            this.boxes.remove(this.i);
                        }
                        this.j = 0;
                        this.boxes.add(box);
                        continue;
                    }
                    if (++operations <= this.timedOperation && System.nanoTime() - started >= this.workingTime) {
                        return;
                    }
                    operations = 0;
                }
                skipThrough = false;
                ++this.j;
            }
            ++this.i;
        }
        this.finished = true;
    }

    public static OrientatedBoundingBox combineBoxes(OrientatedBoundingBox box1, OrientatedBoundingBox box2, double deviation) {
        boolean z;
        if (deviation == 0.0) {
            boolean z2;
            boolean x = box1.field_72340_a == box2.field_72340_a && box1.field_72336_d == box2.field_72336_d;
            boolean y = box1.field_72338_b == box2.field_72338_b && box1.field_72337_e == box2.field_72337_e;
            boolean bl = z2 = box1.field_72339_c == box2.field_72339_c && box1.field_72334_f == box2.field_72334_f;
            if (x && y && z2) {
                return box1;
            }
            if (x && y && box1.field_72334_f >= box2.field_72339_c && box1.field_72339_c <= box2.field_72334_f) {
                return new OrientatedBoundingBox(box1.origin, box1.field_72340_a, box1.field_72338_b, Math.min(box1.field_72339_c, box2.field_72339_c), box1.field_72336_d, box1.field_72337_e, Math.max(box1.field_72334_f, box2.field_72334_f));
            }
            if (x && z2 && box1.field_72337_e >= box2.field_72338_b && box1.field_72338_b <= box2.field_72337_e) {
                return new OrientatedBoundingBox(box1.origin, box1.field_72340_a, Math.min(box1.field_72338_b, box2.field_72338_b), box1.field_72339_c, box1.field_72336_d, Math.max(box1.field_72337_e, box2.field_72337_e), box1.field_72334_f);
            }
            if (y && z2 && box1.field_72336_d >= box2.field_72340_a && box1.field_72340_a <= box2.field_72336_d) {
                return new OrientatedBoundingBox(box1.origin, Math.min(box1.field_72340_a, box2.field_72340_a), box1.field_72338_b, box1.field_72339_c, Math.max(box1.field_72336_d, box2.field_72336_d), box1.field_72337_e, box1.field_72334_f);
            }
            return null;
        }
        boolean x = BoxUtils.equals((double)box1.field_72340_a, (double)box2.field_72340_a, (double)deviation) && BoxUtils.equals((double)box1.field_72336_d, (double)box2.field_72336_d, (double)deviation);
        boolean y = BoxUtils.equals((double)box1.field_72338_b, (double)box2.field_72338_b, (double)deviation) && BoxUtils.equals((double)box1.field_72337_e, (double)box2.field_72337_e, (double)deviation);
        boolean bl = z = BoxUtils.equals((double)box1.field_72339_c, (double)box2.field_72339_c, (double)deviation) && BoxUtils.equals((double)box1.field_72334_f, (double)box2.field_72334_f, (double)deviation);
        if (x && y && z) {
            return AABBCombiner.sumBox(box1, box2);
        }
        if (x && y && BoxUtils.greaterEquals((double)box1.field_72334_f, (double)box2.field_72339_c, (double)deviation) && BoxUtils.greaterEquals((double)box2.field_72334_f, (double)box1.field_72339_c, (double)deviation)) {
            return AABBCombiner.sumBox(box1, box2);
        }
        if (x && z && BoxUtils.greaterEquals((double)box1.field_72337_e, (double)box2.field_72338_b, (double)deviation) && BoxUtils.greaterEquals((double)box2.field_72337_e, (double)box1.field_72338_b, (double)deviation)) {
            return AABBCombiner.sumBox(box1, box2);
        }
        if (y && z && BoxUtils.greaterEquals((double)box1.field_72336_d, (double)box2.field_72340_a, (double)deviation) && BoxUtils.greaterEquals((double)box2.field_72336_d, (double)box1.field_72340_a, (double)deviation)) {
            return AABBCombiner.sumBox(box1, box2);
        }
        return null;
    }

    public static OrientatedBoundingBox sumBox(OrientatedBoundingBox box1, OrientatedBoundingBox box2) {
        return new OrientatedBoundingBox(box1.origin, Math.min(box1.field_72340_a, box2.field_72340_a), Math.min(box1.field_72338_b, box2.field_72338_b), Math.min(box1.field_72339_c, box2.field_72339_c), Math.max(box1.field_72336_d, box2.field_72336_d), Math.max(box1.field_72337_e, box2.field_72337_e), Math.max(box1.field_72334_f, box2.field_72334_f));
    }
}

