/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.event;

import com.creativemd.creativecore.common.gui.opener.GuiHandler;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.client.event.PickBlockEvent;
import com.creativemd.littletiles.client.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.client.render.cache.ItemModelCache;
import com.creativemd.littletiles.client.render.cache.RenderingThread;
import com.creativemd.littletiles.client.render.overlay.PreviewRenderer;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.block.LittleActionPlaceStack;
import com.creativemd.littletiles.common.api.ILittleIngredientInventory;
import com.creativemd.littletiles.common.api.ILittlePlacer;
import com.creativemd.littletiles.common.api.ILittleTool;
import com.creativemd.littletiles.common.block.BlockTile;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.structure.signal.schedule.SignalTicker;
import com.creativemd.littletiles.common.structure.type.LittleBed;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.ingredient.LittleIngredients;
import com.creativemd.littletiles.common.util.ingredient.LittleInventory;
import com.creativemd.littletiles.common.util.ingredient.NotEnoughIngredientsException;
import com.creativemd.littletiles.common.util.place.PlacementHelper;
import com.creativemd.littletiles.common.util.place.PlacementMode;
import com.creativemd.littletiles.common.util.place.PlacementPosition;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IntHashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleEventHandler {
    public static ItemStack lastSelectedItem = null;
    public static ILittleTool tool = null;
    @SideOnly(value=Side.CLIENT)
    private boolean leftClicked;
    @SideOnly(value=Side.CLIENT)
    private static ResourceLocation RES_UNDERWATER_OVERLAY;
    private static Field setTileEntitiesField;
    @SideOnly(value=Side.CLIENT)
    public static int transparencySortingIndex;
    private static Field prevRenderSortX;
    private static Field prevRenderSortY;
    private static Field prevRenderSortZ;
    @SideOnly(value=Side.CLIENT)
    private static List<RenderChunk> queuedRenderChunksUpdate;
    private static final HashSet<LittleStructure> queuedUpdateStructures;
    private static final HashSet<LittleStructure> queuedStructures;
    private static Field entitiesById;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onMouseWheelClick(PickBlockEvent event) {
        ItemStack stack;
        if (event.result != null && event.result.field_72313_a == RayTraceResult.Type.BLOCK && (stack = event.player.func_184614_ca()).func_77973_b() instanceof ILittleTool && ((ILittleTool)stack.func_77973_b()).onMouseWheelClickBlock(event.world, event.player, stack, new PlacementPosition(event.result, ((ILittleTool)stack.func_77973_b()).getPositionContext(stack)), event.result)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickAir(PlayerInteractEvent.LeftClickEmpty event) {
        ItemStack stack;
        if (event.getWorld().field_72995_K && (stack = event.getItemStack()).func_77973_b() instanceof ILittleTool) {
            ((ILittleTool)stack.func_77973_b()).onClickAir(event.getEntityPlayer(), stack);
        }
    }

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getWorld().field_72995_K) {
            if (!this.leftClicked) {
                ItemStack stack = event.getItemStack();
                if (event.getHitVec() == null) {
                    return;
                }
                RayTraceResult ray = new RayTraceResult(event.getHitVec(), event.getFace(), event.getPos());
                if (lastSelectedItem != null && lastSelectedItem.func_77973_b() != stack.func_77973_b()) {
                    tool.onClickAir(event.getEntityPlayer(), lastSelectedItem);
                    lastSelectedItem = null;
                }
                if (stack.func_77973_b() instanceof ILittleTool) {
                    if (((ILittleTool)stack.func_77973_b()).onClickBlock(event.getWorld(), event.getEntityPlayer(), stack, new PlacementPosition(ray, ((ILittleTool)stack.func_77973_b()).getPositionContext(stack)), ray) && LittleTilesClient.INTERACTION.start(false)) {
                        event.setCanceled(true);
                    }
                    tool = (ILittleTool)stack.func_77973_b();
                    lastSelectedItem = stack;
                }
                this.leftClicked = true;
            }
        } else if (event.getItemStack().func_77973_b() instanceof ILittleTool) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderOverlay(RenderBlockOverlayEvent event) {
        double d0;
        BlockPos blockpos;
        EntityPlayer player;
        TileEntity te;
        if (RES_UNDERWATER_OVERLAY == null) {
            RES_UNDERWATER_OVERLAY = new ResourceLocation("textures/misc/underwater.png");
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (event.getOverlayType() == RenderBlockOverlayEvent.OverlayType.WATER && (te = player.field_70170_p.func_175625_s(blockpos = new BlockPos(player.field_70165_t, d0 = player.field_70163_u + (double)(player = event.getPlayer()).func_70047_e(), player.field_70161_v))) instanceof TileEntityLittleTiles) {
            AxisAlignedBB bb = player.func_174813_aQ();
            for (Pair<IParentTileList, LittleTile> pair : ((TileEntityLittleTiles)te).allTiles()) {
                LittleTile tile = (LittleTile)pair.value;
                if (!(tile instanceof LittleTileColored) || !tile.isMaterial(Material.field_151586_h) || !tile.getBox().getBox(((IParentTileList)pair.key).getContext(), blockpos).func_72326_a(bb)) continue;
                mc.func_110434_K().func_110577_a(RES_UNDERWATER_OVERLAY);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                float f = mc.field_71439_g.func_70013_c();
                Vec3d color = ColorUtils.IntToVec((int)((LittleTileColored)tile).color);
                GlStateManager.func_179131_c((float)(f * (float)color.field_72450_a), (float)(f * (float)color.field_72448_b), (float)(f * (float)color.field_72449_c), (float)0.5f);
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_179094_E();
                float f1 = 4.0f;
                float f2 = -1.0f;
                float f3 = 1.0f;
                float f4 = -1.0f;
                float f5 = 1.0f;
                float f6 = -0.5f;
                float f7 = -mc.field_71439_g.field_70177_z / 64.0f;
                float f8 = mc.field_71439_g.field_70125_A / 64.0f;
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(4.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(4.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + f7), (double)(0.0f + f8)).func_181675_d();
                bufferbuilder.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + f7), (double)(0.0f + f8)).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179084_k();
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack stack = event.getEntityPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof ILittleTool) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND);
        if (stack.func_77973_b() instanceof ILittleTool && event.getHand() == EnumHand.MAIN_HAND && event.getWorld().field_72995_K && this.onRightInteractClient((ILittleTool)stack.func_77973_b(), event.getEntityPlayer(), event.getHand(), event.getWorld(), stack, event.getPos(), event.getFace())) {
            event.setCanceled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public synchronized void worldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            LittleTile.MissingBlockHandler.unload();
            ItemModelCache.unload();
            for (int i = 0; i < RenderingThread.threads.size(); ++i) {
                RenderingThread thread = RenderingThread.threads.get(i);
                if (thread == null) continue;
                thread.interrupt();
                thread.updateCoords.clear();
                RenderingThread.threads.set(i, null);
            }
            RenderingThread.chunks.clear();
            if (setTileEntitiesField == null) {
                setTileEntitiesField = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"setTileEntities", "field_181024_n"});
            }
            try {
                Set set;
                Set set2 = set = (Set)setTileEntitiesField.get(Minecraft.func_71410_x().field_71438_f);
                synchronized (set2) {
                    set.clear();
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        } else {
            queuedUpdateStructures.clear();
            queuedStructures.clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static PlacementPosition getPosition(World world, ILittleTool iTile, ItemStack stack, RayTraceResult result) {
        return PreviewRenderer.marked != null ? PreviewRenderer.marked.getPosition() : PlacementHelper.getPosition(world, result, iTile.getPositionContext(stack), iTile, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onRightInteractClient(ILittleTool iTile, EntityPlayer player, EnumHand hand, World world, ItemStack stack, BlockPos pos, EnumFacing facing) {
        PlacementPosition position;
        if (iTile instanceof ILittleTool && iTile.onRightClick(world, player, stack, (position = LittleEventHandler.getPosition(world, iTile, stack, Minecraft.func_71410_x().field_71476_x)).copy(), Minecraft.func_71410_x().field_71476_x) && iTile instanceof ILittlePlacer && ((ILittlePlacer)iTile).hasLittlePreview(stack)) {
            if (player.func_175151_a(pos.func_177972_a(facing), facing, stack) && LittleTilesClient.INTERACTION.start(true)) {
                PlacementMode mode = ((ILittlePlacer)iTile).getPlacementMode(stack).place();
                new LittleActionPlaceStack(((ILittlePlacer)iTile).getLittlePreview(stack, false), position, PreviewRenderer.isCentered(player, stack, (ILittlePlacer)iTile), PreviewRenderer.isFixed(player, stack, (ILittlePlacer)iTile), mode).execute();
                PreviewRenderer.marked = null;
            }
            iTile.onDeselect(world, stack, player);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void isSleepingLocationAllowed(SleepingLocationCheckEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed && ((LittleBed)bed).getSleepingPlayer() == event.getEntityPlayer()) {
                event.setResult(Event.Result.ALLOW);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.player);
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).setSleepingPlayer(null);
            }
            LittleBed.littleBed.set(event.player, null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onWakeUp(PlayerWakeUpEvent event) {
        try {
            LittleStructure bed = (LittleStructure)LittleBed.littleBed.get(event.getEntityPlayer());
            if (bed instanceof LittleBed) {
                ((LittleBed)bed).setSleepingPlayer(null);
            }
            LittleBed.littleBed.set(event.getEntityPlayer(), null);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityItem entityItem = event.getItem();
        ItemStack stack = entityItem.func_92059_d();
        if (stack.func_77973_b() instanceof ILittleIngredientInventory && ((ILittleIngredientInventory)stack.func_77973_b()).shouldBeMerged()) {
            LittleIngredients ingredients = ((ILittleIngredientInventory)stack.func_77973_b()).getInventory(stack);
            LittleInventory inventory = new LittleInventory(player);
            inventory.allowDrop = false;
            if (ingredients == null) {
                entityItem.func_70106_y();
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
                return;
            }
            try {
                if (LittleAction.canGive(player, inventory, ingredients)) {
                    LittleAction.give(player, inventory, ingredients);
                    player.func_71001_a((Entity)entityItem, 1);
                    entityItem.func_70106_y();
                    event.setCanceled(true);
                    event.setResult(Event.Result.DENY);
                }
            }
            catch (NotEnoughIngredientsException notEnoughIngredientsException) {
                // empty catch block
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerSleep(PlayerSleepInBedEvent event) {
        TileEntityLittleTiles te;
        if (event.getEntityPlayer().field_70170_p.func_180495_p(event.getPos()).func_177230_c() instanceof BlockTile && (te = BlockTile.loadTe((IBlockAccess)event.getEntityPlayer().field_70170_p, event.getPos())) != null) {
            for (LittleStructure structure : te.loadedStructures()) {
                if (!(structure instanceof LittleBed) || !((LittleBed)structure).hasBeenActivated) continue;
                try {
                    ((LittleBed)structure).trySleep(event.getEntityPlayer(), structure.getHighestCenterVec());
                    event.setResult(EntityPlayer.SleepResult.OK);
                    ((LittleBed)structure).hasBeenActivated = false;
                    return;
                }
                catch (CorruptedConnectionException | NotYetConnectedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && mc.field_71438_f != null) {
                Entity entityIn;
                if (prevRenderSortX == null) {
                    prevRenderSortX = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortX", "field_147596_f"});
                    prevRenderSortY = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortY", "field_147597_g"});
                    prevRenderSortZ = ReflectionHelper.findField(RenderGlobal.class, (String[])new String[]{"prevRenderSortZ", "field_147602_h"});
                }
                if ((entityIn = mc.func_175606_aa()) == null) {
                    return;
                }
                try {
                    double d0 = entityIn.field_70165_t - prevRenderSortX.getDouble(mc.field_71438_f);
                    double d1 = entityIn.field_70163_u - prevRenderSortY.getDouble(mc.field_71438_f);
                    double d2 = entityIn.field_70161_v - prevRenderSortZ.getDouble(mc.field_71438_f);
                    if (d0 * d0 + d1 * d1 + d2 * d2 > 1.0) {
                        ++transparencySortingIndex;
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public static void queueChunkUpdate(RenderChunk chunk) {
        if (queuedRenderChunksUpdate == null) {
            queuedRenderChunksUpdate = new ArrayList<RenderChunk>();
        }
        List<RenderChunk> list = queuedRenderChunksUpdate;
        synchronized (list) {
            if (!queuedRenderChunksUpdate.contains(chunk)) {
                queuedRenderChunksUpdate.add(chunk);
            }
        }
    }

    public static synchronized void queueStructureForUpdatePacket(LittleStructure structure) {
        if (structure.getWorld().field_72995_K) {
            return;
        }
        queuedUpdateStructures.add(structure);
    }

    public static synchronized void queueStructureForNextTick(LittleStructure structure) {
        if (structure.getWorld().field_72995_K) {
            return;
        }
        queuedStructures.add(structure);
    }

    @SubscribeEvent
    public synchronized void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (!queuedUpdateStructures.isEmpty()) {
            for (LittleStructure structure : queuedUpdateStructures) {
                structure.sendUpdatePacket();
            }
            queuedUpdateStructures.clear();
        }
        if (!queuedStructures.isEmpty()) {
            Iterator<LittleStructure> iterator = queuedStructures.iterator();
            while (iterator.hasNext()) {
                LittleStructure structure;
                structure = iterator.next();
                if (structure.queueTick()) continue;
                iterator.remove();
            }
        }
        SignalTicker.serverTick();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (queuedRenderChunksUpdate == null) {
                queuedRenderChunksUpdate = new ArrayList<RenderChunk>();
            }
            List<RenderChunk> list = queuedRenderChunksUpdate;
            synchronized (list) {
                if (!queuedRenderChunksUpdate.isEmpty()) {
                    Iterator<RenderChunk> iterator = queuedRenderChunksUpdate.iterator();
                    while (iterator.hasNext()) {
                        RenderChunk chunk = iterator.next();
                        if (chunk.func_178569_m()) continue;
                        chunk.func_178575_a(false);
                        iterator.remove();
                    }
                }
            }
            ItemModelCache.tick((World)mc.field_71441_e);
            if (this.leftClicked && !mc.field_71474_y.field_74312_F.func_151470_d()) {
                this.leftClicked = false;
            }
            if (mc.field_71439_g != null) {
                SubGuiConfigure gui;
                ItemStack stack = mc.field_71439_g.func_184614_ca();
                if (lastSelectedItem != null && lastSelectedItem.func_77973_b() != stack.func_77973_b()) {
                    tool.onDeselect((World)mc.field_71441_e, lastSelectedItem, (EntityPlayer)mc.field_71439_g);
                    lastSelectedItem = null;
                }
                while (LittleTilesClient.configure.func_151468_f()) {
                    if (!(stack.func_77973_b() instanceof ILittleTool) || (gui = ((ILittleTool)stack.func_77973_b()).getConfigureGUI((EntityPlayer)mc.field_71439_g, stack)) == null) continue;
                    GuiHandler.openGui((String)"configure", (NBTTagCompound)new NBTTagCompound());
                }
                while (LittleTilesClient.configureAdvanced.func_151468_f()) {
                    if (!(stack.func_77973_b() instanceof ILittleTool) || (gui = ((ILittleTool)stack.func_77973_b()).getConfigureGUIAdvanced((EntityPlayer)mc.field_71439_g, stack)) == null) continue;
                    GuiHandler.openGui((String)"configureadvanced", (NBTTagCompound)new NBTTagCompound());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean cancelEntitySpawn(WorldClient world, int entityID, Entity entity) {
        if (entity instanceof EntityAnimation) {
            ((EntityAnimation)entity).addDoor();
            if (((EntityAnimation)entity).spawnedInWorld) {
                entity.func_145769_d(entityID);
                try {
                    ((IntHashMap)entitiesById.get(world)).func_76038_a(entityID, (Object)entity);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
                return true;
            }
            ((EntityAnimation)entity).spawnedInWorld = true;
            return false;
        }
        return false;
    }

    static {
        queuedUpdateStructures = new HashSet();
        queuedStructures = new HashSet();
        entitiesById = ReflectionHelper.findField(World.class, (String[])new String[]{"entitiesById", "field_175729_l"});
    }
}

