/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.mod.chiselsandbits;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.block.BlockLittleDyeableTransparent;
import com.creativemd.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.LittleTileColored;
import com.creativemd.littletiles.common.tile.combine.BasicCombiner;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ChiselsAndBitsInteractor {
    public static boolean isChiselsAndBitsStructure(IBlockState state) {
        Block block = state.func_177230_c();
        Map blocks = ChiselsAndBits.getBlocks().getConversions();
        for (Block block2 : blocks.values()) {
            if (block != block2) continue;
            return true;
        }
        return false;
    }

    public static boolean isChiselsAndBitsStructure(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        Map blocks = ChiselsAndBits.getBlocks().getConversions();
        for (Block block2 : blocks.values()) {
            if (block != block2) continue;
            return true;
        }
        return false;
    }

    public static List<LittleTile> getTiles(VoxelBlob blob) {
        ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
        for (int x = 0; x < ChiselsAndBitsManager.convertingFrom; ++x) {
            for (int y = 0; y < ChiselsAndBitsManager.convertingFrom; ++y) {
                for (int z = 0; z < ChiselsAndBitsManager.convertingFrom; ++z) {
                    IBlockState state = ModUtil.getStateById((int)blob.get(x, y, z));
                    if (state.func_177230_c() == Blocks.field_150355_j) {
                        state = LittleTiles.dyeableBlockTransparent.func_176223_P().func_177226_a(BlockLittleDyeableTransparent.VARIANT, (Comparable)((Object)BlockLittleDyeableTransparent.LittleDyeableTransparent.WATER));
                    }
                    if (state.func_177230_c() == Blocks.field_150350_a) continue;
                    LittleTile tile = new LittleTile(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
                    tile.setBox(new LittleBox(new LittleVec(x, y, z)));
                    tiles.add(tile);
                }
            }
        }
        BasicCombiner.combine(tiles);
        return tiles;
    }

    public static LittlePreviews getPreviews(VoxelBlob blob) {
        List<LittleTile> tiles = ChiselsAndBitsInteractor.getTiles(blob);
        LittlePreviews previews = new LittlePreviews(LittleGridContext.get(ChiselsAndBitsManager.convertingFrom));
        for (LittleTile tile : tiles) {
            previews.addWithoutCheckingPreview(tile.getPreviewTile());
        }
        return previews;
    }

    public static LittlePreviews getPreviews(ItemStack stack) {
        if (ChiselsAndBitsInteractor.isChiselsAndBitsStructure(stack)) {
            return ChiselsAndBitsInteractor.getPreviews(ModUtil.getBlobFromStack((ItemStack)stack, null));
        }
        return null;
    }

    public static LittlePreviews getPreviews(TileEntity te) {
        if (te instanceof TileEntityBlockChiseled) {
            return ChiselsAndBitsInteractor.getPreviews(((TileEntityBlockChiseled)te).getBlob());
        }
        return null;
    }

    public static boolean isChiselsAndBitsStructure(TileEntity te) {
        return te instanceof TileEntityBlockChiseled;
    }

    public static List<LittleTile> getTiles(TileEntity te) {
        if (te instanceof TileEntityBlockChiseled) {
            return ChiselsAndBitsInteractor.getTiles(((TileEntityBlockChiseled)te).getBlob());
        }
        return null;
    }

    public static VoxelBlob getVoxelBlob(TileEntityLittleTiles te, boolean force) throws Exception {
        if (te.getContext().size > ChiselsAndBitsManager.convertingFrom) {
            throw new Exception("Invalid grid size of " + te.getContext() + "!");
        }
        LittleGridContext context = null;
        try {
            context = LittleGridContext.get(ChiselsAndBitsManager.convertingFrom);
            if (context == null) {
                throw new Exception();
            }
        }
        catch (Exception e) {
            throw new Exception("The grid-size 16 is not supported! Base=" + LittleGridContext.minSize + ", Multiplier=" + LittleGridContext.multiplier + ", Scale=" + LittleGridContext.gridSizes.length);
        }
        te.convertTo(context);
        LittleVec vec = new LittleVec(0, 0, 0);
        VoxelBlob blob = new VoxelBlob();
        for (Pair<IParentTileList, LittleTile> pair : te.allTiles()) {
            boolean convert;
            LittleTile tile = (LittleTile)pair.value;
            if (tile.getClass() == LittleTile.class) {
                convert = true;
            } else if (force) {
                if (tile.getClass() != LittleTileColored.class) continue;
                convert = true;
            } else {
                throw new Exception("Cannot convert " + tile.getClass() + " tile!");
            }
            if (!convert) continue;
            if (!force && tile.getBox().getClass() != LittleBox.class) {
                throw new Exception("Cannot convert " + tile.getBox().getClass() + " box!");
            }
            LittleBox box = new LittleBox(0, 0, 0, 0, 0, 0);
            for (int x = tile.getBox().minX; x < tile.getBox().maxX; ++x) {
                for (int y = tile.getBox().minY; y < tile.getBox().maxY; ++y) {
                    for (int z = tile.getBox().minZ; z < tile.getBox().maxZ; ++z) {
                        box.set(x, y, z, x + 1, y + 1, z + 1);
                        if (!tile.getBox().isSolid() && !tile.intersectsWith(box)) continue;
                        blob.set(x, y, z, Block.func_176210_f((IBlockState)tile.getBlockState()));
                    }
                }
            }
        }
        te.convertToSmallest();
        return blob;
    }
}

