/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.entity.EntityAnimation;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.type.door.LittleDoor;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import com.creativemd.littletiles.common.world.WorldAnimationHandler;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;

public class LittlePlacedAnimationPacket
extends CreativeCorePacket {
    public StructureLocation location;
    public UUID previousAnimation;

    public LittlePlacedAnimationPacket(StructureLocation location, UUID previousAnimation) {
        this.previousAnimation = previousAnimation;
        this.location = location;
    }

    public LittlePlacedAnimationPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation(this.location, buf);
        LittlePlacedAnimationPacket.writeString((ByteBuf)buf, (String)this.previousAnimation.toString());
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation(buf);
        this.previousAnimation = UUID.fromString(LittlePlacedAnimationPacket.readString((ByteBuf)buf));
    }

    public void executeClient(EntityPlayer player) {
        block3: {
            try {
                LittleStructure structure = this.location.find(player.field_70170_p);
                if (structure instanceof LittleDoor) {
                    ((LittleDoor)structure).waitingForApproval = false;
                }
            }
            catch (LittleActionException e) {
                EntityAnimation animation = WorldAnimationHandler.findAnimation(true, this.previousAnimation);
                if (animation == null || animation.controller == null) break block3;
                animation.controller.onServerPlaces();
            }
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

