/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.connection;

import com.creativemd.littletiles.common.structure.connection.StructureChildConnection;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.MissingChildException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ChildrenList
implements Iterable<StructureChildConnection> {
    private int size = 0;
    private List<StructureChildConnection> content = new ArrayList<StructureChildConnection>();

    public StructureChildConnection get(int index) throws CorruptedConnectionException, NotYetConnectedException {
        if (index >= this.content.size()) {
            throw new MissingChildException(index);
        }
        StructureChildConnection child = this.content.get(index);
        if (child != null) {
            return child;
        }
        throw new MissingChildException(index);
    }

    public void set(StructureChildConnection child) {
        while (this.content.size() <= child.childId) {
            this.content.add(null);
        }
        this.content.set(child.childId, child);
        this.size = this.countSize();
    }

    public void remove(int index) throws CorruptedConnectionException, NotYetConnectedException {
        StructureChildConnection child = this.get(index);
        if (!child.dynamic) {
            throw new RuntimeException("Cannot remove non dynamic child");
        }
        child.getStructure().removeParent();
        this.content.set(index, null);
        this.size = this.countSize();
    }

    @Override
    public Iterator<StructureChildConnection> iterator() {
        return new Iterator<StructureChildConnection>(){
            private Iterator<StructureChildConnection> iter;
            private StructureChildConnection next;
            {
                this.iter = ChildrenList.this.content.iterator();
                this.next = this.findNext();
            }

            StructureChildConnection findNext() {
                while (this.iter.hasNext()) {
                    StructureChildConnection child = this.iter.next();
                    if (child == null) continue;
                    return child;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public StructureChildConnection next() {
                StructureChildConnection toReturn = this.next;
                this.next = this.findNext();
                return toReturn;
            }
        };
    }

    private int countSize() {
        int size = 0;
        for (StructureChildConnection child : this.content) {
            if (child == null) continue;
            ++size;
        }
        return size;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int findFreeIndex() {
        for (int i = 0; i < this.content.size(); ++i) {
            if (this.content.get(i) != null) continue;
            return i;
        }
        return this.content.size();
    }
}

