/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.directional;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.structure.directional.StructureDirectionalField;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.tile.math.box.LittleBox;
import com.creativemd.littletiles.common.tile.math.vec.LittleVec;
import com.creativemd.littletiles.common.tile.place.PlacePreview;
import com.creativemd.littletiles.common.tile.preview.LittlePreviews;
import com.creativemd.littletiles.common.util.grid.LittleGridContext;
import java.lang.reflect.Field;
import java.util.HashMap;
import javax.vecmath.Vector3f;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.util.EnumFacing;

public abstract class StructureDirectionalType<T> {
    private static HashMap<Class, StructureDirectionalType> types = new HashMap();

    public static StructureDirectionalType getType(Field field) {
        StructureDirectionalType type = types.get(field.getType());
        if (type == null) {
            throw new RuntimeException("No registered directional type for " + field.getType() + ", " + field.getName());
        }
        return type;
    }

    public static <T> void registerType(Class<T> clazz, StructureDirectionalType<T> type) {
        if (types.containsKey(clazz)) {
            throw new IllegalArgumentException("Type already exists. " + clazz);
        }
        types.put(clazz, type);
    }

    public abstract T read(NBTBase var1);

    public abstract NBTBase write(T var1);

    public abstract T move(T var1, LittleGridContext var2, LittleVec var3);

    public abstract T flip(T var1, LittleGridContext var2, EnumFacing.Axis var3, LittleVec var4);

    public abstract T rotate(T var1, LittleGridContext var2, Rotation var3, LittleVec var4);

    public abstract T getDefault();

    public LittleGridContext getContext(T value) {
        return null;
    }

    public void convertToSmallest(T value) {
    }

    public void advancedScale(T value, int from, int to) {
    }

    public PlacePreview getPlacePreview(T value, LittlePreviews previews, StructureDirectionalField field) {
        return null;
    }

    static {
        StructureDirectionalType.registerType(EnumFacing.class, new StructureDirectionalType<EnumFacing>(){

            @Override
            public EnumFacing read(NBTBase nbt) {
                if (nbt instanceof NBTTagInt) {
                    return EnumFacing.field_82609_l[((NBTTagInt)nbt).func_150287_d()];
                }
                return null;
            }

            @Override
            public NBTBase write(EnumFacing value) {
                return new NBTTagInt(value.ordinal());
            }

            @Override
            public EnumFacing move(EnumFacing value, LittleGridContext context, LittleVec offset) {
                return value;
            }

            @Override
            public EnumFacing flip(EnumFacing value, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
                if (axis == value.func_176740_k()) {
                    return value.func_176734_d();
                }
                return value;
            }

            @Override
            public EnumFacing rotate(EnumFacing value, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
                return RotationUtils.rotate((EnumFacing)value, (Rotation)rotation);
            }

            @Override
            public EnumFacing getDefault() {
                return EnumFacing.EAST;
            }
        });
        StructureDirectionalType.registerType(EnumFacing.Axis.class, new StructureDirectionalType<EnumFacing.Axis>(){

            @Override
            public EnumFacing.Axis read(NBTBase nbt) {
                if (nbt instanceof NBTTagInt) {
                    return EnumFacing.Axis.values()[((NBTTagInt)nbt).func_150287_d()];
                }
                return null;
            }

            @Override
            public NBTBase write(EnumFacing.Axis value) {
                return new NBTTagInt(value.ordinal());
            }

            @Override
            public EnumFacing.Axis move(EnumFacing.Axis value, LittleGridContext context, LittleVec offset) {
                return value;
            }

            @Override
            public EnumFacing.Axis flip(EnumFacing.Axis value, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
                return value;
            }

            @Override
            public EnumFacing.Axis rotate(EnumFacing.Axis value, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
                return RotationUtils.rotate((EnumFacing.Axis)value, (Rotation)rotation);
            }

            @Override
            public EnumFacing.Axis getDefault() {
                return EnumFacing.Axis.X;
            }
        });
        StructureDirectionalType.registerType(StructureRelative.class, new StructureDirectionalType<StructureRelative>(){

            @Override
            public StructureRelative read(NBTBase nbt) {
                if (nbt instanceof NBTTagIntArray) {
                    return new StructureRelative(((NBTTagIntArray)nbt).func_150302_c());
                }
                return null;
            }

            @Override
            public NBTBase write(StructureRelative value) {
                return new NBTTagIntArray(value.write());
            }

            @Override
            public StructureRelative move(StructureRelative value, LittleGridContext context, LittleVec offset) {
                value.move(context, offset);
                return value;
            }

            @Override
            public StructureRelative flip(StructureRelative value, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
                value.flip(context, axis, doubledCenter);
                return value;
            }

            @Override
            public StructureRelative rotate(StructureRelative value, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
                value.rotate(context, rotation, doubledCenter);
                return value;
            }

            @Override
            public LittleGridContext getContext(StructureRelative value) {
                return value.getContext();
            }

            @Override
            public void convertToSmallest(StructureRelative value) {
                value.convertToSmallest();
            }

            @Override
            public void advancedScale(StructureRelative value, int from, int to) {
                value.advancedScale(from, to);
            }

            @Override
            public PlacePreview getPlacePreview(StructureRelative value, LittlePreviews previews, StructureDirectionalField field) {
                return value.getPlacePreview(previews, field);
            }

            @Override
            public StructureRelative getDefault() {
                return new StructureRelative(new LittleBox(0, 0, 0, 1, 1, 1), LittleGridContext.get());
            }
        });
        StructureDirectionalType.registerType(Vector3f.class, new StructureDirectionalType<Vector3f>(){

            @Override
            public Vector3f read(NBTBase nbt) {
                int[] array;
                if (nbt instanceof NBTTagIntArray && (array = ((NBTTagIntArray)nbt).func_150302_c()).length == 3) {
                    return new Vector3f(Float.intBitsToFloat(array[0]), Float.intBitsToFloat(array[1]), Float.intBitsToFloat(array[2]));
                }
                return null;
            }

            @Override
            public NBTBase write(Vector3f value) {
                return new NBTTagIntArray(new int[]{Float.floatToIntBits(value.x), Float.floatToIntBits(value.y), Float.floatToIntBits(value.z)});
            }

            @Override
            public Vector3f move(Vector3f value, LittleGridContext context, LittleVec offset) {
                return value;
            }

            @Override
            public Vector3f flip(Vector3f value, LittleGridContext context, EnumFacing.Axis axis, LittleVec doubledCenter) {
                RotationUtils.flip((Vector3f)value, (EnumFacing.Axis)axis);
                return value;
            }

            @Override
            public Vector3f rotate(Vector3f value, LittleGridContext context, Rotation rotation, LittleVec doubledCenter) {
                RotationUtils.rotate((Vector3f)value, (Rotation)rotation);
                return value;
            }

            @Override
            public Vector3f getDefault() {
                return new Vector3f();
            }
        });
    }
}

