/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.logic;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.logic.SignalCondition;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.HashMap;
import net.minecraft.nbt.NBTTagCompound;

public abstract class SignalEvent {
    private static HashMap<String, Class<? extends SignalEvent>> eventTypes = new HashMap();
    private static HashMap<Class<? extends SignalEvent>, String> eventTypesInv = new HashMap();
    public SignalCondition condition;

    public static void registerEventType(String id, Class<? extends SignalEvent> type) {
        if (eventTypes.containsKey(id)) {
            throw new IllegalArgumentException("id " + id + " is already taken");
        }
        try {
            type.getConstructor(NBTTagCompound.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new IllegalArgumentException("Invalid event type missing nbt constructor " + id);
        }
        eventTypes.put(id, type);
        eventTypesInv.put(type, id);
    }

    public static SignalEvent loadFromNBT(NBTTagCompound nbt) {
        Class<? extends SignalEvent> type = SignalEvent.get(nbt.func_74779_i("id"));
        if (type == null) {
            throw new RuntimeException("No event type found for " + nbt.func_74779_i("id"));
        }
        try {
            return type.getConstructor(NBTTagCompound.class).newInstance(nbt);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException("Invalid event type " + nbt.func_74779_i("id"));
        }
    }

    public static Class<? extends SignalEvent> get(String id) {
        return eventTypes.get(id);
    }

    public static String get(Class<? extends SignalEvent> type) {
        return eventTypesInv.get(type);
    }

    public SignalEvent(NBTTagCompound nbt) {
        try {
            this.condition = SignalCondition.parse(nbt.func_74779_i("condition"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    public abstract void update(LittleStructure var1, int var2, boolean[] var3, boolean[] var4);

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("condition", this.condition.write());
        nbt.func_74778_a("id", SignalEvent.get(this.getClass()));
        this.writeToNBTExtra(nbt);
        return nbt;
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);
}

