/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.signal.output;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.signal.component.ISignalComponent;
import com.creativemd.littletiles.common.structure.signal.logic.SignalMode;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import java.text.ParseException;
import java.util.ArrayList;

public abstract class SignalOutputCondition {
    public final SignalTarget target;
    public final int delay;

    public SignalOutputCondition(int delay, SignalTarget target) {
        this.target = target;
        this.delay = delay;
    }

    public abstract SignalMode getMode();

    public abstract void schedule(LittleStructure var1, boolean[] var2);

    public void performStateChange(LittleStructure structure, boolean[] state) {
        ISignalComponent component = this.target.getTarget(structure);
        if (component != null) {
            this.target.setState(component, state);
        }
    }

    public int getBandwidth(LittleStructure structure) {
        return this.target.getBandwidth(structure);
    }

    public String write() {
        int[] data = this.getExtraData();
        if (data.length == 0) {
            return this.target.write() + this.getMode().splitter;
        }
        String bracket = "[";
        for (int i = 0; i < data.length; ++i) {
            if (i > 0) {
                bracket = bracket + ",";
            }
            bracket = bracket + "" + data[i];
        }
        return bracket + "]" + this.target.write() + this.getMode().splitter;
    }

    public abstract int[] getExtraData();

    public static SignalOutputCondition create(LittleStructure structure, String pattern, SignalMode mode) throws ParseException {
        SignalPatternParser parser = new SignalPatternParser(pattern);
        SignalTarget target = SignalTarget.parseTarget(parser, true, false);
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        if (parser.lookForNext(true) == '{') {
            parser.next(true);
            if (parser.lookForNext(true) == '}') {
                while (numbers.add(parser.parseNumber())) {
                    char current = parser.next(true);
                    if (current == ',') continue;
                    if (current == '}') break;
                    throw parser.invalidChar(current);
                }
            }
        }
        if (numbers.isEmpty()) {
            numbers.add(1);
        }
        return mode.create(structure, numbers, target);
    }
}

